/*
 * #%L
 * Coser :: UI
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 - 2011 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package fr.ifremer.coser.ui.control;

import fr.ifremer.coser.CoserConstants.Category;
import fr.ifremer.coser.ui.control.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.*;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class ControlView extends jaxx.runtime.swing.Table implements JAXXObject, jaxx.runtime.JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN_CATCH = "beanCatch";
    public static final String PROPERTY_BEAN_HAUL = "beanHaul";
    public static final String PROPERTY_BEAN_LENGTH = "beanLength";
    public static final String PROPERTY_BEAN_STRATA = "beanStrata";
    public static final String PROPERTY_CAN_VALID_CONTROL = "canValidControl";
    public static final String PROPERTY_CONTROL = "control";
    public static final String PROPERTY_CONTROL_DATA_TABLE_SELECTION_MODEL_CATCH = "controlDataTableSelectionModelCatch";
    public static final String PROPERTY_CONTROL_DATA_TABLE_SELECTION_MODEL_HAUL = "controlDataTableSelectionModelHaul";
    public static final String PROPERTY_CONTROL_DATA_TABLE_SELECTION_MODEL_LENGTH = "controlDataTableSelectionModelLength";
    public static final String PROPERTY_CONTROL_DATA_TABLE_SELECTION_MODEL_STRATA = "controlDataTableSelectionModelStrata";
    public static final String PROPERTY_GLOBAL_CONTROL_ERROR_SELECTION_MODEL = "globalControlErrorSelectionModel";
    public static final String PROPERTY_HANDLER = "handler";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CONTROL_COMMENT_TEXT = "controlComment.text";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON4_ENABLED = "$JButton4.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVZzW8bRRSfhObDaZqmTZt+t6ENQhS0aZNSilr6EacljZy2ikOICF9je2pvu9lZZse1i1TEAYnCqRcQSByAGxIIKrgBB+DAgRMHLgj+ASSEOHBFvJldz+466/Gg7cFJ5733e7/35r2Zec6nf6I+n6EHb+Bm02J1l9vrxFq4sLp6tXSDlPkc8cvM9jhlKPjX04t619Dmilr3OTqyVhDmU6H5VJ6ue9Qlbsz6dAEN+fy2Q/waIZyjA0mLsu9PFZX4dNOrsxaqIpWG+uHff/Xeq7z+US9CTQ/YnYNQJrpZRZFsKqBeu8LRdvB0C0852K0CDWa7VeC7RazlHez7V/A6eQW9hgYKqN/DDMA4OmwessSQ9k2Po4HJZVxyyDGOHr7OLPs6I+uEWWXqw2fdhl9czqgDvOXPFZs0PE9a94NtDbsVhzCOjhrYzgfKMfNQAdK/wbxEsNsyjCy2lrG7gh27km9ZbhNZsUSmrFlKHbCKtIcmF5ZhbRYziG6HUGxafgOyabXWhWJO6ecmF2brnFMX1McS6sGyUNuptHco9MkigW3AkGMwPJjmJ9JIYgxOLhRwiThgtz1hJ1eTujvLmJMqZbdhb0t0ljYXaYVABk4YpD4fmhZsn0uzKEmj7bDgKUGltd49+uNCdiCpp3IqhXuTwoNlKFMo4Cv19RJhQLJcKxC3ymtRvvd2gJtOEaZxmtZxmjEEmdGBnEgBGZ5cKHqOza9hV3TWeCKhSpKsvrFwz2Q7+gV8mwJ8UIcWbnArj1klWI02b3vCRmA67ZUkF4X6E8pqC7Arg5UT0tuVpKdEQv2pWP0FvuYwx9Kf3K92d1IiLM4rwyPthkXiwFFuU1eWYgiT6BtRp0ktL529rKrZJNHxDf447CIW0ovi47LSnNQzi+zmO7ifTnG/ox10Htcd5fyq0jusd96y6uR6xiTyoJuU82dMI4/sYu7jRS3z/mSyrOLyaSVfU/JtpGILD8kCkyG8EN0JwXV0nKPdiXszqAtVXS+lxiyvhrazAyvNXTHNPHbLxDFSnYPMcNJRdTiMSvXZuaR8lDAGrxLJPDyxzyQiuyVIi1MmjLEoPldai4vE93GVRObRfuTEHRl2z74NlwBYY0tKI4tBYSEKi6O96QZCGLtAhX7QBRztT7cIxG02Qf10tAnEkc2IykEYzqP/I0Ox/lCKrea5E3s6KGHU1qniqPbvdGi9Eyl1uyu0Fx0UbJmvilX23hupfTKT0icJX48rX3cjX1WHlrAT3u0XRX2FlTWjews8nW7l6XBlDBwdoqxq3YBH9k1OvWAXmtbC6jIjREX5tsKZ2IiTPF7gToif9hxgLIHV6ciHZ5Jsr2Oqv+7GZfKxJE+kCfHxTnomT6pMRgojYW7gjbMun9HJp88yafILjMhaeT/2rJyj5brQh7tzTyIQ0LdawvgTq0bKN68xWmVQGvCy4OiRtI2qc1u82OB/Md3wkcDQvkRPwIRiRRNKNEL0rKE+VodlOEDXNg41SyAKxpndbeOMAJTSf8fHfvn6t68utWaYU+B7Z6pqbASD2cJj1INRwBautwYDjAhoahF7p9dQzpd7K+ez/SnEiqEYyIG/4FUv8zGP/RpA9A38+t0P4y///ADqvYSGHIorl7DQv4xyvAapqlGn0vTOnZeMhhuD8DkquHG0yYVxCZ4pZ2zXsV0ygTlMVKU6J2ebkIb9KWlQXEq5H/8ZK94/30pFD1Db01E9Skffc6g/8CYHOrGFAx0GuM2eT+oVGs1kaVNaj/g55IUV9Yn8/Cwt1tx1yAxvdeQXzbr4cV8yF799KYHGDYA22aIz0MgZcV5PlGy3AvV9Nh1vjwmeaA0Np+4YYvl7DcIhAxZ96+JcEeJv00EeMgAZhIG7QhhhmXDE8jcahKOZE9IdAV5bxBXFUtHAPJY5FDMEXSjdETjazGFqW7a9ZX2hZQ/HyhyOGYKOw3RmDmYIv2s4nMwchRmCLgozhD8yI3yuQThlUpyU2fAkkM9DTUJMoIbhsrNfJc8Su1rTFboJVr8jv0/QMDprlJ6fNAhzmREKmRGWMiOsZi6T500QesY0HMwQdmfloI3ixcwcjBCCg6cDAsl8bJgh6DhUM3MwQ9BxsDNzMELoOaCpyZsGp8wYrnOahzGKkyXaKFLGg7dTB1JvZm7W7ghAigGV1rh5wXFoQ/sKMiOl65y3MndOdwS4aBilfMX2bf0IcM8Aaosfn8Y16TYBG4UBreEvAbngr0B+RnKj4juDPHGcpe6PcRO8Ed76KmOxy4jQHa1bz7ybuW/fM5m4oMB1Wf7AnEWHOLojiCKSf768hm2XaxvsYwD7D1MGZrL8HQAA";
    public static final String PROPERTY$DOCUMENT0 = "$Document0";
    private static final Log log = LogFactory.getLog(fr.ifremer.coser.ui.control.ControlView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected fr.ifremer.coser.data.Catch beanCatch;
    protected fr.ifremer.coser.data.Haul beanHaul;
    protected fr.ifremer.coser.data.Length beanLength;
    protected fr.ifremer.coser.data.Strata beanStrata;
    protected java.lang.Boolean canValidControl;
    protected javax.swing.JComboBox categoryComboBox;
    protected fr.ifremer.coser.ui.control.ControlCategoryListModel categoryComboBoxModel;
    protected fr.ifremer.coser.ui.util.CoserProgressBar checkProgressBar;
    protected javax.swing.JButton compareNumberCatchLengthButton;
    protected fr.ifremer.coser.bean.Control control;
    protected javax.swing.JTextArea controlComment;
    protected javax.swing.JButton controlDataCancelButton;
    protected javax.swing.JButton controlDataDeleteButton;
    protected javax.swing.JTable controlDataTableCatch;
    protected javax.swing.JTable controlDataTableHaul;
    protected javax.swing.JTable controlDataTableLength;
    protected javax.swing.ListSelectionModel controlDataTableSelectionModelCatch;
    protected javax.swing.ListSelectionModel controlDataTableSelectionModelHaul;
    protected javax.swing.ListSelectionModel controlDataTableSelectionModelLength;
    protected javax.swing.ListSelectionModel controlDataTableSelectionModelStrata;
    protected javax.swing.JTable controlDataTableStrata;
    protected javax.swing.JButton controlDataValidButton;
    protected java.awt.CardLayout controlTablesLayout;
    protected javax.swing.JPanel controlTablesPanel;
    protected javax.swing.JPanel editionPanel;
    protected javax.swing.JScrollPane editionScrollPane;
    protected jaxx.runtime.validator.swing.SwingValidatorMessageTableModel errorsTableModel;
    protected fr.ifremer.coser.ui.control.GlobalControlErrorModel globalControlErrorModel;
    protected javax.swing.tree.TreeSelectionModel globalControlErrorSelectionModel;
    protected org.jdesktop.swingx.JXTreeTable globalControlErrorTable;
    protected fr.ifremer.coser.ui.control.ControlHandler handler;
    protected javax.swing.JTable validationMessagesTable;
    @Validator( validatorId = "validatorCatch")
    protected jaxx.runtime.validator.swing.SwingValidator< fr.ifremer.coser.data.Catch > validatorCatch;
    @Validator( validatorId = "validatorHaul")
    protected jaxx.runtime.validator.swing.SwingValidator< fr.ifremer.coser.data.Haul > validatorHaul;
    protected java.util.List<String> validatorIds = new ArrayList<String>();
    @Validator( validatorId = "validatorLength")
    protected jaxx.runtime.validator.swing.SwingValidator< fr.ifremer.coser.data.Length > validatorLength;
    @Validator( validatorId = "validatorStrata")
    protected jaxx.runtime.validator.swing.SwingValidator< fr.ifremer.coser.data.Strata > validatorStrata;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ControlView $Table0 = this;
    private javax.swing.JToolBar $JToolBar0;
    private javax.swing.JButton $JButton0;
    private javax.swing.JToolBar.Separator $JToolBar$Separator0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JToolBar.Separator $JToolBar$Separator1;
    private javax.swing.JButton $JButton1;
    private javax.swing.JButton $JButton2;
    private javax.swing.JToolBar.Separator $JToolBar$Separator2;
    private javax.swing.JButton $JButton3;
    private javax.swing.JToolBar.Separator $JToolBar$Separator3;
    private javax.swing.JButton $JButton4;
    private javax.swing.JSplitPane $JSplitPane0;
    private javax.swing.JScrollPane $JScrollPane0;
    private javax.swing.JScrollPane $JScrollPane1;
    private javax.swing.JScrollPane $JScrollPane2;
    private javax.swing.JScrollPane $JScrollPane3;
    private javax.swing.JSplitPane $JSplitPane1;
    private javax.swing.JSplitPane $JSplitPane2;
    private jaxx.runtime.swing.Table $Table1;
    private javax.swing.JScrollPane $JScrollPane4;
    private javax.swing.JSplitPane $JSplitPane3;
    private javax.swing.JScrollPane $JScrollPane5;
    private javax.swing.JPanel $JPanel0;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JScrollPane $JScrollPane6;
    private javax.swing.text.Document $Document0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void $afterCompleteSetup() {
            // bean validation
            jaxx.runtime.validator.swing.SwingValidatorUtil.installUI(validationMessagesTable,
                new jaxx.runtime.validator.swing.SwingValidatorMessageTableRenderer());
                
            // global validation
            SwingUtil.fixTableColumnWidth(globalControlErrorTable, 1, 25);
        }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ControlView() {
        $initialize();
    }

    public ControlView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidation implementation --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public jaxx.runtime.validator.swing.SwingValidator<?> getValidator(String validatorId) {
        return (jaxx.runtime.validator.swing.SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public java.util.List<String> getValidatorIds() {
        return validatorIds;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doInsertUpdate__on__$Document0(javax.swing.event.DocumentEvent event) {
        getControl().setComment(controlComment.getText());
    }

    public void doActionPerformed__on__$JButton4(java.awt.event.ActionEvent event) {
        getHandler().validControl(this);
    }

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        getHandler().saveControl(this);
    }

    public void doActionPerformed__on__$JButton1(java.awt.event.ActionEvent event) {
        getHandler().checkData(this);
    }

    public void doActionPerformed__on__$JButton2(java.awt.event.ActionEvent event) {
        getHandler().displayLengthStructureGraph(this);
    }

    public void doActionPerformed__on__$JButton3(java.awt.event.ActionEvent event) {
        getHandler().displayLogReport(this);
    }

    public void doActionPerformed__on__categoryComboBox(java.awt.event.ActionEvent event) {
        getHandler().categoryChanged(this, event);
    }

    public void doActionPerformed__on__compareNumberCatchLengthButton(java.awt.event.ActionEvent event) {
        getHandler().displayCompareNumberCatchGraph(this);
    }

    public void doActionPerformed__on__controlDataCancelButton(java.awt.event.ActionEvent event) {
        getHandler().cancelDataModification(this);
    }

    public void doActionPerformed__on__controlDataDeleteButton(java.awt.event.ActionEvent event) {
        getHandler().deleteData(this);
    }

    public void doActionPerformed__on__controlDataValidButton(java.awt.event.ActionEvent event) {
        getHandler().validDataModification(this);
    }

    public void doMouseClicked__on__controlDataTableCatch(java.awt.event.MouseEvent event) {
        getHandler().showDataTableContextMenu(this, event);
    }

    public void doMouseClicked__on__controlDataTableHaul(java.awt.event.MouseEvent event) {
        getHandler().showDataTableContextMenu(this, event);
    }

    public void doMouseClicked__on__controlDataTableLength(java.awt.event.MouseEvent event) {
        getHandler().showDataTableContextMenu(this, event);
    }

    public void doMouseClicked__on__controlDataTableStrata(java.awt.event.MouseEvent event) {
        getHandler().showDataTableContextMenu(this, event);
    }

    public void doMouseClicked__on__globalControlErrorTable(java.awt.event.MouseEvent event) {
        getHandler().globalErrorTableMouseCLicked(this, event);
    }

    public void doRemoveUpdate__on__$Document0(javax.swing.event.DocumentEvent event) {
        getControl().setComment(controlComment.getText());
    }

    public void doValueChanged__on__controlDataTableSelectionModelCatch(javax.swing.event.ListSelectionEvent event) {
        getHandler().controlDataTableSelectionChanged(this);
    }

    public void doValueChanged__on__controlDataTableSelectionModelHaul(javax.swing.event.ListSelectionEvent event) {
        getHandler().controlDataTableSelectionChanged(this);
    }

    public void doValueChanged__on__controlDataTableSelectionModelLength(javax.swing.event.ListSelectionEvent event) {
        getHandler().controlDataTableSelectionChanged(this);
    }

    public void doValueChanged__on__controlDataTableSelectionModelStrata(javax.swing.event.ListSelectionEvent event) {
        getHandler().controlDataTableSelectionChanged(this);
    }

    public void doValueChanged__on__globalControlErrorSelectionModel(javax.swing.event.TreeSelectionEvent event) {
        getHandler().showSelectedError(this, event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public fr.ifremer.coser.data.Catch getBeanCatch() {
        return beanCatch;
    }

    public fr.ifremer.coser.data.Haul getBeanHaul() {
        return beanHaul;
    }

    public fr.ifremer.coser.data.Length getBeanLength() {
        return beanLength;
    }

    public fr.ifremer.coser.data.Strata getBeanStrata() {
        return beanStrata;
    }

    public java.lang.Boolean getCanValidControl() {
        return canValidControl;
    }

    public javax.swing.JComboBox getCategoryComboBox() {
        return categoryComboBox;
    }

    public fr.ifremer.coser.ui.control.ControlCategoryListModel getCategoryComboBoxModel() {
        return categoryComboBoxModel;
    }

    public fr.ifremer.coser.ui.util.CoserProgressBar getCheckProgressBar() {
        return checkProgressBar;
    }

    public javax.swing.JButton getCompareNumberCatchLengthButton() {
        return compareNumberCatchLengthButton;
    }

    public fr.ifremer.coser.bean.Control getControl() {
        return control;
    }

    public javax.swing.JTextArea getControlComment() {
        return controlComment;
    }

    public javax.swing.JButton getControlDataCancelButton() {
        return controlDataCancelButton;
    }

    public javax.swing.JButton getControlDataDeleteButton() {
        return controlDataDeleteButton;
    }

    public javax.swing.JTable getControlDataTableCatch() {
        return controlDataTableCatch;
    }

    public javax.swing.JTable getControlDataTableHaul() {
        return controlDataTableHaul;
    }

    public javax.swing.JTable getControlDataTableLength() {
        return controlDataTableLength;
    }

    public javax.swing.ListSelectionModel getControlDataTableSelectionModelCatch() {
        return controlDataTableSelectionModelCatch;
    }

    public javax.swing.ListSelectionModel getControlDataTableSelectionModelHaul() {
        return controlDataTableSelectionModelHaul;
    }

    public javax.swing.ListSelectionModel getControlDataTableSelectionModelLength() {
        return controlDataTableSelectionModelLength;
    }

    public javax.swing.ListSelectionModel getControlDataTableSelectionModelStrata() {
        return controlDataTableSelectionModelStrata;
    }

    public javax.swing.JTable getControlDataTableStrata() {
        return controlDataTableStrata;
    }

    public javax.swing.JButton getControlDataValidButton() {
        return controlDataValidButton;
    }

    public java.awt.CardLayout getControlTablesLayout() {
        return controlTablesLayout;
    }

    public javax.swing.JPanel getControlTablesPanel() {
        return controlTablesPanel;
    }

    public javax.swing.JPanel getEditionPanel() {
        return editionPanel;
    }

    public javax.swing.JScrollPane getEditionScrollPane() {
        return editionScrollPane;
    }

    public jaxx.runtime.validator.swing.SwingValidatorMessageTableModel getErrorsTableModel() {
        return errorsTableModel;
    }

    public fr.ifremer.coser.ui.control.GlobalControlErrorModel getGlobalControlErrorModel() {
        return globalControlErrorModel;
    }

    public javax.swing.tree.TreeSelectionModel getGlobalControlErrorSelectionModel() {
        return globalControlErrorSelectionModel;
    }

    public org.jdesktop.swingx.JXTreeTable getGlobalControlErrorTable() {
        return globalControlErrorTable;
    }

    public fr.ifremer.coser.ui.control.ControlHandler getHandler() {
        return handler;
    }

    public javax.swing.JTable getValidationMessagesTable() {
        return validationMessagesTable;
    }

    public jaxx.runtime.validator.swing.SwingValidator< fr.ifremer.coser.data.Catch > getValidatorCatch() {
        return validatorCatch;
    }

    public jaxx.runtime.validator.swing.SwingValidator< fr.ifremer.coser.data.Haul > getValidatorHaul() {
        return validatorHaul;
    }

    public jaxx.runtime.validator.swing.SwingValidator< fr.ifremer.coser.data.Length > getValidatorLength() {
        return validatorLength;
    }

    public jaxx.runtime.validator.swing.SwingValidator< fr.ifremer.coser.data.Strata > getValidatorStrata() {
        return validatorStrata;
    }

    public java.lang.Boolean isCanValidControl() {
        return canValidControl !=null && canValidControl;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void set$Document0(javax.swing.text.Document newValue) {
        javax.swing.text.Document oldValue = this.$Document0;
        this.$Document0 = newValue;
        firePropertyChange(PROPERTY$DOCUMENT0, oldValue, newValue);
    }

    public void setBeanCatch(fr.ifremer.coser.data.Catch newValue) {
        fr.ifremer.coser.data.Catch oldValue = this.beanCatch;
        this.beanCatch = newValue;
        firePropertyChange(PROPERTY_BEAN_CATCH, oldValue, newValue);
    }

    public void setBeanHaul(fr.ifremer.coser.data.Haul newValue) {
        fr.ifremer.coser.data.Haul oldValue = this.beanHaul;
        this.beanHaul = newValue;
        firePropertyChange(PROPERTY_BEAN_HAUL, oldValue, newValue);
    }

    public void setBeanLength(fr.ifremer.coser.data.Length newValue) {
        fr.ifremer.coser.data.Length oldValue = this.beanLength;
        this.beanLength = newValue;
        firePropertyChange(PROPERTY_BEAN_LENGTH, oldValue, newValue);
    }

    public void setBeanStrata(fr.ifremer.coser.data.Strata newValue) {
        fr.ifremer.coser.data.Strata oldValue = this.beanStrata;
        this.beanStrata = newValue;
        firePropertyChange(PROPERTY_BEAN_STRATA, oldValue, newValue);
    }

    public void setCanValidControl(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.canValidControl;
        this.canValidControl = newValue;
        firePropertyChange(PROPERTY_CAN_VALID_CONTROL, oldValue, newValue);
    }

    public void setControl(fr.ifremer.coser.bean.Control newValue) {
        fr.ifremer.coser.bean.Control oldValue = this.control;
        this.control = newValue;
        firePropertyChange(PROPERTY_CONTROL, oldValue, newValue);
    }

    public void setControlDataTableSelectionModelCatch(javax.swing.ListSelectionModel newValue) {
        javax.swing.ListSelectionModel oldValue = this.controlDataTableSelectionModelCatch;
        this.controlDataTableSelectionModelCatch = newValue;
        firePropertyChange(PROPERTY_CONTROL_DATA_TABLE_SELECTION_MODEL_CATCH, oldValue, newValue);
    }

    public void setControlDataTableSelectionModelHaul(javax.swing.ListSelectionModel newValue) {
        javax.swing.ListSelectionModel oldValue = this.controlDataTableSelectionModelHaul;
        this.controlDataTableSelectionModelHaul = newValue;
        firePropertyChange(PROPERTY_CONTROL_DATA_TABLE_SELECTION_MODEL_HAUL, oldValue, newValue);
    }

    public void setControlDataTableSelectionModelLength(javax.swing.ListSelectionModel newValue) {
        javax.swing.ListSelectionModel oldValue = this.controlDataTableSelectionModelLength;
        this.controlDataTableSelectionModelLength = newValue;
        firePropertyChange(PROPERTY_CONTROL_DATA_TABLE_SELECTION_MODEL_LENGTH, oldValue, newValue);
    }

    public void setControlDataTableSelectionModelStrata(javax.swing.ListSelectionModel newValue) {
        javax.swing.ListSelectionModel oldValue = this.controlDataTableSelectionModelStrata;
        this.controlDataTableSelectionModelStrata = newValue;
        firePropertyChange(PROPERTY_CONTROL_DATA_TABLE_SELECTION_MODEL_STRATA, oldValue, newValue);
    }

    public void setGlobalControlErrorSelectionModel(javax.swing.tree.TreeSelectionModel newValue) {
        javax.swing.tree.TreeSelectionModel oldValue = this.globalControlErrorSelectionModel;
        this.globalControlErrorSelectionModel = newValue;
        firePropertyChange(PROPERTY_GLOBAL_CONTROL_ERROR_SELECTION_MODEL, oldValue, newValue);
    }

    public void setHandler(fr.ifremer.coser.ui.control.ControlHandler newValue) {
        fr.ifremer.coser.ui.control.ControlHandler oldValue = this.handler;
        this.handler = newValue;
        firePropertyChange(PROPERTY_HANDLER, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.installFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JToolBar get$JToolBar0() {
        return $JToolBar0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JToolBar.Separator get$JToolBar$Separator0() {
        return $JToolBar$Separator0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JToolBar.Separator get$JToolBar$Separator1() {
        return $JToolBar$Separator1;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    protected javax.swing.JButton get$JButton2() {
        return $JButton2;
    }

    protected javax.swing.JToolBar.Separator get$JToolBar$Separator2() {
        return $JToolBar$Separator2;
    }

    protected javax.swing.JButton get$JButton3() {
        return $JButton3;
    }

    protected javax.swing.JToolBar.Separator get$JToolBar$Separator3() {
        return $JToolBar$Separator3;
    }

    protected javax.swing.JButton get$JButton4() {
        return $JButton4;
    }

    protected javax.swing.JSplitPane get$JSplitPane0() {
        return $JSplitPane0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected javax.swing.JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected javax.swing.JScrollPane get$JScrollPane2() {
        return $JScrollPane2;
    }

    protected javax.swing.JScrollPane get$JScrollPane3() {
        return $JScrollPane3;
    }

    protected javax.swing.JSplitPane get$JSplitPane1() {
        return $JSplitPane1;
    }

    protected javax.swing.JSplitPane get$JSplitPane2() {
        return $JSplitPane2;
    }

    protected jaxx.runtime.swing.Table get$Table1() {
        return $Table1;
    }

    protected javax.swing.JScrollPane get$JScrollPane4() {
        return $JScrollPane4;
    }

    protected javax.swing.JSplitPane get$JSplitPane3() {
        return $JSplitPane3;
    }

    protected javax.swing.JScrollPane get$JScrollPane5() {
        return $JScrollPane5;
    }

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JScrollPane get$JScrollPane6() {
        return $JScrollPane6;
    }

    protected javax.swing.text.Document get$Document0() {
        return $Document0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToControlTablesPanel() {
        if (!allComponentsCreated) {
            return;
        }
        controlTablesPanel.add($JScrollPane0, Category.CATCH.toString());
        controlTablesPanel.add($JScrollPane1, Category.STRATA.toString());
        controlTablesPanel.add($JScrollPane2, Category.HAUL.toString());
        controlTablesPanel.add($JScrollPane3, Category.LENGTH.toString());
    }

    protected void addChildrenToEditionScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        editionScrollPane.getViewport().add($Table1);
    }

    protected void addChildrenToValidatorCatch() {
        if (!allComponentsCreated) {
            return;
        }
        validatorCatch.setErrorTableModel(errorsTableModel);
        validatorCatch.setUiClass(jaxx.runtime.validator.swing.ui.TranslucentValidationUI.class);
        validatorCatch.setBean(beanCatch);
    }

    protected void addChildrenToValidatorHaul() {
        if (!allComponentsCreated) {
            return;
        }
        validatorHaul.setErrorTableModel(errorsTableModel);
        validatorHaul.setUiClass(jaxx.runtime.validator.swing.ui.TranslucentValidationUI.class);
        validatorHaul.setBean(beanHaul);
    }

    protected void addChildrenToValidatorLength() {
        if (!allComponentsCreated) {
            return;
        }
        validatorLength.setErrorTableModel(errorsTableModel);
        validatorLength.setUiClass(jaxx.runtime.validator.swing.ui.TranslucentValidationUI.class);
        validatorLength.setBean(beanLength);
    }

    protected void addChildrenToValidatorStrata() {
        if (!allComponentsCreated) {
            return;
        }
        validatorStrata.setErrorTableModel(errorsTableModel);
        validatorStrata.setUiClass(jaxx.runtime.validator.swing.ui.TranslucentValidationUI.class);
        validatorStrata.setBean(beanStrata);
    }

    protected void createBeanCatch() {
        $objectMap.put("beanCatch", beanCatch = null);
    }

    protected void createBeanHaul() {
        $objectMap.put("beanHaul", beanHaul = null);
    }

    protected void createBeanLength() {
        $objectMap.put("beanLength", beanLength = null);
    }

    protected void createBeanStrata() {
        $objectMap.put("beanStrata", beanStrata = null);
    }

    protected void createCanValidControl() {
        $objectMap.put("canValidControl", canValidControl = false);
    }

    protected void createCategoryComboBox() {
        $objectMap.put("categoryComboBox", categoryComboBox = new javax.swing.JComboBox());
        
        categoryComboBox.setName("categoryComboBox");
        categoryComboBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__categoryComboBox"));
    }

    protected void createCategoryComboBoxModel() {
        $objectMap.put("categoryComboBoxModel", categoryComboBoxModel = new fr.ifremer.coser.ui.control.ControlCategoryListModel());
    }

    protected void createCheckProgressBar() {
        $objectMap.put("checkProgressBar", checkProgressBar = new fr.ifremer.coser.ui.util.CoserProgressBar());
        
        checkProgressBar.setName("checkProgressBar");
        checkProgressBar.setStringPainted(true);
    }

    protected void createCompareNumberCatchLengthButton() {
        $objectMap.put("compareNumberCatchLengthButton", compareNumberCatchLengthButton = new javax.swing.JButton());
        
        compareNumberCatchLengthButton.setName("compareNumberCatchLengthButton");
        compareNumberCatchLengthButton.setEnabled(false);
        compareNumberCatchLengthButton.setText(_("coser.ui.graph.compareNumberCatchLength"));
        compareNumberCatchLengthButton.setToolTipText(_("coser.ui.graph.compareNumberCatchLengthTip"));
        compareNumberCatchLengthButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__compareNumberCatchLengthButton"));
    }

    protected void createControl() {
        $objectMap.put("control", control = null);
    }

    protected void createControlComment() {
        $objectMap.put("controlComment", controlComment = new javax.swing.JTextArea());
        
        controlComment.setName("controlComment");
        controlComment.setColumns(15);
        controlComment.setLineWrap(true);
        controlComment.setWrapStyleWord(true);
        controlComment.setRows(3);
    }

    protected void createControlDataCancelButton() {
        $objectMap.put("controlDataCancelButton", controlDataCancelButton = new javax.swing.JButton());
        
        controlDataCancelButton.setName("controlDataCancelButton");
        controlDataCancelButton.setEnabled(false);
        controlDataCancelButton.setText(_("coser.ui.common.cancel"));
        controlDataCancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__controlDataCancelButton"));
    }

    protected void createControlDataDeleteButton() {
        $objectMap.put("controlDataDeleteButton", controlDataDeleteButton = new javax.swing.JButton());
        
        controlDataDeleteButton.setName("controlDataDeleteButton");
        controlDataDeleteButton.setEnabled(false);
        controlDataDeleteButton.setText(_("coser.ui.control.deleteLine"));
        controlDataDeleteButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__controlDataDeleteButton"));
    }

    protected void createControlDataTableCatch() {
        $objectMap.put("controlDataTableCatch", controlDataTableCatch = new javax.swing.JTable());
        
        controlDataTableCatch.setName("controlDataTableCatch");
        controlDataTableCatch.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__controlDataTableCatch"));
    }

    protected void createControlDataTableHaul() {
        $objectMap.put("controlDataTableHaul", controlDataTableHaul = new javax.swing.JTable());
        
        controlDataTableHaul.setName("controlDataTableHaul");
        controlDataTableHaul.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__controlDataTableHaul"));
    }

    protected void createControlDataTableLength() {
        $objectMap.put("controlDataTableLength", controlDataTableLength = new javax.swing.JTable());
        
        controlDataTableLength.setName("controlDataTableLength");
        controlDataTableLength.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__controlDataTableLength"));
    }

    protected void createControlDataTableSelectionModelCatch() {
        $objectMap.put("controlDataTableSelectionModelCatch", controlDataTableSelectionModelCatch = controlDataTableCatch.getSelectionModel());
        
        controlDataTableSelectionModelCatch.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__controlDataTableSelectionModelCatch"));
    }

    protected void createControlDataTableSelectionModelHaul() {
        $objectMap.put("controlDataTableSelectionModelHaul", controlDataTableSelectionModelHaul = controlDataTableHaul.getSelectionModel());
        
        controlDataTableSelectionModelHaul.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__controlDataTableSelectionModelHaul"));
    }

    protected void createControlDataTableSelectionModelLength() {
        $objectMap.put("controlDataTableSelectionModelLength", controlDataTableSelectionModelLength = controlDataTableLength.getSelectionModel());
        
        controlDataTableSelectionModelLength.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__controlDataTableSelectionModelLength"));
    }

    protected void createControlDataTableSelectionModelStrata() {
        $objectMap.put("controlDataTableSelectionModelStrata", controlDataTableSelectionModelStrata = controlDataTableStrata.getSelectionModel());
        
        controlDataTableSelectionModelStrata.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__controlDataTableSelectionModelStrata"));
    }

    protected void createControlDataTableStrata() {
        $objectMap.put("controlDataTableStrata", controlDataTableStrata = new javax.swing.JTable());
        
        controlDataTableStrata.setName("controlDataTableStrata");
        controlDataTableStrata.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__controlDataTableStrata"));
    }

    protected void createControlDataValidButton() {
        $objectMap.put("controlDataValidButton", controlDataValidButton = new javax.swing.JButton());
        
        controlDataValidButton.setName("controlDataValidButton");
        controlDataValidButton.setEnabled(false);
        controlDataValidButton.setText(_("coser.ui.common.valid"));
        controlDataValidButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__controlDataValidButton"));
    }

    protected void createControlTablesLayout() {
        $objectMap.put("controlTablesLayout", controlTablesLayout = new java.awt.CardLayout());
    }

    protected void createControlTablesPanel() {
        $objectMap.put("controlTablesPanel", controlTablesPanel = new javax.swing.JPanel());
        
        controlTablesPanel.setName("controlTablesPanel");
        controlTablesPanel.setLayout(controlTablesLayout);
    }

    protected void createEditionPanel() {
        $objectMap.put("editionPanel", editionPanel = new javax.swing.JPanel());
        
        editionPanel.setName("editionPanel");
        editionPanel.setLayout(new GridBagLayout());
    }

    protected void createEditionScrollPane() {
        $objectMap.put("editionScrollPane", editionScrollPane = new javax.swing.JScrollPane());
        
        editionScrollPane.setName("editionScrollPane");
    }

    protected void createErrorsTableModel() {
        $objectMap.put("errorsTableModel", errorsTableModel = new jaxx.runtime.validator.swing.SwingValidatorMessageTableModel());
    }

    protected void createGlobalControlErrorModel() {
        $objectMap.put("globalControlErrorModel", globalControlErrorModel = new fr.ifremer.coser.ui.control.GlobalControlErrorModel());
    }

    protected void createGlobalControlErrorSelectionModel() {
        $objectMap.put("globalControlErrorSelectionModel", globalControlErrorSelectionModel = globalControlErrorTable.getTreeSelectionModel());
        
        globalControlErrorSelectionModel.addTreeSelectionListener(JAXXUtil.getEventListener(TreeSelectionListener.class, "valueChanged", this, "doValueChanged__on__globalControlErrorSelectionModel"));
    }

    protected void createGlobalControlErrorTable() {
        $objectMap.put("globalControlErrorTable", globalControlErrorTable = new org.jdesktop.swingx.JXTreeTable());
        
        globalControlErrorTable.setName("globalControlErrorTable");
        globalControlErrorTable.setRootVisible(false);
        globalControlErrorTable.setShowsRootHandles(true);
        globalControlErrorTable.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__globalControlErrorTable"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = null);
    }

    protected void createValidationMessagesTable() {
        $objectMap.put("validationMessagesTable", validationMessagesTable = new javax.swing.JTable());
        
        validationMessagesTable.setName("validationMessagesTable");
        validationMessagesTable.setAutoCreateRowSorter(true);
        validationMessagesTable.setRowSelectionAllowed(true);
    }

    protected void createValidatorCatch() {
        $objectMap.put("validatorCatch", validatorCatch = SwingValidatorUtil.newValidator(fr.ifremer.coser.data.Catch.class, null));
    }

    protected void createValidatorHaul() {
        $objectMap.put("validatorHaul", validatorHaul = SwingValidatorUtil.newValidator(fr.ifremer.coser.data.Haul.class, null));
    }

    protected void createValidatorLength() {
        $objectMap.put("validatorLength", validatorLength = SwingValidatorUtil.newValidator(fr.ifremer.coser.data.Length.class, null));
    }

    protected void createValidatorStrata() {
        $objectMap.put("validatorStrata", validatorStrata = SwingValidatorUtil.newValidator(fr.ifremer.coser.data.Strata.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $Table0
        add($JToolBar0, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        add($JSplitPane0, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(checkProgressBar, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JToolBar0
        $JToolBar0.add($JButton0);
        $JToolBar0.add($JToolBar$Separator0);
        $JToolBar0.add($JLabel0);
        $JToolBar0.add(categoryComboBox);
        $JToolBar0.add($JToolBar$Separator1);
        $JToolBar0.add($JButton1);
        $JToolBar0.add(compareNumberCatchLengthButton);
        $JToolBar0.add($JButton2);
        $JToolBar0.add($JToolBar$Separator2);
        $JToolBar0.add($JButton3);
        $JToolBar0.add($JToolBar$Separator3);
        $JToolBar0.add($JButton4);
        // inline complete setup of $JSplitPane0
        $JSplitPane0.add(controlTablesPanel, JSplitPane.LEFT);
        $JSplitPane0.add($JSplitPane1, JSplitPane.RIGHT);
        addChildrenToControlTablesPanel();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(controlDataTableCatch);
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(controlDataTableStrata);
        // inline complete setup of $JScrollPane2
        $JScrollPane2.getViewport().add(controlDataTableHaul);
        // inline complete setup of $JScrollPane3
        $JScrollPane3.getViewport().add(controlDataTableLength);
        // inline complete setup of $JSplitPane1
        $JSplitPane1.add($JSplitPane2, JSplitPane.LEFT);
        $JSplitPane1.add($JSplitPane3, JSplitPane.RIGHT);
        // inline complete setup of $JSplitPane2
        $JSplitPane2.add(editionScrollPane, JSplitPane.LEFT);
        $JSplitPane2.add($JScrollPane4, JSplitPane.RIGHT);
        addChildrenToEditionScrollPane();
        // inline complete setup of $Table1
        $Table1.add(controlDataValidButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(controlDataCancelButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(controlDataDeleteButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(editionPanel, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToValidatorCatch();
        addChildrenToValidatorHaul();
        addChildrenToValidatorStrata();
        addChildrenToValidatorLength();
        // inline complete setup of $JScrollPane4
        $JScrollPane4.getViewport().add(validationMessagesTable);
        // inline complete setup of $JSplitPane3
        $JSplitPane3.add($JScrollPane5, JSplitPane.LEFT);
        $JSplitPane3.add($JPanel0, JSplitPane.RIGHT);
        // inline complete setup of $JScrollPane5
        $JScrollPane5.getViewport().add(globalControlErrorTable);
        // inline complete setup of $JPanel0
        $JPanel0.add($JLabel1, BorderLayout.NORTH);
        $JPanel0.add($JScrollPane6, BorderLayout.CENTER);
        // inline complete setup of $JScrollPane6
        $JScrollPane6.getViewport().add(controlComment);
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 21 property setters
        $JButton0.setIcon(jaxx.runtime.SwingUtil.createImageIcon("disk.png"));
        categoryComboBox.setModel(categoryComboBoxModel);
        categoryComboBox.setRenderer(new fr.ifremer.coser.ui.control.ControlCategoryListRenderer());
        $JButton1.setIcon(jaxx.runtime.SwingUtil.createImageIcon("spellcheck.png"));
        compareNumberCatchLengthButton.setIcon(jaxx.runtime.SwingUtil.createImageIcon("chart_curve.png"));
        $JButton2.setIcon(jaxx.runtime.SwingUtil.createImageIcon("chart_bar.png"));
        $JButton3.setIcon(jaxx.runtime.SwingUtil.createImageIcon("report.png"));
        $JButton4.setIcon(jaxx.runtime.SwingUtil.createImageIcon("accept.png"));
        $JSplitPane0.setOrientation(JSplitPane.VERTICAL_SPLIT);
        controlDataTableCatch.setModel(new fr.ifremer.coser.ui.control.ControlDataTableModel(this, Category.CATCH));
        controlDataTableStrata.setModel(new fr.ifremer.coser.ui.control.ControlDataTableModel(this, Category.STRATA));
        controlDataTableHaul.setModel(new fr.ifremer.coser.ui.control.ControlDataTableModel(this, Category.HAUL));
        controlDataTableLength.setModel(new fr.ifremer.coser.ui.control.ControlDataTableModel(this, Category.LENGTH));
        $JSplitPane1.setOrientation(JSplitPane.VERTICAL_SPLIT);
        validationMessagesTable.setModel(errorsTableModel);
        globalControlErrorTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        globalControlErrorTable.setTreeCellRenderer(new ControlErrorTreeRenderer());
        globalControlErrorTable.setTreeTableModel(globalControlErrorModel);
        // late initializer
        // register 4 validator(s)
        validatorIds = SwingValidatorUtil.initUI(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$Table0", this);
        createHandler();
        createControl();
        createCanValidControl();
        // inline creation of $JToolBar0
        $objectMap.put("$JToolBar0", $JToolBar0 = new javax.swing.JToolBar());
        
        $JToolBar0.setName("$JToolBar0");
        $JToolBar0.setFloatable(false);
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("coser.ui.control.save"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JToolBar$Separator0
        $objectMap.put("$JToolBar$Separator0", $JToolBar$Separator0 = new javax.swing.JToolBar.Separator());
        
        $JToolBar$Separator0.setName("$JToolBar$Separator0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("coser.ui.control.categorylabel"));
        createCategoryComboBoxModel();
        createCategoryComboBox();
        // inline creation of $JToolBar$Separator1
        $objectMap.put("$JToolBar$Separator1", $JToolBar$Separator1 = new javax.swing.JToolBar.Separator());
        
        $JToolBar$Separator1.setName("$JToolBar$Separator1");
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("coser.ui.control.checkData"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        createCompareNumberCatchLengthButton();
        // inline creation of $JButton2
        $objectMap.put("$JButton2", $JButton2 = new javax.swing.JButton());
        
        $JButton2.setName("$JButton2");
        $JButton2.setText(_("coser.ui.graph.lengthStructure"));
        $JButton2.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton2"));
        // inline creation of $JToolBar$Separator2
        $objectMap.put("$JToolBar$Separator2", $JToolBar$Separator2 = new javax.swing.JToolBar.Separator());
        
        $JToolBar$Separator2.setName("$JToolBar$Separator2");
        // inline creation of $JButton3
        $objectMap.put("$JButton3", $JButton3 = new javax.swing.JButton());
        
        $JButton3.setName("$JButton3");
        $JButton3.setText(_("coser.ui.control.controlreport"));
        $JButton3.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton3"));
        // inline creation of $JToolBar$Separator3
        $objectMap.put("$JToolBar$Separator3", $JToolBar$Separator3 = new javax.swing.JToolBar.Separator());
        
        $JToolBar$Separator3.setName("$JToolBar$Separator3");
        // inline creation of $JButton4
        $objectMap.put("$JButton4", $JButton4 = new javax.swing.JButton());
        
        $JButton4.setName("$JButton4");
        $JButton4.setText(_("coser.ui.control.validcontrol"));
        $JButton4.setToolTipText(_("coser.ui.control.validcontroltip"));
        $JButton4.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton4"));
        // inline creation of $JSplitPane0
        $objectMap.put("$JSplitPane0", $JSplitPane0 = new javax.swing.JSplitPane());
        
        $JSplitPane0.setName("$JSplitPane0");
        $JSplitPane0.setName("splitpaneDataDetails");
        $JSplitPane0.setResizeWeight(0.3);
        createControlTablesLayout();
        createControlTablesPanel();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createControlDataTableCatch();
        createControlDataTableSelectionModelCatch();
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new javax.swing.JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createControlDataTableStrata();
        createControlDataTableSelectionModelStrata();
        // inline creation of $JScrollPane2
        $objectMap.put("$JScrollPane2", $JScrollPane2 = new javax.swing.JScrollPane());
        
        $JScrollPane2.setName("$JScrollPane2");
        createControlDataTableHaul();
        createControlDataTableSelectionModelHaul();
        // inline creation of $JScrollPane3
        $objectMap.put("$JScrollPane3", $JScrollPane3 = new javax.swing.JScrollPane());
        
        $JScrollPane3.setName("$JScrollPane3");
        createControlDataTableLength();
        createControlDataTableSelectionModelLength();
        // inline creation of $JSplitPane1
        $objectMap.put("$JSplitPane1", $JSplitPane1 = new javax.swing.JSplitPane());
        
        $JSplitPane1.setName("$JSplitPane1");
        $JSplitPane1.setName("splitpaneDetail");
        $JSplitPane1.setResizeWeight(0.5);
        // inline creation of $JSplitPane2
        $objectMap.put("$JSplitPane2", $JSplitPane2 = new javax.swing.JSplitPane());
        
        $JSplitPane2.setName("$JSplitPane2");
        $JSplitPane2.setName("splitpaneDataDetailError");
        $JSplitPane2.setResizeWeight(0.5);
        createEditionScrollPane();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new jaxx.runtime.swing.Table());
        
        $Table1.setName("$Table1");
        createControlDataValidButton();
        createControlDataCancelButton();
        createControlDataDeleteButton();
        createEditionPanel();
        createErrorsTableModel();
        createBeanCatch();
        createBeanHaul();
        createBeanStrata();
        createBeanLength();
        createValidatorCatch();
        createValidatorHaul();
        createValidatorStrata();
        createValidatorLength();
        // inline creation of $JScrollPane4
        $objectMap.put("$JScrollPane4", $JScrollPane4 = new javax.swing.JScrollPane());
        
        $JScrollPane4.setName("$JScrollPane4");
        createValidationMessagesTable();
        // inline creation of $JSplitPane3
        $objectMap.put("$JSplitPane3", $JSplitPane3 = new javax.swing.JSplitPane());
        
        $JSplitPane3.setName("$JSplitPane3");
        $JSplitPane3.setName("splitpaneGlobalErrorComment");
        $JSplitPane3.setResizeWeight(0.5);
        // inline creation of $JScrollPane5
        $objectMap.put("$JScrollPane5", $JScrollPane5 = new javax.swing.JScrollPane());
        
        $JScrollPane5.setName("$JScrollPane5");
        createGlobalControlErrorModel();
        createGlobalControlErrorTable();
        createGlobalControlErrorSelectionModel();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("coser.ui.control.comment"));
        // inline creation of $JScrollPane6
        $objectMap.put("$JScrollPane6", $JScrollPane6 = new javax.swing.JScrollPane());
        
        $JScrollPane6.setName("$JScrollPane6");
        createControlComment();
        // inline creation of $Document0
        $objectMap.put("$Document0", $Document0 = controlComment.getDocument());
        
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document0"));
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document0"));
        createCheckProgressBar();
        // inline creation of $Table0
        setName("$Table0");
        setName("controlView");
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON4_ENABLED, true ,"canValidControl") {
        
            @Override
            public void processDataBinding() {
                $JButton4.setEnabled(isCanValidControl());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CONTROL_COMMENT_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("control", this);
                if (getControl() != null) {
                    getControl().addPropertyChangeListener("comment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getControl() != null) {
                    jaxx.runtime.SwingUtil.setText(controlComment, getControl().getComment());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("control", this);
                if (getControl() != null) {
                    getControl().removePropertyChangeListener("comment", this);
                }
            }
        });
    }

}