/*
 * #%L
 * Coser :: UI
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 - 2011 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package fr.ifremer.coser.ui.project;

import fr.ifremer.coser.ui.project.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.*;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class ProjectSummaryView extends jaxx.runtime.swing.Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_HANDLER = "handler";
    public static final String PROPERTY_PROJECT = "project";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL11_TEXT = "$JLabel11.text";
    private static final String BINDING_$JLABEL13_TEXT = "$JLabel13.text";
    private static final String BINDING_$JLABEL16_VISIBLE = "$JLabel16.visible";
    private static final String BINDING_$JLABEL17_VISIBLE = "$JLabel17.visible";
    private static final String BINDING_$JLABEL1_TEXT = "$JLabel1.text";
    private static final String BINDING_$JLABEL3_TEXT = "$JLabel3.text";
    private static final String BINDING_$JLABEL5_TEXT = "$JLabel5.text";
    private static final String BINDING_$JLABEL7_TEXT = "$JLabel7.text";
    private static final String BINDING_$JLABEL9_TEXT = "$JLabel9.text";
    private static final String BINDING_$JTEXT_AREA0_TEXT = "$JTextArea0.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWz08TQRQeKlAK+AsCgkAEwRg1bkFENCUKYgg2VQklSmiiTrsDDNnurjOzdLkY/wT/BL0bE6M3T8aDZw9ejP+CMR68Gt9st1tqp0t1e5jS+d775nvfzLzh1XfUxhka28GuqzHHFLRItPTC+vq9/A4piFuEFxi1hcVQ+dMSQ7Ec6tKDeS7QeC4j05N+enLRKtqWScx92akM6uRizyB8mxAh0EhtRoHzZDaAU67tsAprIErF+uLnj9hz/dnLGEKuDepGoJTRg7KqlbRmUIzqAvXASrs4aWBzC2Qwam6B3sNybtHAnN/FRfIEPUXxDGq3MQMygU43X7LH4eW7tkDxiTWcN8ikQNom0+gmI0XCtILFYXSoZjNL+q6tlL+zTrGI2d59Skq27ZG0A8U2NnWDMIHON0GxXA7el+4HwC7UpecJNiuJ+zLKmqcEGqgxl5fAKs3DZGQiSOiYSGdwnhhQZY+00fVDy7MyqKcudkr+PqHGLoVg0yHY5RBsJgS7EoLNhmBXQ7BrCixRqX0yDFQ5E4AqawJQ5U0AqszpmkivEVcsMIJh7/pq9q4C1GZ0T6SzBG4FhiMPKf01KQHSQEKDPVjBpuLseLMNiKobNlcPzoaBqi3r829IlhgwUstctODEh3mp2twen2WVcMcQdRQMDdVcJuiBWrUHVptUSw61MQem4fbl6tvmKkDlhjnwV8OUhB76u7/3y/tv75YqXfIkrN2nDN3X5KF7gX4bugyVSx8tt0hHUCN5B9upHEpwzx3vBRhWCMv6MIiD9Y7LdE2ma8uYbwNFW/zrh4/9jz8fQrEl1GlYWF/CMv42SohtBi5Yhu7aN+Y9Rd2lDhiPSW0Ctectpsv2d2ROxwKP5qmpwwm57oIJwwoTAiX5xKdfvdk38xUjWkDYYMPwqhltG6idmgY1ifdg+G+B8oHosjlxdKva81WvQIv87rX9BrvijWuqSlsF3Dk4SXPl1UexgNcp7wgCtcqkda8I+deGx9l/IKecfiiHB2qGweYZHqkZhiJrGIms4VRkDWORNYxH1nAmsoazkTWci6zhQmQNFyNrSEbWMBVZw3QT972D6FRU/p1qwDPTTN9gVolH4jjIj39gaKAh1UwdtGCZISrmm+CI71JOfUv/m0ZOvw5huNkUw9vIDGGG3orMsAwMfwB/i0YiEQ4AAA==";
    private static final Log log = LogFactory.getLog(fr.ifremer.coser.ui.project.ProjectSummaryView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected fr.ifremer.coser.ui.project.ProjectHandler handler;
    protected fr.ifremer.coser.bean.Project project;
    protected javax.swing.JLabel projectResultCount;
    protected javax.swing.JLabel projectSelectionCount;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ProjectSummaryView $Table0 = this;
    private jaxx.runtime.swing.Table $Table1;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JLabel $JLabel2;
    private javax.swing.JLabel $JLabel3;
    private javax.swing.JLabel $JLabel4;
    private javax.swing.JLabel $JLabel5;
    private javax.swing.JLabel $JLabel6;
    private javax.swing.JLabel $JLabel7;
    private javax.swing.JLabel $JLabel8;
    private javax.swing.JLabel $JLabel9;
    private javax.swing.JLabel $JLabel10;
    private javax.swing.JLabel $JLabel11;
    private javax.swing.JLabel $JLabel12;
    private javax.swing.JLabel $JLabel13;
    private javax.swing.JLabel $JLabel14;
    private javax.swing.JTextArea $JTextArea0;
    private javax.swing.JSeparator $JSeparator0;
    private javax.swing.JLabel $JLabel15;
    private javax.swing.JPanel $JPanel0;
    private javax.swing.JLabel $JLabel16;
    private javax.swing.JLabel $JLabel17;
    private javax.swing.JLabel $JLabel18;
    private javax.swing.JLabel $JLabel19;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ProjectSummaryView() {
        $initialize();
    }

    public ProjectSummaryView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public fr.ifremer.coser.ui.project.ProjectHandler getHandler() {
        return handler;
    }

    public fr.ifremer.coser.bean.Project getProject() {
        return project;
    }

    public javax.swing.JLabel getProjectResultCount() {
        return projectResultCount;
    }

    public javax.swing.JLabel getProjectSelectionCount() {
        return projectSelectionCount;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setHandler(fr.ifremer.coser.ui.project.ProjectHandler newValue) {
        fr.ifremer.coser.ui.project.ProjectHandler oldValue = this.handler;
        this.handler = newValue;
        firePropertyChange(PROPERTY_HANDLER, oldValue, newValue);
    }

    public void setProject(fr.ifremer.coser.bean.Project newValue) {
        fr.ifremer.coser.bean.Project oldValue = this.project;
        this.project = newValue;
        firePropertyChange(PROPERTY_PROJECT, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table get$Table1() {
        return $Table1;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected javax.swing.JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected javax.swing.JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected javax.swing.JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected javax.swing.JLabel get$JLabel6() {
        return $JLabel6;
    }

    protected javax.swing.JLabel get$JLabel7() {
        return $JLabel7;
    }

    protected javax.swing.JLabel get$JLabel8() {
        return $JLabel8;
    }

    protected javax.swing.JLabel get$JLabel9() {
        return $JLabel9;
    }

    protected javax.swing.JLabel get$JLabel10() {
        return $JLabel10;
    }

    protected javax.swing.JLabel get$JLabel11() {
        return $JLabel11;
    }

    protected javax.swing.JLabel get$JLabel12() {
        return $JLabel12;
    }

    protected javax.swing.JLabel get$JLabel13() {
        return $JLabel13;
    }

    protected javax.swing.JLabel get$JLabel14() {
        return $JLabel14;
    }

    protected javax.swing.JTextArea get$JTextArea0() {
        return $JTextArea0;
    }

    protected javax.swing.JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    protected javax.swing.JLabel get$JLabel15() {
        return $JLabel15;
    }

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JLabel get$JLabel16() {
        return $JLabel16;
    }

    protected javax.swing.JLabel get$JLabel17() {
        return $JLabel17;
    }

    protected javax.swing.JLabel get$JLabel18() {
        return $JLabel18;
    }

    protected javax.swing.JLabel get$JLabel19() {
        return $JLabel19;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createHandler() {
        $objectMap.put("handler", handler = null);
    }

    protected void createProject() {
        $objectMap.put("project", project = null);
    }

    protected void createProjectResultCount() {
        $objectMap.put("projectResultCount", projectResultCount = new javax.swing.JLabel());
        
        projectResultCount.setName("projectResultCount");
    }

    protected void createProjectSelectionCount() {
        $objectMap.put("projectSelectionCount", projectSelectionCount = new javax.swing.JLabel());
        
        projectSelectionCount.setName("projectSelectionCount");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $Table0
        add($Table1, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table1
        $Table1.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel1, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel3, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel4, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel5, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel6, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel7, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel8, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel9, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel10, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel11, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel12, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel13, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel14, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JTextArea0, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JSeparator0, new GridBagConstraints(0, 8, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel15, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JPanel0, new GridBagConstraints(1, 9, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel18, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(projectSelectionCount, new GridBagConstraints(1, 10, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel19, new GridBagConstraints(0, 11, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(projectResultCount, new GridBagConstraints(1, 11, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add($JLabel16);
        $JPanel0.add($JLabel17);
        
        // apply 10 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 3 property setters
        $Table1.setBorder(BorderFactory.createTitledBorder(_("coser.ui.project.summary.title")));
        $JLabel16.setIcon(jaxx.runtime.SwingUtil.createImageIcon("accept.png"));
        $JLabel17.setIcon(jaxx.runtime.SwingUtil.createImageIcon("cancel.png"));
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$Table0", this);
        createHandler();
        createProject();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new jaxx.runtime.swing.Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("coser.ui.project.summary.path"));
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new javax.swing.JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("coser.ui.project.projectcreation"));
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new javax.swing.JLabel());
        
        $JLabel3.setName("$JLabel3");
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new javax.swing.JLabel());
        
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(_("coser.ui.project.projectauthor"));
        // inline creation of $JLabel5
        $objectMap.put("$JLabel5", $JLabel5 = new javax.swing.JLabel());
        
        $JLabel5.setName("$JLabel5");
        // inline creation of $JLabel6
        $objectMap.put("$JLabel6", $JLabel6 = new javax.swing.JLabel());
        
        $JLabel6.setName("$JLabel6");
        $JLabel6.setText(_("coser.ui.project.summary.catchFileName"));
        // inline creation of $JLabel7
        $objectMap.put("$JLabel7", $JLabel7 = new javax.swing.JLabel());
        
        $JLabel7.setName("$JLabel7");
        // inline creation of $JLabel8
        $objectMap.put("$JLabel8", $JLabel8 = new javax.swing.JLabel());
        
        $JLabel8.setName("$JLabel8");
        $JLabel8.setText(_("coser.ui.project.summary.haulFileName"));
        // inline creation of $JLabel9
        $objectMap.put("$JLabel9", $JLabel9 = new javax.swing.JLabel());
        
        $JLabel9.setName("$JLabel9");
        // inline creation of $JLabel10
        $objectMap.put("$JLabel10", $JLabel10 = new javax.swing.JLabel());
        
        $JLabel10.setName("$JLabel10");
        $JLabel10.setText(_("coser.ui.project.summary.strataFileName"));
        // inline creation of $JLabel11
        $objectMap.put("$JLabel11", $JLabel11 = new javax.swing.JLabel());
        
        $JLabel11.setName("$JLabel11");
        // inline creation of $JLabel12
        $objectMap.put("$JLabel12", $JLabel12 = new javax.swing.JLabel());
        
        $JLabel12.setName("$JLabel12");
        $JLabel12.setText(_("coser.ui.project.summary.lengthFileName"));
        // inline creation of $JLabel13
        $objectMap.put("$JLabel13", $JLabel13 = new javax.swing.JLabel());
        
        $JLabel13.setName("$JLabel13");
        // inline creation of $JLabel14
        $objectMap.put("$JLabel14", $JLabel14 = new javax.swing.JLabel());
        
        $JLabel14.setName("$JLabel14");
        $JLabel14.setText(_("coser.ui.project.projectcomment"));
        // inline creation of $JTextArea0
        $objectMap.put("$JTextArea0", $JTextArea0 = new javax.swing.JTextArea());
        
        $JTextArea0.setName("$JTextArea0");
        $JTextArea0.setColumns(15);
        $JTextArea0.setLineWrap(true);
        $JTextArea0.setWrapStyleWord(true);
        $JTextArea0.setEditable(false);
        $JTextArea0.setRows(3);
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new javax.swing.JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        // inline creation of $JLabel15
        $objectMap.put("$JLabel15", $JLabel15 = new javax.swing.JLabel());
        
        $JLabel15.setName("$JLabel15");
        $JLabel15.setText(_("coser.ui.project.summary.validated"));
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        
        $JPanel0.setName("$JPanel0");
        // inline creation of $JLabel16
        $objectMap.put("$JLabel16", $JLabel16 = new javax.swing.JLabel());
        
        $JLabel16.setName("$JLabel16");
        // inline creation of $JLabel17
        $objectMap.put("$JLabel17", $JLabel17 = new javax.swing.JLabel());
        
        $JLabel17.setName("$JLabel17");
        // inline creation of $JLabel18
        $objectMap.put("$JLabel18", $JLabel18 = new javax.swing.JLabel());
        
        $JLabel18.setName("$JLabel18");
        $JLabel18.setText(_("coser.ui.project.summary.selectionCount"));
        createProjectSelectionCount();
        // inline creation of $JLabel19
        $objectMap.put("$JLabel19", $JLabel19 = new javax.swing.JLabel());
        
        $JLabel19.setName("$JLabel19");
        $JLabel19.setText(_("coser.ui.project.summary.resultCount"));
        createProjectResultCount();
        // inline creation of $Table0
        setName("$Table0");
        
        // registers 10 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 10 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL1_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("project", this);
                if (getProject() != null) {
                    getProject().addPropertyChangeListener("name", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getProject() != null) {
                    $JLabel1.setText(_(getContextValue(fr.ifremer.coser.CoserConfig.class).getProjectsDirectory().getAbsolutePath() + File.separator + getProject().getName()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("project", this);
                if (getProject() != null) {
                    getProject().removePropertyChangeListener("name", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL3_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("project", this);
                if (getProject() != null) {
                    getProject().addPropertyChangeListener("creationDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getProject() != null) {
                    $JLabel3.setText(_(java.text.DateFormat.getDateTimeInstance(java.text.DateFormat.LONG, java.text.DateFormat.SHORT, getContextValue(fr.ifremer.coser.CoserConfig.class).getLocale()).format(getProject().getCreationDate())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("project", this);
                if (getProject() != null) {
                    getProject().removePropertyChangeListener("creationDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL5_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("project", this);
                if (getProject() != null) {
                    getProject().addPropertyChangeListener("author", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getProject() != null) {
                    $JLabel5.setText(_(getProject().getAuthor()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("project", this);
                if (getProject() != null) {
                    getProject().removePropertyChangeListener("author", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL7_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("project", this);
                if (getProject() != null) {
                    getProject().addPropertyChangeListener("catchFileName", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getProject() != null) {
                    $JLabel7.setText(_(getProject().getCatchFileName()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("project", this);
                if (getProject() != null) {
                    getProject().removePropertyChangeListener("catchFileName", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL9_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("project", this);
                if (getProject() != null) {
                    getProject().addPropertyChangeListener("haulFileName", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getProject() != null) {
                    $JLabel9.setText(_(getProject().getHaulFileName()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("project", this);
                if (getProject() != null) {
                    getProject().removePropertyChangeListener("haulFileName", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL11_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("project", this);
                if (getProject() != null) {
                    getProject().addPropertyChangeListener("strataFileName", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getProject() != null) {
                    $JLabel11.setText(_(getProject().getStrataFileName()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("project", this);
                if (getProject() != null) {
                    getProject().removePropertyChangeListener("strataFileName", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL13_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("project", this);
                if (getProject() != null) {
                    getProject().addPropertyChangeListener("lengthFileName", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getProject() != null) {
                    $JLabel13.setText(_(getProject().getLengthFileName()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("project", this);
                if (getProject() != null) {
                    getProject().removePropertyChangeListener("lengthFileName", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JTEXT_AREA0_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("project", this);
                if (getProject() != null) {
                    getProject().addPropertyChangeListener("comment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getProject() != null) {
                    jaxx.runtime.SwingUtil.setText($JTextArea0, getProject().getComment());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("project", this);
                if (getProject() != null) {
                    getProject().removePropertyChangeListener("comment", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL16_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("project", this);
                if (getProject() != null) {
                    getProject().addPropertyChangeListener("control", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getProject() != null && getProject().getControl() != null) {
                    $JLabel16.setVisible(getProject().getControl().isValidated());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("project", this);
                if (getProject() != null) {
                    getProject().removePropertyChangeListener("control", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL17_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("project", this);
                if (getProject() != null) {
                    getProject().addPropertyChangeListener("control", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getProject() != null && getProject().getControl() != null) {
                    $JLabel17.setVisible(!getProject().getControl().isValidated());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("project", this);
                if (getProject() != null) {
                    getProject().removePropertyChangeListener("control", this);
                }
            }
        });
    }

}