/*
 * #%L
 * Coselmar :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Ifremer, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
var coselmarControllers = angular.module('coselmarControllers', ['ui.bootstrap', 'ui.select', 'ui.bootstrap.tooltip']);

// Controller when the main page/view loads
coselmarControllers.controller("HomeCtrl", ['$scope', '$http', '$location', 'userService', 'jwtHelper',
 								function ($scope, $http, $location, userService, jwtHelper) {

	var jwtToken = localStorage.getItem('coselmar-jwt');
	if (jwtToken && !jwtHelper.isTokenExpired(jwtToken)) {
		$scope.currentUser = jwtHelper.decodeToken(jwtToken);
	}

	//Just get the version from a file
	$http.get('version.txt', {'transformResponse':angular.identity}).success(function (data) {
    	$scope.version = data;
  	});

	$scope.login = function(mail, password) {
		userService.login(mail, password, function(successResult) {
			// Store JsonWebToken to keep authentication
			localStorage.setItem('coselmar-jwt', successResult.jwt);
			$scope.currentUser = jwtHelper.decodeToken(successResult.jwt);

			// Manage login messages
			$scope.loginMessage.fail = false;

			// Redirect on '/'
			$location.path('/');

		}, function(errorResult) {
			// Error message for login
			$scope.loginMessage.fail = true;
		})
	}

	$scope.logout = function() {
		delete $scope.currentUser;
		localStorage.removeItem('coselmar-jwt');
		$location.path('/');
	}

}]);

// Controller for All Documents View
coselmarControllers.controller("DocumentsCtrl", ['$scope', '$route', '$routeParams', '$location', 'documentService', function($scope, $route, $routeParams, $location, documentService){

	//manage keywords if given
	$scope.searchKeywords = [];
	var keywords = $routeParams.keywords;
	if (Array.isArray(keywords)) {
		$scope.searchKeywords = keywords;
	} else if (keywords) {
		$scope.searchKeywords.push(keywords);
	}

	documentService.getDocuments($scope);

	$scope.deleteDocument = function(documentId){

		// Call service to create a new document
		documentService.deleteDocument(documentId, $scope, function() {
			// Go back to documents list
			$route.reload();
		});
	};

	$scope.searchDocuments = function(){
//		$route.current.params.keywords = $scope.searchKeywords;
//		$route.reload();
		$location.search('keywords', $scope.searchKeywords);
	}
}]);


// Controller for new document View
coselmarControllers.controller("NewDocumentCtrl", ['$scope', '$location', 'documentService', function($scope, $location, documentService){

	$scope.document = {'privacy': 'PUBLIC'};
	$scope.upload = {};

	$scope.createNewDocument = function(isValidForm){

        if (angular.isDate($scope.question.publicationDate)) {
            $scope.document.publicationDate = $scope.document.publicationDate.getTime();
        }

		// Call service to create a new document
		if (isValidForm) {
			documentService.createDocument(
			$scope.document, $scope.upload.file, function() {
					$location.path("/documents");

				},function(error) {
					//TODO ymartel 20141118 : deal with error.status or statusText
					console.log("error occurs");
					console.log(error.s);
			});
		}

	};
}]);

// Controller for single document View
coselmarControllers.controller("DocumentViewCtrl",
 	['$scope', '$route', '$location', 'documentService', '$routeParams', 'coselmar-config',
 	 function($scope, $route, $location, documentService, $routeParams, coselmarConfig) {

	$scope.container = {baseUrl : coselmarConfig.BASE_URL};

	documentService.getDocument($routeParams.documentId, $scope);

	$scope.deleteDocument = function(documentId){

		// Call service to create a new document
		documentService.deleteDocument(documentId, $scope, function() {
				// Go back to documents list
				$location.path("/documents");
			});

	};
} ]);

// Controller for document file download
coselmarControllers.controller("DocumentFileDlCtrl", [ '$scope','documentService', '$routeParams', function($scope, documentService, $routeParams) {
	documentService.getDocumentFile($routeParams.documentId, $scope);
} ]);

coselmarControllers.directive('ngFileModel', ['$parse', function ($parse) {
    return {
        restrict: 'A',
        link: function(scope, element, attrs) {
            var model = $parse(attrs.ngFileModel);
            var modelSetter = model.assign;

            element.bind('change', function(){
                scope.$apply(function(){
                    modelSetter(scope, element[0].files[0]);
                });
            });
        }
    };
}]);


/////////////////////////////////////////////////
//////////////  Users Part  /////////////////////
/////////////////////////////////////////////////

// Controller for All User View
coselmarControllers.controller("UsersCtrl", ['$scope', '$route', '$routeParams', '$location', 'userService', function($scope, $route, $routeParams, $location, userService){

	//manage keywords if given
	$scope.search = { searchKeyword : '', onlyActive : false };
	var keywords = $routeParams.keywords;
	if (Array.isArray(keywords)) {
		$scope.search.searchKeyword = keywords[0];
	} else if (keywords) {
		$scope.search.searchKeyword = keywords;
	}
	var onlyActive = $routeParams.onlyActive;
	if (onlyActive) {
		$scope.search.onlyActive = onlyActive;
	}

	userService.getUsers($scope);

	$scope.deleteUser = function(userId){

		userService.deleteUser(userId, $scope, function() {
			// Go back to documents list
			$route.reload();
		});
	};

	$scope.searchUsers = function(){
		$location.search('keywords', $scope.search.searchKeyword);
		$location.search('onlyActive', $scope.search.onlyActive);
	}
}]);


// Controller for new user View
coselmarControllers.controller("NewUserCtrl", ['$scope', '$route', '$location', 'userService', function($scope, $route, $location, userService){

	$scope.user = {'role' : 'expert'};

	$scope.saveUser = function(isValidForm){

		// Call service to create a new user
		if(isValidForm) {
			userService.saveUser($scope.user, function() {
				$location.path("/users");
			},function(error) {
				//TODO ymartel 20141118 : deal with error.status or statusText
				console.log("error occurs");
				console.log(error.s);
			});
		}

	};
}]);

// Controller for single document View
coselmarControllers.controller("UserViewCtrl",
 	['$scope', '$route', '$location', 'userService', '$routeParams', function($scope, $route, $location, userService, $routeParams) {

	$scope.editMode = $routeParams.edit;
	if ($scope.editMode) {
		$scope.editPassword = true;
	}

	userService.getUser($routeParams.userId, $scope);

	$scope.deleteUser = function(userId){

		documentService.deleteUser(documentId, $scope, function() {
			// Go back to users list
			$location.path("/users");
		});

	};

	$scope.modifyUser = function(){
		$location.search("edit");
	};

	$scope.saveUser = function(isValidForm){

		// Call service to create a new user
		if(isValidForm) {
			userService.saveUser($scope.user,
				function() {
					// On success, reload the view page
					$location.search("");

				},function(error) {
					//TODO ymartel 20141118 : deal with error.status or statusText
					console.log("error occurs");
					console.log(error.s);
			});
		}
	};

} ]);


/////////////////////////////////////////////////
////////////  Questions Part  ///////////////////
/////////////////////////////////////////////////

// Controller for All Question View
coselmarControllers.controller("QuestionsCtrl", ['$scope', '$route', '$routeParams', '$location', 'questionsService',
 					function($scope, $route, $routeParams, $location, questionsService){

	questionsService.getQuestions(function(questions) {
		// success : just get the questions
		$scope.questions = questions;

	}, function(error) {
		// Fail function : TODO
		console.log(error);
	});


	$scope.deleteQuestion = function(questionId) {

		questionsService.deleteQuestion(questionId, function(questions) {
			// success : just get the questions
			$route.reload();

		}, function(error) {
			// Fail function : TODO
			console.log(error);
		});
	};

	$scope.getUserNames = function(users) {

		var names = "";
		for(var i=0; i < users.length; i++) {
			names += users[i].firstName + " " + users[i].name + "<br />";
		}

		return names;
	};

	$scope.getDocumentTitles = function(documents) {

		var titles = "";
		for(var i=0; i < documents.length; i++) {
			titles += documents[i].name;
			titles += "<br />";
		}

		return titles;
	};

}]);

// Controller for All User View
coselmarControllers.controller("QuestionCtrl", ['$scope', '$route', '$routeParams', '$location', '$modal', 'questionsService',
 					function($scope, $route, $routeParams, $location, $modal, questionsService){

	$scope.editSession = $routeParams.edit ? $routeParams.edit : false;
	$scope.isCurrentParticipant = false;

	$scope.question = {'privacy' : 'PUBLIC',
						'themes' : [], 'participants' : [], 'externalExperts' : [],
						'clients' : [], 'relatedDocuments': [], 'newRelatedDocuments' : [] };

	//to enter in edit mode from view
	$scope.edit = function() {
		$location.search("edit");
	}

	// Participants, clients and supervisors management for ui-select
	$scope.participantsIndex = {};
	$scope.clientsIndex = {};
	$scope.supervisorsIndex = {};

	$scope.users = { 'participants' : [], 'clients': [], 'supervisors' : []};

	$scope.refreshExperts = function(searchKeyword) {
		var searchKeywords = [];
		if (searchKeyword && searchKeyword.length > 0) {
			searchKeywords.push(searchKeyword);
		}

		questionsService.findUsers({'role': 'EXPERT', 'active': true, 'fullTextSearch' : searchKeywords}, function(users) {
			$scope.users.participants = users;
			$scope.participantsIndex = {};
			angular.forEach($scope.users.participants, function(participant) {
				$scope.participantsIndex[participant.id] = participant;
			});
			bindUsers($scope.question.participants, $scope.participantsIndex);
		});
	}

	$scope.refreshClients = function(searchKeyword) {
		var searchKeywords = [];
		if (searchKeyword && searchKeyword.length > 0) {
			searchKeywords.push(searchKeyword);
		}

		questionsService.findUsers({'role': 'CLIENT', 'active': 'true', 'fullTextSearch' : searchKeywords}, function(users) {
			$scope.users.clients = users;
			$scope.clientsIndex = {};
			angular.forEach($scope.users.clients, function(client) {
				$scope.clientsIndex[client.id] = client;
			});
			bindUsers($scope.question.clients, $scope.clientsIndex);
		});
	}

	$scope.refreshSupervisors = function(searchKeyword) {
		var searchKeywords = [];
		if (searchKeyword && searchKeyword.length > 0) {
			searchKeywords.push(searchKeyword);
		}

		questionsService.findUsers({'role': 'SUPERVISOR', 'active': 'true', 'fullTextSearch' : searchKeywords}, function(users) {
			$scope.users.supervisors = users;
			$scope.supervisorsIndex = {};
			angular.forEach($scope.users.supervisors, function(supervisor) {
				$scope.supervisorsIndex[supervisor.id] = supervisor;
			});
			bindUsers($scope.question.supervisors, $scope.supervisorsIndex);
		});
	}

	// call refresh for init
	$scope.refreshExperts("");
	$scope.refreshClients("");
	$scope.refreshSupervisors("");

	// function to be sure to have same user objects in list
	var bindUsers = function(toDeal, index) {
		if (toDeal) {
			for(var i = 0; i < toDeal.length; i++) {
				var user = toDeal[i];
				if (index[user.id]) {
					toDeal[i] = index[user.id];
				}
			}
		}

	};

	if ($routeParams.questionId) {
		questionsService.getQuestion($routeParams.questionId,
			function(question) {
			// success : just get the questions
			$scope.question = question;

			// update scope about current user : if he is participant, more option enable in ui
			if ($scope.question.participants) {
				for (var i = 0; i < $scope.question.participants.length; i++) {
					if ($scope.question.participants[i].id == $scope.currentUser.userId) {
						$scope.isCurrentParticipant = true;
						// Should be able to put new documents in question
						$scope.question.newRelatedDocuments = [];
						break;
					}
				}
			}

			if(!question.relatedDocuments) {
				$scope.question.relatedDocuments = [];
			}

			if (question.participants) {
				$scope.users.participants = question.participants;
				bindUsers($scope.question.participants, $scope.participantsIndex);
			}
			if (question.clients) {
				$scope.users.clients = question.clients;
				bindUsers($scope.question.clients, $scope.clientsIndex);
			}
			if (question.supervisors) {
				$scope.users.supervisors = question.supervisors;
				bindUsers($scope.question.supervisors, $scope.supervisorsIndex);
			}

		}, function(error) {
			// Fail function : TODO
			console.log("error during request");
			console.log(error);
		});
	};

	//Deletion
	$scope.deleteQuestion = function(){
		questionsService.deleteQuestion($routeParams.questionId, function() {
			// success : goto questions list
			$location('#/questions');

		}, function(error) {
			// Fail function : TODO
			console.log(error);
		});
	};

	$scope.saveQuestion = function(){
        if (angular.isDate($scope.question.deadline)) {
            $scope.question.deadline = $scope.question.deadline.getTime();
        }

		// Call service to create a new user
		questionsService.saveQuestion($scope.question, function() {
			$location.search("");
		},function(error) {
			//TODO ymartel 20141118 : deal with error.status or statusText
			console.log("error occurs");
			console.log(error.s);
		});
	};

	$scope.saveQuestion = function(isValidForm){

        if (angular.isDate($scope.question.deadline)) {
            $scope.question.deadline = $scope.question.deadline.getTime();
        }

		// Call service to create a new user
		if(isValidForm) {
			questionsService.saveQuestion($scope.question, function() {
				if ($routeParams.questionId) {
					$location.search("");
				} else {
					$location.path("/questions");
				}
			},function(error) {
				//TODO ymartel 20141118 : deal with error.status or statusText
				console.log("error occurs");
				console.log(error.s);
			});
		}
	}

	$scope.closeQuestion = function(){
		$scope.question.status = "CLOSED";
		questionsService.saveQuestion($scope.question, function() {
			$route.reload();
		},function(error) {
			//TODO ymartel 20141118 : deal with error.status or statusText
			console.log("error occurs");
			console.log(error.s);
		});
	};

	$scope.openCloseQuestionSession = function(){
		if (!$scope.question.closingDocuments) {
			$scope.question.closingDocuments = [];
		}

		$scope.closeSession = true;
	};

	$scope.reopenQuestion = function(){
		$scope.question.status = "IN_PROGRESS";
		questionsService.saveQuestion($scope.question, function() {
			$route.reload();
		},function(error) {
			//TODO ymartel 20141118 : deal with error.status or statusText
			console.log("error occurs");
			console.log(error.s);
		});
	};

	$scope.adjournQuestion = function(){
		$scope.question.status = "ADJOURNED";
		questionsService.saveQuestion($scope.question, function() {
			$route.reload();
		},function(error) {
			//TODO ymartel 20141118 : deal with error.status or statusText
			console.log("error occurs");
			console.log(error.s);
		});
	};

	// New documents added
	$scope.validateNewDocuments = function(){

		if ($scope.question.newRelatedDocuments
		 	&& $scope.question.newRelatedDocuments.length > 0) {

			questionsService.addNewDocuments($routeParams.questionId, $scope.question.newRelatedDocuments, function() {
				$route.reload();

			}, function(error) {
				// Fail function : TODO
				console.log(error);
			});
		}
	};

	$scope.addTheme = function(theme) {
		if (theme && $scope.question.themes.indexOf(theme) == -1) {
			$scope.question.themes.push(theme);
		}
	}

	$scope.removeTheme = function(theme) {
		var position = $scope.question.themes.indexOf(theme);
		if (theme && position != -1) {
			$scope.question.themes.splice(position, 1);
		}
	}

	// Modals part for documents
	$scope.modalSearchDocuments = function (documentList) {

		var modalInstance = $modal.open({
			templateUrl: 'views/documents/modalDocumentSearch.html',
			controller: 'ModalSearchDocumentsCtrl',
			size: 'lg'
		});

		modalInstance.result.then(function (selectedDocument) {
			var already = false;
			for (var i = 0; i < documentList.length; i++) {
				if (documentList[i].id == selectedDocument.id) {
					already = true;
				}
			}
			if (!already) {
				documentList.push(selectedDocument);
			}
		});
	};

	$scope.modalCreateDocument = function (documentList) {

		var modalInstance = $modal.open({
			templateUrl: 'views/documents/modalDocumentEdit.html',
			controller: 'ModalCreateDocumentsCtrl',
			size: 'lg'
		});

		modalInstance.result.then(function (selectedDocument) {
			var already = false;
			for (var i = 0; i < documentList.length; i++) {
				if (documentList[i].id == selectedDocument.id) {
					already = true
				}
			}
			if (!already) {
				documentList.push(selectedDocument);
			}
		});
	};

	$scope.removeDocument = function(document, documentList) {
		var position = documentList.indexOf(document);
		if (document && position != -1) {
			documentList.splice(position, 1);
		}
	}


}]);

coselmarControllers.controller('ModalSearchDocumentsCtrl', function ($scope, $modalInstance, documentService) {

	$scope.searchKeywords = [];

	documentService.getDocuments($scope);

	$scope.searchDocuments = function(searchKeywords) {
		$scope.searchKeywords = searchKeywords;
		documentService.getDocuments($scope);

	}

	$scope.select = function (document) {
		$modalInstance.close(document);
	};

	$scope.cancel = function () {
		$modalInstance.dismiss('cancel');
	};

});

coselmarControllers.controller('ModalCreateDocumentsCtrl', function ($scope, $modalInstance, documentService) {

	$scope.document = {'privacy': 'PUBLIC'};
	$scope.upload = {};

	$scope.existingKeywords = [];

	$scope.create = function (isValidForm) {

        if (angular.isDate($scope.document.publicationDate)) {
            $scope.document.publicationDate = $scope.document.publicationDate.getTime();
        }

		if (isValidForm) {
			if ($scope.upload.file) {
				$scope.document.withFile = true;
			}
			documentService.createDocument(
			$scope.document, $scope.upload.file, function(document) {
					$modalInstance.close(document);

				},function(error) {
					//TODO ymartel 20141118 : deal with error.status or statusText
					console.log("error occurs");
					console.log(error.s);
			});
		}
	};

	$scope.cancel = function () {
		$modalInstance.dismiss('cancel');
	};

});


/////////////////////////////////////////////////
///////////  Referential Part  //////////////////
/////////////////////////////////////////////////

// Controller for Referential Page
coselmarControllers.controller("ReferentialCtrl", ['$scope', '$routeParams', '$location',
 					function($scope, $routeParams, $location){

	//manage keywords if given
	$scope.search = { keywords : [], results : [], onDocuments: false, onQuestions: false };

	var keywords = $routeParams.keywords;
	if (Array.isArray(keywords)) {
		$scope.search.keywords = keywords;
	} else if (keywords) {
		$scope.search.keywords.push(keywords);
	}

	var onQuestions = $routeParams.onQuestions;
	if (onQuestions) {
		console.log(onQuestions);
		$scope.search.onQuestions = onQuestions;
	}

	var onDocuments = $routeParams.onDocuments;
	if (onDocuments) {
		$scope.search.onDocuments = onDocuments;
	}

	var remoteSearchInReferential = function() {
		console.log("TODO : call server");
//		referentialService.find($scope.search, function(results) {
//
//			$scope.search.results = results
//
//			}, function(error) {
//				//TODO ymartel 20141211 : deal with error.status or statusText
//				console.log("error occurs");
//				console.log(error.s);
//			}
//		);
	};

	remoteSearchInReferential();

	$scope.searchInReferential = function(){

		if ($scope.search.keywords) {
			$location.search('keywords', $scope.search.keywords);
		} else {
			$location.search('keywords', null);
		}

		if ($scope.search.onDocuments) {
			$location.search('onDocuments', $scope.search.onDocuments);
		} else {
			$location.search('onDocuments', null);
		}

		if ($scope.search.onQuestions) {
			$location.search('onQuestions', $scope.search.onQuestions);
		} else {
			$location.search('onQuestions', null);
		}
	};

}]);


/**
 * AngularJS default filter with the following expression:
 * "person in people | filter: {name: $select.search, age: $select.search}"
 * performs a AND between 'name: $select.search' and 'age: $select.search'.
 * We want to perform a OR.
 *
 * Extract from angular-ui-select demo :
 * https://github.com/angular-ui/ui-select/blob/master/examples/demo.js
 */
coselmarControllers.filter('propsFilter', function() {
  return function(items, props) {
    var out = [];

    if (angular.isArray(items)) {
      items.forEach(function(item) {
        var itemMatches = false;

        var keys = Object.keys(props);
        for (var i = 0; i < keys.length; i++) {
          var prop = keys[i];
          var text = props[prop].toLowerCase();
          if (item[prop] && item[prop].toString().toLowerCase().indexOf(text) !== -1) {
            itemMatches = true;
            break;
          }
        }

        if (itemMatches) {
          out.push(item);
        }
      });
    } else {
      // Let the output be the input untouched
      out = items;
    }

    return out;
  };
});
