/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.entities;

import com.herbocailleau.sgq.business.model.ProductSearchModel;
import com.herbocailleau.sgq.entities.AnalyzeType;
import com.herbocailleau.sgq.entities.Batch;
import com.herbocailleau.sgq.entities.BatchDAOImpl;
import com.herbocailleau.sgq.entities.Product;
import com.herbocailleau.sgq.entities.ProductDAOAbstract;
import com.herbocailleau.sgq.entities.ProductPlace;
import com.herbocailleau.sgq.entities.ProductStatus;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.topia.TopiaException;

public class ProductDAOImpl<E extends Product>
extends ProductDAOAbstract<E> {
    public List<String> findDistinctCategories() throws TopiaException {
        String query = "select distinct category from " + Product.class.getName() + " order by " + "category";
        List result = this.context.findAll(query, new Object[0]);
        return result;
    }

    public List<Product> findAllModel(ProductSearchModel search) throws TopiaException {
        return this.findAllModel(search, 0, -1);
    }

    public List<Product> findAllModel(ProductSearchModel search, int offset, int limit) throws TopiaException {
        String queryPrefix = "select P";
        String querySuffix = " order by P.code ASC";
        List results = (List)this.performQueryWithFilter(search, queryPrefix, querySuffix, offset, limit);
        return results;
    }

    public long findAllCount(ProductSearchModel search) throws TopiaException {
        String queryPrefix = "select count(P)";
        Number result = (Number)this.performQueryWithFilter(search, queryPrefix, "", -1, -1);
        return result.longValue();
    }

    protected Object performQueryWithFilter(ProductSearchModel search, String queryPrefix, String querySuffix, int offset, int limit) throws TopiaException {
        int index;
        String query = queryPrefix;
        query = query + " from " + Product.class.getName() + " P";
        query = query + " where 1=1";
        ArrayList<Object> params = new ArrayList<Object>();
        if (StringUtils.isNotBlank((CharSequence)search.getName())) {
            query = query + " and " + BatchDAOImpl.getFieldLikeInsensitive("P.name", ":name");
            params.add("name");
            params.add("%" + StringUtils.stripAccents((String)search.getName()) + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)search.getCode())) {
            query = query + " and " + BatchDAOImpl.getFieldLikeInsensitive("P.code", ":code");
            params.add("code");
            params.add("%" + StringUtils.stripAccents((String)search.getCode()) + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)search.getCategory())) {
            query = query + " and " + BatchDAOImpl.getFieldLikeInsensitive("P.category", ":category");
            params.add("category");
            params.add("%" + StringUtils.stripAccents((String)search.getCategory()) + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)search.getLatinName())) {
            query = query + " and " + BatchDAOImpl.getFieldLikeInsensitive("P.latinName", ":latinName");
            params.add("latinName");
            params.add("%" + StringUtils.stripAccents((String)search.getLatinName()) + "%");
        }
        if (CollectionUtils.isNotEmpty(search.getProductStatus())) {
            index = 0;
            query = query + " and (1=1";
            for (ProductStatus status : search.getProductStatus()) {
                if (status == null) {
                    query = query + " AND P.productStatus IS EMPTY";
                    continue;
                }
                query = query + " AND :status" + index + " member of P.productStatus";
                params.add("status" + index);
                params.add(status);
                ++index;
            }
            query = query + ")";
        }
        if (CollectionUtils.isNotEmpty(search.getAnalyzeTypes())) {
            index = 0;
            query = query + " and (";
            Iterator<AnalyzeType> itAnalyzeType = search.getAnalyzeTypes().iterator();
            while (itAnalyzeType.hasNext()) {
                AnalyzeType analyzeType = itAnalyzeType.next();
                if (analyzeType == null) {
                    query = query + " P.analyzeType IS EMPTY";
                } else {
                    query = query + " :analyzeType" + index + " member of P." + "analyzeType";
                    params.add("analyzeType" + index);
                    params.add(analyzeType);
                    ++index;
                }
                if (!itAnalyzeType.hasNext()) continue;
                query = query + (search.isAnalyzeTypeOrOperator() ? " OR" : " AND");
            }
            query = query + ")";
        }
        if (!search.isArchived()) {
            query = query + " AND archived = false";
        }
        query = query + querySuffix;
        Object result = null;
        result = offset == -1 ? this.context.findUnique(query, params.toArray()) : (limit == -1 ? this.context.findAll(query, params.toArray()) : this.context.find(query, offset, offset + limit - 1, params.toArray()));
        return result;
    }

    public boolean isUsedByAnyBatch(Product product) throws TopiaException {
        String query = "select count(*) FROM " + ProductPlace.class.getName() + " where " + "product" + " = :product";
        Number result = (Number)this.context.findUnique(query, new Object[]{"product", product});
        if (result.longValue() == 0L) {
            query = "select count(*) FROM " + Batch.class.getName() + " where " + "product" + " = :product";
            result = (Number)this.context.findUnique(query, new Object[]{"product", product});
        }
        return result.longValue() > 0L;
    }

    public boolean isUsedByNonExpiredBatch(Product product) throws TopiaException {
        String query = "select count(*) FROM " + Batch.class.getName() + " where " + "product" + " = :product" + " AND " + "expiredDate" + " = null";
        Number result = (Number)this.context.findUnique(query, new Object[]{"product", product});
        return result.longValue() > 0L;
    }
}

