/*
 * #%L
 * SGQ :: Business
 * $Id: MigrationV0V11.java 452 2014-04-14 12:01:48Z echatellier $
 * $HeadURL: https://svn.codelutin.com/sgq-ch/tags/sgq-ch-1.1.6/sgq-business/src/main/java/com/herbocailleau/sgq/business/migration/MigrationV0V11.java $
 * %%
 * Copyright (C) 2012, 2013 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.business.migration;

import java.util.List;

import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.migration.TopiaMigrationCallbackByClass;
import org.nuiton.topia.migration.TopiaMigrationCallbackByClass.MigrationCallBackForVersion;
import org.nuiton.util.Version;

/**
 * Migration between version 0 and 1.1.
 * 
 * @author Eric Chatellier
 */
public class MigrationV0V11 extends MigrationCallBackForVersion {

    /**
     * Constructor.
     * 
     * @param version version
     * @param callBack callback
     */
    public MigrationV0V11(Version version, TopiaMigrationCallbackByClass callBack) {
        super(version, callBack);
    }

    /*
     * @see org.nuiton.topia.migration.TopiaMigrationCallbackByClass.MigrationCallBackForVersion#prepareMigrationScript(org.nuiton.topia.framework.TopiaContextImplementor, java.util.List, boolean, boolean)
     */
    @Override
    protected void prepareMigrationScript(TopiaContextImplementor tx,
            List<String> queries, boolean showSql, boolean showProgression)
            throws TopiaException {
        // ajout du lien *-* Presentation > Place
        queries.add("create table inventoryplaces_presentation (presentation varchar(255) not null, inventoryPlaces varchar(255) not null);");
        queries.add("alter table inventoryplaces_presentation add constraint FK4C14D51F828EC5 foreign key (presentation) references presentation");
        queries.add("alter table inventoryplaces_presentation add constraint FK4C14D512A96123E foreign key (inventoryPlaces) references place");

        // contrainte d'unicite presentation code / lot
        queries.add("alter table presentation add constraint presentation_batch_presentationCode_key unique (batch, presentationCode)");
        
        // perfs (inventaire)
        queries.add("CREATE INDEX expedition_destination_idx ON expedition (destination);");
        queries.add("CREATE INDEX expedition_presentation_idx ON expedition (presentation);");
        queries.add("CREATE INDEX production_destination_idx ON expedition (destination);"); // FIXME a corriger production
        queries.add("CREATE INDEX production_presentation_idx ON expedition (presentation);"); // FIXME a corriger production
        
        // perfs (index)
        queries.add("CREATE INDEX presentation_batch_idx ON presentation (batch);");
        queries.add("CREATE INDEX expedition_correction_idx ON expedition (correction);");
        queries.add("CREATE INDEX production_correction_idx ON expedition (correction);"); // FIXME a corriger production

        // suppression des quotes françaises
        queries.add("UPDATE product SET name = replace(name, '’', '''') where name IS NOT null;");
    }
}
