package com.herbocailleau.sgq.entities;

/*
 * #%L
 * SGQ :: Business
 * $Id: AnalyzeTypeDAOImpl.java 347 2013-04-30 10:02:16Z echatellier $
 * $HeadURL: https://svn.codelutin.com/sgq-ch/tags/sgq-ch-1.1.5/sgq-business/src/main/java/com/herbocailleau/sgq/entities/AnalyzeTypeDAOImpl.java $
 * %%
 * Copyright (C) 2013 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.nuiton.topia.TopiaException;

public class AnalyzeTypeDAOImpl<E extends AnalyzeType> extends AnalyzeTypeDAOAbstract<E> {
    
    /**
     * Retourne les categories ordonnés par nom with entity count that use each category.
     * 
     * @return status and count
     * @throws TopiaException 
     */
    public Map<E, Long> findAllWithUsageCount() throws TopiaException {
        String query = "SELECT T, " +
                " (select count(*) from " + BatchAnalyze.class.getName() + " B" +
                "  where T = B." + BatchAnalyze.PROPERTY_ANALYZE_TYPE + ") + " +
                " (select count(*) from " + Product.class.getName() + " P" +
                "  where T in elements (P." + Product.PROPERTY_ANALYZE_TYPE + "))" +
                " from " + AnalyzeType.class.getName() + " T" +
                " order by T.analyzeCategory." + AnalyzeCategory.PROPERTY_NAME + ", " + AnalyzeType.PROPERTY_NAME;

        List<Object[]> results = (List<Object[]>)context.findAll(query);
        Map<E, Long> categories = new LinkedHashMap<E, Long>();
        for (Object[] result : results) {
            categories.put((E)result[0], ((Number)result[1]).longValue());
        }

        return categories;
    }

} //AnalyzeTypeDAOImpl<E extends AnalyzeType>
