/*
 * #%L
 * SGQ :: Business
 * $Id: ImportLog.java 113 2012-10-02 14:38:07Z echatellier $
 * $HeadURL: https://svn.codelutin.com/sgq-ch/tags/sgq-ch-1.1.5/sgq-business/src/main/java/com/herbocailleau/sgq/business/model/ImportLog.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.business.model;

/**
 * Objet contenant toutes les informations de succès ou d'échec d'import
 * d'une ligne d'un fichier d'import.
 * 
 * @author echatellier
 */
public class ImportLog<E> {

    protected boolean error;

    protected long line = -1;

    protected String code;

    protected String message;
    
    protected E bean;

    public ImportLog() {
        this(false);
    }

    public ImportLog(boolean error) {
        this.error = error;
    }

    public boolean isError() {
        return error;
    }

    public void setError(boolean error) {
        this.error = error;
    }

    public long getLine() {
        return line;
    }

    public void setLine(long line) {
        this.line = line;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public E getBean() {
        return bean;
    }

    public void setBean(E bean) {
        this.bean = bean;
    }
}
