/*
 * #%L
 * SGQ :: Business
 * $Id: AnalyzeModel.java 145 2012-10-09 12:44:07Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-1.1.4/sgq-business/src/main/java/com/herbocailleau/sgq/business/model/AnalyzeModel.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.business.model;

import java.util.Date;

import com.herbocailleau.sgq.entities.BatchAnalyze;

/**
 * Model pour les analyses comportant des informations calculées n'étant
 * pas stockées dans le modèle de données.
 * 
 * @author echatellier
 */
public class AnalyzeModel {

    protected BatchAnalyze analyze;

    /**
     * Date limite d'envoi théorique calculée à partir de la durée d'analyse
     * par rapport à la date du jour.
     */
    protected Date computedSendLimitDate;

    /**
     * Date de reception théorique calculée suivant la durée d'analyse.
     * A ne pas confondre avec {@link Analyze#getReceiptLimitDate()} qui est
     * fixé par l'utilisateur.
     */
    protected Date computedReceiptLimitDate;

    public AnalyzeModel(BatchAnalyze analyze) {
        this.analyze = analyze;
    }

    public BatchAnalyze getAnalyze() {
        return analyze;
    }

    public void setAnalyze(BatchAnalyze analyze) {
        this.analyze = analyze;
    }

    public Date getComputedSendLimitDate() {
        return computedSendLimitDate;
    }

    public void setComputedSendLimitDate(Date computedSendLimitDate) {
        this.computedSendLimitDate = computedSendLimitDate;
    }

    public Date getComputedReceiptLimitDate() {
        return computedReceiptLimitDate;
    }

    public void setComputedReceiptLimitDate(Date computedReceiptLimitDate) {
        this.computedReceiptLimitDate = computedReceiptLimitDate;
    }
}
