/*
 * #%L
 * SGQ :: Business
 * $Id: InventoryExportModel.java 381 2013-05-31 14:45:54Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-1.1.1/sgq-business/src/main/java/com/herbocailleau/sgq/business/services/csv/InventoryExportModel.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.business.services.csv;

import java.util.Date;

import org.nuiton.util.csv.ExportModel;
import org.nuiton.util.csv.ExportableColumn;
import org.nuiton.util.csv.ModelBuilder;
import org.nuiton.util.csv.ValueFormatter;

import com.herbocailleau.sgq.business.SgqUtils;
import com.herbocailleau.sgq.entities.Batch;
import com.herbocailleau.sgq.entities.Place;
import com.herbocailleau.sgq.entities.PresentationCode;
import com.herbocailleau.sgq.entities.Product;
import com.herbocailleau.sgq.entities.Zone;

/**
 * Zone, Emplacement, Code présentation, Code produit, Nom produit, Lot, DLUO, Valeur relevée
 * 
 * @author echatellier
 */
public class InventoryExportModel implements ExportModel<InventoryBean> {

    @Override
    public char getSeparator() {
        return ';';
    }

    @Override
    public Iterable<ExportableColumn<InventoryBean, Object>> getColumnsForExport() {
        ModelBuilder<Batch> modelBuilder = new ModelBuilder<Batch>();
        modelBuilder.newColumnForExport("Zone", InventoryBean.PROPERTY_ZONE, new ValueFormatter<Zone>() {
            @Override
            public String format(Zone value) {
                String result = "";
                if (value != null) {
                    result = value.toString();
                }
                return result;
            }
        });
        modelBuilder.newColumnForExport("Emplacement", InventoryBean.PROPERTY_PLACE, new ValueFormatter<Place>() {
            @Override
            public String format(Place value) {
                String result = "";
                if (value != null) {
                    result = value.getCode();
                }
                return result;
            }
        });
        modelBuilder.newColumnForExport("Code présentation", InventoryBean.PROPERTY_PRESENTATION_CODE, new ValueFormatter<PresentationCode>() {
            @Override
            public String format(PresentationCode value) {
                String result = "";
                if (value != null) {
                    result = String.valueOf(value.getCode());
                }
                return result;
            }
        });
        modelBuilder.newColumnForExport("Code produit", InventoryBean.PROPERTY_PRODUCT, new ValueFormatter<Product>() {
            @Override
            public String format(Product value) {
                String result = value.getCode();
                return result;
            }
        });
        modelBuilder.newColumnForExport("Nom produit", InventoryBean.PROPERTY_PRODUCT, new ValueFormatter<Product>() {
            @Override
            public String format(Product value) {
                return value.getName();
            }
        });
        modelBuilder.newColumnForExport("Lot", InventoryBean.PROPERTY_BATCH, new ValueFormatter<Batch>() {
            @Override
            public String format(Batch value) {
                String result = "";
                if (value != null) {
                    result = String.valueOf(value.getNumber());
                }
                return result;
            }
        });
        modelBuilder.newColumnForExport("DLUO", InventoryBean.PROPERTY_DLUO, new ValueFormatter<Date>() {
            @Override
            public String format(Date value) {
                String result = "";
                if (value != null) {
                    result = SgqUtils.formatSgqDate(value);
                }
                return result;
            }
        });
        modelBuilder.newColumnForExport("Remarque", InventoryBean.PROPERTY_COMMENT, new ValueFormatter<String>() {
            @Override
            public String format(String value) {
                return value == null ? "" : value;
            }
        });
        modelBuilder.newColumnForExport("Valeur relevée", InventoryBean.PROPERTY_REAL_QUANTITY, new ValueFormatter<Double>() {
            @Override
            public String format(Double value) {
                return ""; // a remplir à l'import
            }
        });
        return (Iterable) modelBuilder.getColumnsForExport();
    }
}
