package com.herbocailleau.sgq.entities;

import com.herbocailleau.sgq.SGQDAOHelper.SGQEntityEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class SupplierDAOAbstract<E extends Supplier> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)Supplier.class;
    }

    @Override
    public SGQEntityEnum getTopiaEntityEnum() {
        return SGQEntityEnum.Supplier;
    }

    @Override
    public void delete(E entity) throws TopiaException {
                                        {
                                        List<Batch> list = getContext()
                                                    .getDAO(Batch.class)
                                                    .findAllByProperties(Batch.PROPERTY_SUPPLIER, entity);
                                            for (Batch item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getSupplier())) {
                                                    item.setSupplier(null);
                                                }
                        
                    }
                }

                                        {
                                        List<Analyze> list = getContext()
                                                    .getDAO(Analyze.class)
                                                    .findAllByProperties(Analyze.PROPERTY_SUPPLIER, entity);
                                            for (Analyze item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getSupplier())) {
                                                    item.setSupplier(null);
                                                }
                        
                    }
                }

        super.delete(entity);
    }

    public E findByNaturalId(String code) throws TopiaException {
        return findByProperties(Supplier.PROPERTY_CODE, code);
    }

    public boolean existByNaturalId(String code) throws TopiaException {
        return existByProperties(Supplier.PROPERTY_CODE, code);
    }

    /**
     * @deprecated since 2.6.10, prefer use {@link #createByNaturalId}
     * @param code 
     * @return 
     * @throws TopiaException
     */
    @Deprecated
    public E create(String code) throws TopiaException {
        return create(Supplier.PROPERTY_CODE, code);
    }

    public E createByNaturalId(String code) throws TopiaException {
        return create(Supplier.PROPERTY_CODE, code);
    }

    public E createByNotNull(String code) throws TopiaException {
        return create(Supplier.PROPERTY_CODE, code);
    }

    public E findByCode(String v) throws TopiaException {
        E result = findByProperty(Supplier.PROPERTY_CODE, v);
        return result;
    }

    public List<E> findAllByCode(String v) throws TopiaException {
        List<E> result = findAllByProperty(Supplier.PROPERTY_CODE, v);
        return result;
    }

    public E findByName(String v) throws TopiaException {
        E result = findByProperty(Supplier.PROPERTY_NAME, v);
        return result;
    }

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(Supplier.PROPERTY_NAME, v);
        return result;
    }

    public E findByLaboratory(boolean v) throws TopiaException {
        E result = findByProperty(Supplier.PROPERTY_LABORATORY, v);
        return result;
    }

    public List<E> findAllByLaboratory(boolean v) throws TopiaException {
        List<E> result = findAllByProperty(Supplier.PROPERTY_LABORATORY, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Batch.class) {
            BatchDAO dao = (BatchDAO)
                getContext().getDAO(Batch.class);
            tmp = dao.findAllBySupplier(entity);
            result.addAll(tmp);
        }

        if (type == Analyze.class) {
            AnalyzeDAO dao = (AnalyzeDAO)
                getContext().getDAO(Analyze.class);
            tmp = dao.findAllBySupplier(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(2);

        List<? extends TopiaEntity> list;

        list = findUsages(Batch.class, entity);
        if (!list.isEmpty()) {
            result.put(Batch.class, list);
        }

        list = findUsages(Analyze.class, entity);
        if (!list.isEmpty()) {
            result.put(Analyze.class, list);
        }

        return result;
    }

} //SupplierDAOAbstract<E extends Supplier>
