package com.herbocailleau.sgq.entities;

import com.herbocailleau.sgq.SGQDAOHelper.SGQEntityEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class PlaceDAOAbstract<E extends Place> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)Place.class;
    }

    @Override
    public SGQEntityEnum getTopiaEntityEnum() {
        return SGQEntityEnum.Place;
    }

    @Override
    public void delete(E entity) throws TopiaException {
                                        {
                                        List<Presentation> list = getContext()
                                                    .getDAO(Presentation.class)
                                                    .findAllByProperties(Presentation.PROPERTY_PLACE, entity);
                                            for (Presentation item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getPlace())) {
                                                    item.setPlace(null);
                                                }
                        
                    }
                }

        super.delete(entity);
    }

    public E findByNaturalId(String name) throws TopiaException {
        return findByProperties(Place.PROPERTY_NAME, name);
    }

    public boolean existByNaturalId(String name) throws TopiaException {
        return existByProperties(Place.PROPERTY_NAME, name);
    }

    /**
     * @deprecated since 2.6.10, prefer use {@link #createByNaturalId}
     * @param name 
     * @return 
     * @throws TopiaException
     */
    @Deprecated
    public E create(String name) throws TopiaException {
        return create(Place.PROPERTY_NAME, name);
    }

    public E createByNaturalId(String name) throws TopiaException {
        return create(Place.PROPERTY_NAME, name);
    }

    public E createByNotNull(String name) throws TopiaException {
        return create(Place.PROPERTY_NAME, name);
    }

    public E findByName(String v) throws TopiaException {
        E result = findByProperty(Place.PROPERTY_NAME, v);
        return result;
    }

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(Place.PROPERTY_NAME, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Presentation.class) {
            PresentationDAO dao = (PresentationDAO)
                getContext().getDAO(Presentation.class);
            tmp = dao.findAllByPlace(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(Presentation.class, entity);
        if (!list.isEmpty()) {
            result.put(Presentation.class, list);
        }

        return result;
    }

} //PlaceDAOAbstract<E extends Place>
