package com.herbocailleau.sgq.entities;

/*
 * #%L
 * SGQ :: Business
 * $Id: BatchDAOImpl.java 53 2012-09-11 16:11:13Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.2/sgq-business/src/main/java/com/herbocailleau/sgq/entities/BatchDAOImpl.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

import java.util.ArrayList;
import java.util.List;

import org.nuiton.topia.TopiaException;

import com.herbocailleau.sgq.business.model.BatchModel;
import com.herbocailleau.sgq.business.model.SearchModel;

public class BatchDAOImpl<E extends Batch> extends BatchDAOAbstract<E> {

    /**
     * Retourne le prochain id non utilisé parmis la liste des numeros
     * de lots entre start et end.
     * 
     * @param start range start
     * @param end range end
     * @return next non used batch number
     */
    public int getNextRangeIdBetween(int start, int end) throws TopiaException {
        String query = "select min(main." + Batch.PROPERTY_NUMBER + " + 1)" +
            " from " + Batch.class.getName() + " as main," +
            " " + Batch.class.getName() + " as sub" +
            " where :start < main." + Batch.PROPERTY_NUMBER +
            " and main." + Batch.PROPERTY_NUMBER + " < :end" +
            " and main." + Batch.PROPERTY_NUMBER + " + 1 not in (sub.number) ";

        Number id = (Number)context.findUnique(query, "start", start, "end", end);

        int result = 0;
        if (id == null) {
            // nothing found in range start..end, just return start
            result = start;
        } else {
            result = id.intValue();
        }

        return result;
    }

    /**
     * Return all batches between range of numbers.
     * 
     * @param start start range
     * @param end end range
     * @return all batches between range of numbers
     * @throws TopiaException
     */
    public List<Batch> findAllBetweenNumbers(int start, int end) throws TopiaException {
        String query = " from " + Batch.class.getName() +
            " where :start <= " + Batch.PROPERTY_NUMBER +
            " and " + Batch.PROPERTY_NUMBER + " <= :end";

        List<Batch> result = context.findAll(query, "start", start, "end", end);

        return result;
    }

    /**
     * Retourne des lots en incluant dans le modèle, la quantité totale
     * restante pour l'ensemble du lot.
     * 
     * @param search search model
     * @return
     * @throws TopiaException
     */
    public List<BatchModel> findAllWithQuantity(SearchModel search) throws TopiaException {
        String query = "select B, sum(P.quantity)" + 
                " from " + Batch.class.getName() + " B, " + Presentation.class.getName() + " P" +
                " where B = P." + Presentation.PROPERTY_BATCH;
        
        query += " and (B.number = :batch";
        query += " or B.product.name like :query)";

        query += " group by B";
        query += " order by B." + Batch.PROPERTY_NUMBER + " ASC";

        int batch = -1;
        try {
            batch = Integer.parseInt(search.getQuery());
        } catch (NumberFormatException ex) {
            
        }

        List<Object[]> beanAndQts = context.findAll(query, "batch", batch, "query", "%" + search.getQuery() + "%");
        List<BatchModel> results = new ArrayList<BatchModel>(beanAndQts.size());
        for (Object[] beanAndQt : beanAndQts) {
            results.add(new BatchModel((Batch)beanAndQt[0], (Double)beanAndQt[1]));
        }
        return results;
    }

} //BatchDAOImpl<E extends Batch>
