package com.herbocailleau.sgq.entities;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

public abstract class SupplierAbstract extends TopiaEntityAbstract implements Supplier {

    /**
     * Nom de l'attribut en BD : code
     */
    protected String code;

    /**
     * Nom de l'attribut en BD : name
     */
    protected String name;

    private static final long serialVersionUID = 3834875785159663970L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, CODE, String.class, code);
        visitor.visit(this, NAME, String.class, name);
        visitor.end(this);
    }

    @Override
    public void setCode(String code) {
        String oldValue = this.code;
        fireOnPreWrite(CODE, oldValue, code);
        this.code = code;
        fireOnPostWrite(CODE, oldValue, code);
    }

    @Override
    public String getCode() {
        fireOnPreRead(CODE, code);
        String result = this.code;
        fireOnPostRead(CODE, code);
        return result;
    }

    @Override
    public void setName(String name) {
        String oldValue = this.name;
        fireOnPreWrite(NAME, oldValue, name);
        this.name = name;
        fireOnPostWrite(NAME, oldValue, name);
    }

    @Override
    public String getName() {
        fireOnPreRead(NAME, name);
        String result = this.name;
        fireOnPostRead(NAME, name);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(CODE, this.code).
            append(NAME, this.name).
         toString();
        return result;
    }

} //SupplierAbstract
