package com.herbocailleau.sgq.entities;

import com.herbocailleau.sgq.SGQDAOHelper.SGQEntityEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class ProductDAOAbstract<E extends Product> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)Product.class;
    }

    @Override
    public SGQEntityEnum getTopiaEntityEnum() {
        return SGQEntityEnum.Product;
    }

    @Override
    public void delete(E entity) throws TopiaException {
                                        {
                                        List<Batch> list = getContext()
                                                    .getDAO(Batch.class)
                                                    .findAllByProperties(Batch.PRODUCT, entity);
                                            for (Batch item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getProduct())) {
                                                    item.setProduct(null);
                                                }
                        
                    }
                }

        super.delete(entity);
    }

    public E findByCode(String v) throws TopiaException {
        E result = findByProperty(Product.CODE, v);
        return result;
    }

    public List<E> findAllByCode(String v) throws TopiaException {
        List<E> result = findAllByProperty(Product.CODE, v);
        return result;
    }

    public E findByName(String v) throws TopiaException {
        E result = findByProperty(Product.NAME, v);
        return result;
    }

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(Product.NAME, v);
        return result;
    }

    public E findByLatinName(String v) throws TopiaException {
        E result = findByProperty(Product.LATIN_NAME, v);
        return result;
    }

    public List<E> findAllByLatinName(String v) throws TopiaException {
        List<E> result = findAllByProperty(Product.LATIN_NAME, v);
        return result;
    }

    public E findByFamily(String v) throws TopiaException {
        E result = findByProperty(Product.FAMILY, v);
        return result;
    }

    public List<E> findAllByFamily(String v) throws TopiaException {
        List<E> result = findAllByProperty(Product.FAMILY, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Batch.class) {
            BatchDAO dao = (BatchDAO)
                getContext().getDAO(Batch.class);
            tmp = dao.findAllByProduct(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(Batch.class, entity);
        if (!list.isEmpty()) {
            result.put(Batch.class, list);
        }

        return result;
    }

} //ProductDAOAbstract<E extends Product>
