package com.herbocailleau.sgq.entities;

import java.util.Collection;
import java.util.Date;
import org.nuiton.topia.persistence.TopiaEntity;

public interface Batch extends TopiaEntity {

    String NUMBER = "number";

    String ENTRY_DATE = "entryDate";

    String DMES = "dmes";

    String DPMES = "dpmes";

    String DLUO = "dluo";

    String SPENT_DATE = "spentDate";

    String NEW_ATTR = "newAttr";

    String ANALYZE = "analyze";

    String PRESENTATION = "presentation";

    String SUPPLIER = "supplier";

    String PRODUCT = "product";

    void setNumber(int number);

    int getNumber();

    void setEntryDate(Date entryDate);

    Date getEntryDate();

    void setDmes(Date dmes);

    Date getDmes();

    void setDpmes(Date dpmes);

    Date getDpmes();

    void setDluo(Date dluo);

    Date getDluo();

    void setSpentDate(Date spentDate);

    Date getSpentDate();

    void setNewAttr(int newAttr);

    int getNewAttr();

    void addAnalyze(Analyze analyze);

    void addAllAnalyze(Collection<Analyze> analyze);

    void setAnalyze(Collection<Analyze> analyze);

    void removeAnalyze(Analyze analyze);

    void clearAnalyze();

    Collection<Analyze> getAnalyze();

    Analyze getAnalyzeByTopiaId(String topiaId);

    int sizeAnalyze();

    boolean isAnalyzeEmpty();

    void addPresentation(Presentation presentation);

    void addAllPresentation(Collection<Presentation> presentation);

    void setPresentation(Collection<Presentation> presentation);

    void removePresentation(Presentation presentation);

    void clearPresentation();

    Collection<Presentation> getPresentation();

    Presentation getPresentationByTopiaId(String topiaId);

    int sizePresentation();

    boolean isPresentationEmpty();

    void setSupplier(Supplier supplier);

    Supplier getSupplier();

    void setProduct(Product product);

    Product getProduct();

} //Batch
