/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.impl;

import com.browseengine.bobo.api.BoboIndexReader;
import com.browseengine.bobo.api.BrowseSelection;
import com.browseengine.bobo.api.FacetSpec;
import com.browseengine.bobo.facets.FacetCountCollector;
import com.browseengine.bobo.facets.FacetCountCollectorSource;
import com.browseengine.bobo.facets.FacetHandler;
import com.browseengine.bobo.facets.data.FacetDataCache;
import com.browseengine.bobo.facets.data.MultiValueFacetDataCache;
import com.browseengine.bobo.facets.data.TermListFactory;
import com.browseengine.bobo.facets.data.TermValueList;
import com.browseengine.bobo.facets.filter.EmptyFilter;
import com.browseengine.bobo.facets.filter.FacetOrFilter;
import com.browseengine.bobo.facets.filter.FacetValueConverter;
import com.browseengine.bobo.facets.filter.MultiValueORFacetFilter;
import com.browseengine.bobo.facets.filter.RandomAccessFilter;
import com.browseengine.bobo.facets.filter.RandomAccessNotFilter;
import com.browseengine.bobo.facets.impl.MultiValuedPathFacetCountCollector;
import com.browseengine.bobo.facets.impl.PathFacetCountCollector;
import com.browseengine.bobo.sort.DocComparatorSource;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.IOException;
import java.util.Properties;
import org.apache.lucene.index.IndexReader;

public class PathFacetHandler
extends FacetHandler<FacetDataCache> {
    private static final String DEFAULT_SEP = "/";
    public static final String SEL_PROP_NAME_STRICT = "strict";
    public static final String SEL_PROP_NAME_DEPTH = "depth";
    private final boolean _multiValue;
    private final TermListFactory _termListFactory;
    private String _separator;
    private final String _indexedName;

    public PathFacetHandler(String name) {
        this(name, false);
    }

    public PathFacetHandler(String name, boolean multiValue) {
        this(name, name, multiValue);
    }

    public PathFacetHandler(String name, String indexedName, boolean multiValue) {
        super(name);
        this._indexedName = indexedName;
        this._multiValue = multiValue;
        this._termListFactory = TermListFactory.StringListFactory;
        this._separator = DEFAULT_SEP;
    }

    public static void setStrict(Properties props, boolean strict) {
        props.setProperty(SEL_PROP_NAME_STRICT, String.valueOf(strict));
    }

    public static void setDepth(Properties props, int depth) {
        props.setProperty(SEL_PROP_NAME_DEPTH, String.valueOf(depth));
    }

    public static boolean isStrict(Properties selectionProp) {
        try {
            return Boolean.valueOf(selectionProp.getProperty(SEL_PROP_NAME_STRICT));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static int getDepth(Properties selectionProp) {
        try {
            return Integer.parseInt(selectionProp.getProperty(SEL_PROP_NAME_DEPTH));
        }
        catch (Exception e) {
            return 1;
        }
    }

    @Override
    public DocComparatorSource getDocComparatorSource() {
        return new FacetDataCache.FacetDocComparatorSource(this);
    }

    @Override
    public String[] getFieldValues(BoboIndexReader reader, int id) {
        FacetDataCache dataCache = (FacetDataCache)this.getFacetData(reader);
        if (this._multiValue) {
            return ((MultiValueFacetDataCache)dataCache)._nestedArray.getTranslatedData(id, dataCache.valArray);
        }
        return new String[]{dataCache.valArray.get(dataCache.orderArray.get(id))};
    }

    @Override
    public Object[] getRawFieldValues(BoboIndexReader reader, int id) {
        return this.getFieldValues(reader, id);
    }

    public void setSeparator(String separator) {
        this._separator = separator;
    }

    public String getSeparator() {
        return this._separator;
    }

    private static int getPathDepth(String path, String separator) {
        return path.split(String.valueOf(separator)).length;
    }

    @Override
    public RandomAccessFilter buildRandomAccessFilter(String value, Properties props) throws IOException {
        int depth = PathFacetHandler.getDepth(props);
        boolean strict = PathFacetHandler.isStrict(props);
        PathValueConverter valConverter = new PathValueConverter(depth, strict, this._separator);
        String[] vals = new String[]{value};
        return this._multiValue ? new MultiValueORFacetFilter(this, vals, valConverter, false) : new FacetOrFilter(this, vals, false, valConverter);
    }

    @Override
    public RandomAccessFilter buildRandomAccessAndFilter(String[] vals, Properties prop) throws IOException {
        if (vals.length > 1) {
            return EmptyFilter.getInstance();
        }
        RandomAccessFilter f = this.buildRandomAccessFilter(vals[0], prop);
        if (f != null) {
            return f;
        }
        return EmptyFilter.getInstance();
    }

    @Override
    public RandomAccessFilter buildRandomAccessOrFilter(String[] vals, Properties prop, boolean isNot) throws IOException {
        if (vals.length > 1) {
            if (vals.length > 0) {
                int depth = PathFacetHandler.getDepth(prop);
                boolean strict = PathFacetHandler.isStrict(prop);
                PathValueConverter valConverter = new PathValueConverter(depth, strict, this._separator);
                return this._multiValue ? new MultiValueORFacetFilter(this, vals, valConverter, isNot) : new FacetOrFilter(this, vals, isNot, valConverter);
            }
            if (isNot) {
                return null;
            }
            return EmptyFilter.getInstance();
        }
        RandomAccessFilter f = this.buildRandomAccessFilter(vals[0], prop);
        if (f == null) {
            return f;
        }
        if (isNot) {
            f = new RandomAccessNotFilter(f);
        }
        return f;
    }

    @Override
    public FacetCountCollectorSource getFacetCountCollectorSource(final BrowseSelection sel, final FacetSpec ospec) {
        return new FacetCountCollectorSource(){

            @Override
            public FacetCountCollector getFacetCountCollector(BoboIndexReader reader, int docBase) {
                FacetDataCache dataCache = (FacetDataCache)PathFacetHandler.this.getFacetData(reader);
                if (PathFacetHandler.this._multiValue) {
                    return new MultiValuedPathFacetCountCollector(PathFacetHandler.this._name, PathFacetHandler.this._separator, sel, ospec, dataCache);
                }
                return new PathFacetCountCollector(PathFacetHandler.this._name, PathFacetHandler.this._separator, sel, ospec, dataCache);
            }
        };
    }

    @Override
    public FacetDataCache load(BoboIndexReader reader) throws IOException {
        if (!this._multiValue) {
            FacetDataCache dataCache = new FacetDataCache();
            dataCache.load(this._indexedName, (IndexReader)reader, this._termListFactory);
            return dataCache;
        }
        MultiValueFacetDataCache dataCache = new MultiValueFacetDataCache();
        dataCache.load(this._indexedName, (IndexReader)reader, this._termListFactory);
        return dataCache;
    }

    private static class PathValueConverter
    implements FacetValueConverter {
        private final boolean _strict;
        private final String _sep;
        private final int _depth;

        PathValueConverter(int depth, boolean strict, String sep) {
            this._strict = strict;
            this._sep = sep;
            this._depth = depth;
        }

        private void getFilters(FacetDataCache dataCache, IntSet intSet, String[] vals, int depth, boolean strict) {
            for (String val : vals) {
                this.getFilters(dataCache, intSet, val, depth, strict);
            }
        }

        private void getFilters(FacetDataCache dataCache, IntSet intSet, String val, int depth, boolean strict) {
            String path;
            TermValueList termList = dataCache.valArray;
            int index = termList.indexOf(val);
            int startDepth = PathFacetHandler.getPathDepth(val, this._sep);
            if (index < 0) {
                int nextIndex = -(index + 1);
                if (nextIndex == termList.size()) {
                    return;
                }
                index = nextIndex;
            }
            for (int i = index; i < termList.size() && (path = (String)termList.get(i)).startsWith(val); ++i) {
                if (strict && PathFacetHandler.getPathDepth(path, this._sep) - startDepth != depth) continue;
                intSet.add(i);
            }
        }

        @Override
        public int[] convert(FacetDataCache dataCache, String[] vals) {
            IntOpenHashSet intSet = new IntOpenHashSet();
            this.getFilters(dataCache, (IntSet)intSet, vals, this._depth, this._strict);
            return intSet.toIntArray();
        }
    }
}

