/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.data;

import com.browseengine.bobo.facets.data.TermValueList;
import java.text.DecimalFormat;

public abstract class TermNumberList<T extends Number>
extends TermValueList<T> {
    private static final String DEFAULT_FORMATTING_STRING = "0000000000";
    protected ThreadLocal<DecimalFormat> _formatter = null;
    protected String _formatString = null;

    protected TermNumberList() {
        this.setFormatString(DEFAULT_FORMATTING_STRING);
    }

    protected TermNumberList(String formatString) {
        this.setFormatString(formatString);
    }

    protected TermNumberList(int capacity, String formatString) {
        super(capacity);
        this.setFormatString(formatString);
    }

    protected void setFormatString(String formatString) {
        this._formatString = formatString;
        this._formatter = new ThreadLocal<DecimalFormat>(){

            @Override
            protected DecimalFormat initialValue() {
                if (TermNumberList.this._formatString != null) {
                    return new DecimalFormat(TermNumberList.this._formatString);
                }
                return null;
            }
        };
    }

    public String getFormatString() {
        return this._formatString;
    }

    protected abstract Object parseString(String var1);

    @Override
    public String format(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            o = this.parseString((String)o);
        }
        if (this._formatter == null) {
            return String.valueOf(o);
        }
        DecimalFormat formatter = this._formatter.get();
        if (formatter == null) {
            return String.valueOf(o);
        }
        return formatter.format(o);
    }
}

