/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.query.scoring;

import com.browseengine.bobo.query.scoring.FacetTermScoringFunction;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.Explanation;

public abstract class BoboDocScorer {
    protected final FacetTermScoringFunction _function;
    protected final float[] _boostList;

    public BoboDocScorer(FacetTermScoringFunction scoreFunction, float[] boostList) {
        this._function = scoreFunction;
        this._boostList = boostList;
    }

    public abstract float score(int var1);

    public abstract Explanation explain(int var1);

    public static float[] buildBoostList(List<String> valArray, Map<String, Float> boostMap) {
        float[] boostList = new float[valArray.size()];
        Arrays.fill(boostList, 1.0f);
        if (boostMap != null && boostMap.size() > 0) {
            for (Map.Entry<String, Float> entry : boostMap.entrySet()) {
                Float fval;
                int index = valArray.indexOf(entry.getKey());
                if (index < 0 || (fval = entry.getValue()) == null) continue;
                boostList[index] = fval.floatValue();
            }
        }
        return boostList;
    }
}

