/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.impl;

import com.browseengine.bobo.api.BoboIndexReader;
import com.browseengine.bobo.api.BrowseSelection;
import com.browseengine.bobo.api.FacetSpec;
import com.browseengine.bobo.facets.FacetCountCollector;
import com.browseengine.bobo.facets.FacetCountCollectorSource;
import com.browseengine.bobo.facets.FacetHandler;
import com.browseengine.bobo.facets.data.FacetDataCache;
import com.browseengine.bobo.facets.data.TermListFactory;
import com.browseengine.bobo.facets.filter.EmptyFilter;
import com.browseengine.bobo.facets.filter.FacetOrFilter;
import com.browseengine.bobo.facets.filter.FacetRangeFilter;
import com.browseengine.bobo.facets.filter.RandomAccessAndFilter;
import com.browseengine.bobo.facets.filter.RandomAccessFilter;
import com.browseengine.bobo.facets.filter.RandomAccessNotFilter;
import com.browseengine.bobo.facets.impl.RangeFacetCountCollector;
import com.browseengine.bobo.sort.DocComparatorSource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.lucene.index.IndexReader;

public class RangeFacetHandler
extends FacetHandler<FacetDataCache> {
    private static Logger logger = Logger.getLogger(RangeFacetHandler.class);
    private final String _indexFieldName;
    private final TermListFactory _termListFactory;
    private final List<String> _predefinedRanges;

    public RangeFacetHandler(String name, String indexFieldName, TermListFactory termListFactory, List<String> predefinedRanges) {
        super(name);
        this._indexFieldName = indexFieldName;
        this._termListFactory = termListFactory;
        this._predefinedRanges = predefinedRanges;
    }

    public RangeFacetHandler(String name, TermListFactory termListFactory, List<String> predefinedRanges) {
        this(name, name, termListFactory, predefinedRanges);
    }

    public RangeFacetHandler(String name, List<String> predefinedRanges) {
        this(name, name, null, predefinedRanges);
    }

    public RangeFacetHandler(String name, String indexFieldName, List<String> predefinedRanges) {
        this(name, indexFieldName, null, predefinedRanges);
    }

    @Override
    public DocComparatorSource getDocComparatorSource() {
        return new FacetDataCache.FacetDocComparatorSource(this);
    }

    @Override
    public String[] getFieldValues(BoboIndexReader reader, int id) {
        FacetDataCache dataCache = (FacetDataCache)this.getFacetData(reader);
        return new String[]{dataCache.valArray.get(dataCache.orderArray.get(id))};
    }

    @Override
    public Object[] getRawFieldValues(BoboIndexReader reader, int id) {
        FacetDataCache dataCache = (FacetDataCache)this.getFacetData(reader);
        return new Object[]{dataCache.valArray.getRawValue(dataCache.orderArray.get(id))};
    }

    public static String[] getRangeStrings(String rangeString) {
        int index = rangeString.indexOf(91);
        int index2 = rangeString.indexOf(" TO ");
        int index3 = rangeString.indexOf(93);
        try {
            String lower = rangeString.substring(index + 1, index2).trim();
            String upper = rangeString.substring(index2 + 4, index3).trim();
            return new String[]{lower, upper};
        }
        catch (RuntimeException re) {
            logger.error((Object)("problem parsing range string: " + rangeString + ":" + re.getMessage()), (Throwable)re);
            throw re;
        }
    }

    @Override
    public RandomAccessFilter buildRandomAccessFilter(String value, Properties prop) throws IOException {
        return new FacetRangeFilter(this, value);
    }

    @Override
    public RandomAccessFilter buildRandomAccessAndFilter(String[] vals, Properties prop) throws IOException {
        ArrayList<RandomAccessFilter> filterList = new ArrayList<RandomAccessFilter>(vals.length);
        for (String val : vals) {
            RandomAccessFilter f = this.buildRandomAccessFilter(val, prop);
            if (f == null) {
                return EmptyFilter.getInstance();
            }
            filterList.add(f);
        }
        if (filterList.size() == 1) {
            return (RandomAccessFilter)((Object)filterList.get(0));
        }
        return new RandomAccessAndFilter(filterList);
    }

    @Override
    public RandomAccessFilter buildRandomAccessOrFilter(String[] vals, Properties prop, boolean isNot) throws IOException {
        if (vals.length > 1) {
            return new FacetOrFilter(this, vals, isNot, FacetRangeFilter.FacetRangeValueConverter.instance);
        }
        RandomAccessFilter filter = this.buildRandomAccessFilter(vals[0], prop);
        if (filter == null) {
            return filter;
        }
        if (isNot) {
            filter = new RandomAccessNotFilter(filter);
        }
        return filter;
    }

    @Override
    public FacetCountCollectorSource getFacetCountCollectorSource(BrowseSelection sel, final FacetSpec ospec) {
        return new FacetCountCollectorSource(){

            @Override
            public FacetCountCollector getFacetCountCollector(BoboIndexReader reader, int docBase) {
                FacetDataCache dataCache = (FacetDataCache)RangeFacetHandler.this.getFacetData(reader);
                return new RangeFacetCountCollector(RangeFacetHandler.this._name, dataCache, docBase, ospec, RangeFacetHandler.this._predefinedRanges);
            }
        };
    }

    public boolean hasPredefinedRanges() {
        return this._predefinedRanges != null;
    }

    @Override
    public FacetDataCache load(BoboIndexReader reader) throws IOException {
        FacetDataCache dataCache = new FacetDataCache();
        dataCache.load(this._indexFieldName, (IndexReader)reader, this._termListFactory);
        return dataCache;
    }
}

