/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.impl;

import com.browseengine.bobo.api.BoboIndexReader;
import com.browseengine.bobo.api.BrowseSelection;
import com.browseengine.bobo.api.FacetSpec;
import com.browseengine.bobo.facets.FacetCountCollector;
import com.browseengine.bobo.facets.FacetCountCollectorSource;
import com.browseengine.bobo.facets.FacetHandler;
import com.browseengine.bobo.facets.RuntimeFacetHandler;
import com.browseengine.bobo.facets.data.FacetDataCache;
import com.browseengine.bobo.facets.filter.RandomAccessAndFilter;
import com.browseengine.bobo.facets.filter.RandomAccessFilter;
import com.browseengine.bobo.facets.impl.GeoSimpleFacetCountCollector;
import com.browseengine.bobo.facets.impl.RangeFacetHandler;
import com.browseengine.bobo.sort.DocComparator;
import com.browseengine.bobo.sort.DocComparatorSource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.ScoreDoc;

public abstract class GeoSimpleFacetHandler
extends RuntimeFacetHandler<FacetHandler.FacetDataNone> {
    private static Logger logger = Logger.getLogger(RangeFacetHandler.class);
    protected final String _latFacetName;
    protected final String _longFacetName;
    protected RangeFacetHandler _latFacetHandler;
    protected RangeFacetHandler _longFacetHandler;

    public GeoSimpleFacetHandler(String name, String latFacetName, String longFacetName) {
        super(name, new HashSet<String>(Arrays.asList(latFacetName, longFacetName)));
        this._latFacetName = latFacetName;
        this._longFacetName = longFacetName;
    }

    protected abstract String buildLatRangeString(String var1);

    protected abstract String buildLongRangeString(String var1);

    protected abstract List<String> buildAllRangeStrings(String[] var1);

    protected abstract String getValueFromRangeString(String var1);

    @Override
    public RandomAccessFilter buildRandomAccessFilter(String val, Properties props) throws IOException {
        RandomAccessFilter latFilter = this._latFacetHandler.buildRandomAccessFilter(this.buildLatRangeString(val), props);
        RandomAccessFilter longFilter = this._longFacetHandler.buildRandomAccessFilter(this.buildLongRangeString(val), props);
        return new RandomAccessAndFilter(Arrays.asList(latFilter, longFilter));
    }

    @Override
    public RandomAccessFilter buildRandomAccessAndFilter(String[] vals, Properties props) throws IOException {
        ArrayList<String> latValList = new ArrayList<String>(vals.length);
        ArrayList<String> longValList = new ArrayList<String>(vals.length);
        for (String val : vals) {
            latValList.add(this.buildLatRangeString(val));
            longValList.add(this.buildLongRangeString(val));
        }
        RandomAccessFilter latFilter = this._latFacetHandler.buildRandomAccessAndFilter(latValList.toArray(new String[latValList.size()]), props);
        RandomAccessFilter longFilter = this._longFacetHandler.buildRandomAccessAndFilter(longValList.toArray(new String[longValList.size()]), props);
        return new RandomAccessAndFilter(Arrays.asList(latFilter, longFilter));
    }

    @Override
    public RandomAccessFilter buildRandomAccessOrFilter(String[] vals, Properties props, boolean isNot) throws IOException {
        ArrayList<String> latValList = new ArrayList<String>(vals.length);
        ArrayList<String> longValList = new ArrayList<String>(vals.length);
        for (String val : vals) {
            latValList.add(this.buildLatRangeString(val));
            longValList.add(this.buildLongRangeString(val));
        }
        RandomAccessFilter latFilter = this._latFacetHandler.buildRandomAccessOrFilter(latValList.toArray(new String[latValList.size()]), props, isNot);
        RandomAccessFilter longFilter = this._longFacetHandler.buildRandomAccessOrFilter(longValList.toArray(new String[longValList.size()]), props, isNot);
        return new RandomAccessAndFilter(Arrays.asList(latFilter, longFilter));
    }

    @Override
    public FacetCountCollectorSource getFacetCountCollectorSource(final BrowseSelection sel, final FacetSpec fspec) {
        return new FacetCountCollectorSource(){
            final List<String> list;
            {
                this.list = GeoSimpleFacetHandler.this.buildAllRangeStrings(sel.getValues());
            }

            @Override
            public FacetCountCollector getFacetCountCollector(BoboIndexReader reader, int docBase) {
                FacetDataCache latDataCache = (FacetDataCache)GeoSimpleFacetHandler.this._latFacetHandler.getFacetData(reader);
                FacetDataCache longDataCache = (FacetDataCache)GeoSimpleFacetHandler.this._longFacetHandler.getFacetData(reader);
                return new GeoSimpleFacetCountCollector(GeoSimpleFacetHandler.this._name, latDataCache, longDataCache, docBase, fspec, this.list);
            }
        };
    }

    public static String[] getRangeStrings(String rangeString) {
        int index = rangeString.indexOf(60);
        int index2 = rangeString.indexOf(62);
        try {
            String range = rangeString.substring(index + 1, index2).trim();
            String[] values = range.split(",");
            float latitude = Float.parseFloat(values[0]);
            float longitude = Float.parseFloat(values[1]);
            float radius = Float.parseFloat(values[2]);
            float latStart = latitude - radius;
            float latEnd = latitude + radius;
            float longStart = longitude - radius;
            float longEnd = longitude + radius;
            return new String[]{String.valueOf(latStart), String.valueOf(latEnd), String.valueOf(longStart), String.valueOf(longEnd)};
        }
        catch (RuntimeException re) {
            logger.error((Object)("problem parsing range string: " + rangeString + ":" + re.getMessage()), (Throwable)re);
            throw re;
        }
    }

    @Override
    public String[] getFieldValues(BoboIndexReader reader, int docid) {
        String[] latValues = this._latFacetHandler.getFieldValues(reader, docid);
        String[] longValues = this._longFacetHandler.getFieldValues(reader, docid);
        String[] allValues = new String[latValues.length + longValues.length];
        int index = 0;
        for (String value : latValues) {
            allValues[index++] = value;
        }
        for (String value : longValues) {
            allValues[index++] = value;
        }
        return allValues;
    }

    @Override
    public Object[] getRawFieldValues(BoboIndexReader reader, int docid) {
        Object[] latValues = this._latFacetHandler.getRawFieldValues(reader, docid);
        Object[] longValues = this._longFacetHandler.getRawFieldValues(reader, docid);
        Object[] allValues = new Object[latValues.length + longValues.length];
        int index = 0;
        for (Object value : latValues) {
            allValues[index++] = value;
        }
        for (Object value : longValues) {
            allValues[index++] = value;
        }
        return allValues;
    }

    @Override
    public FacetHandler.FacetDataNone load(BoboIndexReader reader) throws IOException {
        this._latFacetHandler = (RangeFacetHandler)this.getDependedFacetHandler(this._latFacetName);
        this._longFacetHandler = (RangeFacetHandler)this.getDependedFacetHandler(this._longFacetName);
        return FacetHandler.FacetDataNone.instance;
    }

    @Override
    public DocComparatorSource getDocComparatorSource() {
        return new GeoFacetDocComparatorSource(this);
    }

    public static class GeoFacetDocComparatorSource
    extends DocComparatorSource {
        private FacetHandler<FacetHandler.FacetDataNone> _facetHandler;

        public GeoFacetDocComparatorSource(GeoSimpleFacetHandler geoSimpleFacetHandler) {
            this._facetHandler = geoSimpleFacetHandler;
        }

        @Override
        public DocComparator getComparator(IndexReader reader, int docbase) throws IOException {
            if (!(reader instanceof BoboIndexReader)) {
                throw new IllegalStateException("reader not instance of " + BoboIndexReader.class);
            }
            BoboIndexReader boboReader = (BoboIndexReader)reader;
            FacetHandler.FacetDataNone dataCache = this._facetHandler.getFacetData((BoboIndexReader)reader);
            return new DocComparator(){

                @Override
                public Comparable value(ScoreDoc doc) {
                    return Integer.valueOf(1);
                }

                @Override
                public int compare(ScoreDoc doc1, ScoreDoc doc2) {
                    return 0;
                }
            };
        }
    }
}

