/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.symbology.milStd2525;

import com.bbn.openmap.util.ArgParser;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.FileUtils;
import com.bbn.openmap.util.wanderer.Wanderer;
import com.bbn.openmap.util.wanderer.WandererCallback;
import java.io.File;
import java.io.IOException;

public class SVGSourceFileReorganizer
extends Wanderer
implements WandererCallback {
    File rootDir;
    boolean verbose = false;

    public SVGSourceFileReorganizer(File rootDir) {
        this.rootDir = rootDir;
        this.rootDir.mkdirs();
        this.setExhaustiveSearch(true);
        this.setTopToBottom(false);
        this.setCallback(this);
    }

    public void setVerbose(boolean val) {
        this.verbose = val;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public boolean handleFile(File file) {
        block5: {
            String parent = file.getParent();
            String fileName = file.getName();
            if (!fileName.endsWith(".svg")) {
                return true;
            }
            String newFileName = fileName.substring(2);
            File target = new File(this.rootDir, newFileName);
            try {
                if (this.verbose) {
                    System.out.println("copying " + file + " to " + target);
                    if (target.exists()) {
                        System.out.println("++++ overwriting " + target);
                    }
                }
                FileUtils.copy(file, target, 2500);
            }
            catch (IOException ioe) {
                if (!this.verbose) break block5;
                System.out.println("Problem copying " + file + " to " + target);
            }
        }
        return true;
    }

    public static void main(String[] argv) {
        String[] targetDirs;
        Debug.init();
        boolean toUpper = true;
        ArgParser ap = new ArgParser("ChangeCase");
        ap.add("source", "The directory to search for source svg files.", -1);
        ap.add("target", "The target directory to place gathered and modified files.", 1);
        ap.add("verbose", "Talk alot.");
        if (argv.length == 0) {
            ap.bail("", true);
        }
        ap.parse(argv);
        String[] sourceDirs = ap.getArgValues("source");
        if (sourceDirs == null) {
            ap.bail("Need source directories", true);
        }
        if ((targetDirs = ap.getArgValues("target")) == null || targetDirs.length > 1) {
            ap.bail("Need target directory", true);
        }
        boolean verbose = false;
        String[] verboseTest = ap.getArgValues("verbose");
        if (verboseTest != null) {
            verbose = true;
        }
        if (targetDirs != null && sourceDirs != null) {
            SVGSourceFileReorganizer cc = new SVGSourceFileReorganizer(new File(targetDirs[0]));
            cc.setVerbose(verbose);
            for (int i = 0; i < sourceDirs.length; ++i) {
                cc.handleEntry(new File(sourceDirs[i]));
            }
        }
    }

    public boolean handleDirectory(File directory) {
        return true;
    }
}

