/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics.labeled;

import com.bbn.openmap.omGraphics.OMSpline;
import com.bbn.openmap.omGraphics.OMText;
import com.bbn.openmap.omGraphics.labeled.LabeledOMGraphic;
import com.bbn.openmap.proj.GeoProj;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.Point;
import java.awt.geom.Point2D;

public class LabeledOMSpline
extends OMSpline
implements LabeledOMGraphic {
    protected OMText label;
    protected Point offset;
    protected boolean locateAtCenter = false;
    protected int index = 0;
    boolean matchPolyPaint = true;
    Point handyPoint = new Point();

    public LabeledOMSpline() {
    }

    public LabeledOMSpline(double[] llPoints, int units, int lType) {
        super(llPoints, units, lType);
    }

    public LabeledOMSpline(double[] llPoints, int units, int lType, int nsegs) {
        super(llPoints, units, lType, nsegs);
    }

    public LabeledOMSpline(int[] xypoints) {
        super(xypoints);
    }

    public LabeledOMSpline(int[] xPoints, int[] yPoints) {
        super(xPoints, yPoints);
    }

    public LabeledOMSpline(float latPoint, float lonPoint, int[] xypoints, int cMode) {
        super(latPoint, lonPoint, xypoints, cMode);
    }

    public LabeledOMSpline(float latPoint, float lonPoint, int[] xPoints, int[] yPoints, int cMode) {
        super(latPoint, lonPoint, xPoints, yPoints, cMode);
    }

    public void setText(String label) {
        this.getLabel().setData(label);
    }

    public String getText() {
        return this.getLabel().getData();
    }

    protected OMText getLabel() {
        if (this.label == null) {
            this.label = new OMText(-1, -1, "", 0);
        }
        return this.label;
    }

    public void setFont(Font f) {
        this.getLabel().setFont(f);
    }

    public Font getFont() {
        return this.getLabel().getFont();
    }

    public void setJustify(int just) {
        this.getLabel().setJustify(just);
    }

    public int getJustify() {
        return this.getLabel().getJustify();
    }

    public void setLocateAtCenter(boolean set) {
        this.locateAtCenter = set;
        if (set) {
            this.setJustify(1);
            this.getLabel().setFMHeight(3);
        }
    }

    public boolean isLocateAtCenter() {
        return this.locateAtCenter;
    }

    public Point getCenter() {
        return new Point();
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public void setOffset(Point p) {
        this.offset = p;
    }

    public Point getOffset() {
        if (this.offset == null) {
            this.offset = new Point();
        }
        return this.offset;
    }

    public void setRotationAngle(double angle) {
        this.getLabel().setRotationAngle(angle);
    }

    public double getRotationAngle() {
        return this.getLabel().getRotationAngle();
    }

    public void setLinePaint(Paint paint) {
        super.setLinePaint(paint);
        if (this.matchPolyPaint) {
            this.getLabel().setLinePaint(paint);
        }
    }

    public void setTextPaint(Paint paint) {
        if (paint != null) {
            this.matchPolyPaint = false;
            this.getLabel().setLinePaint(paint);
        }
    }

    protected Point getTextPoint(Projection proj) {
        int avgx = 0;
        int avgy = 0;
        if (this.renderType == 1 && proj instanceof GeoProj) {
            int numPoints = this.rawllpts.length / 2;
            if (this.rawllpts.length < 2) {
                this.handyPoint.setLocation(-10, -10);
                return this.handyPoint;
            }
            if (this.locateAtCenter) {
                for (int i = 0; i < this.rawllpts.length; i += 2) {
                    ((GeoProj)proj).forward(this.rawllpts[i], this.rawllpts[i + 1], (Point2D)this.handyPoint, true);
                    avgy = (int)((double)avgy + this.handyPoint.getY());
                    avgx = (int)((double)avgx + this.handyPoint.getX());
                }
                this.handyPoint.setLocation(avgx /= numPoints, avgy /= numPoints);
            } else {
                if (this.index < 0) {
                    this.index = 0;
                }
                if (this.index > numPoints) {
                    this.index = numPoints - 1;
                }
                ((GeoProj)proj).forward(this.rawllpts[2 * this.index], this.rawllpts[2 * this.index + 1], (Point2D)this.handyPoint, true);
            }
        } else {
            float[][] x = this.xpoints;
            float[][] y = this.ypoints;
            if (x[0].length < 2) {
                this.handyPoint.setLocation(-10, -10);
                return this.handyPoint;
            }
            if (this.locateAtCenter) {
                for (int i = 0; i < x[0].length; ++i) {
                    avgx = (int)((float)avgx + x[0][i]);
                    avgy = (int)((float)avgy + y[0][i]);
                }
                this.handyPoint.setLocation(avgx / x[0].length, avgy / x[0].length);
            } else {
                if (this.index < 0) {
                    this.index = 0;
                }
                if (this.index >= x[0].length) {
                    this.index = x[0].length - 1;
                }
                this.handyPoint.setLocation(x[0][this.index], y[0][this.index]);
            }
        }
        return this.handyPoint;
    }

    public boolean generate(Projection proj) {
        boolean ret = super.generate(proj);
        Point p = this.getTextPoint(proj);
        this.label.setX((int)(p.getX() + this.getOffset().getX()));
        this.label.setY((int)(p.getY() + this.getOffset().getY()));
        if (Debug.debugging("labeled")) {
            Debug.output("Setting label(" + this.label.getData() + ") to " + p);
        }
        this.label.generate(proj);
        return ret;
    }

    public void render(Graphics g) {
        super.render(g);
        this.label.render(g);
    }
}

