/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer;

import com.bbn.openmap.event.MapMouseListener;
import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.omGraphics.OMText;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.ColorFactory;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import com.bbn.openmap.util.Taskable;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Properties;

public class LabelLayer
extends OMGraphicHandlerLayer
implements Taskable,
MapMouseListener {
    public static final transient String fontProperty = "font";
    public static final transient String fgColorProperty = "color.fg";
    public static final transient String bgColorProperty = "color.bg";
    public static final transient String geometryProperty = "geometry";
    public static final transient String labelProperty = "text";
    protected String fontString = "SansSerif";
    protected Font font = Font.decode(this.fontString);
    protected int fgColorValue = 0;
    protected Color fgColor = new Color(this.fgColorValue);
    protected int bgColorValue = 0xFFFFFF;
    protected Color bgColor = new Color(this.bgColorValue);
    protected String geometryString = "+20+20";
    protected String labelText = "";
    protected OMText text;
    protected int xpos = 10;
    protected int ypos = 10;
    protected String xgrav = this.geometryString.substring(0, 1);
    protected String ygrav = this.geometryString.substring(3, 4);
    private int dragX;
    private int dragY;
    private boolean dragging = false;

    public LabelLayer() {
        this.text = new OMText(0, 0, "uninitialized", this.font, 2);
        this.text.setLinePaint(this.fgColor);
        this.text.setFillPaint(this.bgColor);
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.fontString = props.getProperty(prefix + fontProperty, this.fontString);
        this.fgColor = ColorFactory.parseColorFromProperties(props, prefix + fgColorProperty, Integer.toString(this.fgColorValue));
        this.bgColor = ColorFactory.parseColorFromProperties(props, prefix + bgColorProperty, Integer.toString(this.bgColorValue));
        this.geometryString = props.getProperty(prefix + geometryProperty, this.geometryString);
        this.parseGeometryString();
        this.labelText = props.getProperty(prefix + labelProperty, this.labelText);
        this.font = Font.decode(this.fontString);
        this.text.setFont(this.font);
        this.text.setLinePaint(this.fgColor);
        this.text.setFillPaint(this.bgColor);
    }

    protected void parseGeometryString() {
        int i = 0;
        byte[] bytes = this.geometryString.getBytes();
        this.xgrav = new String(bytes, 0, 1);
        for (i = 2; i < bytes.length && bytes[i] != 45 && bytes[i] != 43; ++i) {
        }
        if (i == bytes.length) {
            return;
        }
        this.ygrav = bytes[i] == 45 ? "-" : "+";
        this.xpos = Integer.parseInt(new String(bytes, 1, i - 1));
        this.ypos = Integer.parseInt(new String(bytes, ++i, bytes.length - i));
    }

    protected void positionText(int w, int h) {
        int justify;
        int xoff;
        if (this.xgrav.equals("+")) {
            xoff = this.xpos;
            justify = 0;
        } else {
            xoff = w - this.xpos;
            justify = 2;
        }
        int yoff = this.ygrav.equals("+") ? this.ypos : h - this.ypos;
        this.text.setX(xoff);
        this.text.setY(yoff);
        this.text.setJustify(justify);
    }

    public void setLabelText(String s) {
        this.labelText = s;
    }

    public String getLabelText() {
        return this.labelText;
    }

    public void paint(Graphics g) {
        Projection p = this.getProjection();
        if (p == null) {
            return;
        }
        if (Debug.debugging("labellayer")) {
            System.out.println("labelLayer.paint(): " + this.labelText);
        }
        this.positionText(p.getWidth(), p.getHeight());
        this.text.setData(this.labelText);
        this.text.generate(p);
        this.text.render(g);
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (Debug.debugging("labellayer")) {
            System.out.println("LabelLayer.actionPerformed()");
        }
        this.repaint();
    }

    public MapMouseListener getMapMouseListener() {
        return this;
    }

    public String[] getMouseModeServiceList() {
        return new String[]{"Gestures"};
    }

    public boolean mousePressed(MouseEvent e) {
        int y;
        int x = e.getX();
        if (this.text.distance(x, y = e.getY()) <= 0.0f) {
            this.dragging = true;
            this.dragX = x;
            this.dragY = y;
            return true;
        }
        return false;
    }

    public boolean mouseReleased(MouseEvent e) {
        this.dragging = false;
        return false;
    }

    public boolean mouseClicked(MouseEvent e) {
        return false;
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public boolean mouseDragged(MouseEvent e) {
        Projection proj = this.getProjection();
        int w = proj.getWidth();
        int h = proj.getHeight();
        int x = e.getX();
        int y = e.getY();
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if (x > w) {
            x = w;
        }
        if (y > h) {
            y = h;
        }
        int dx = x - this.dragX;
        int dy = y - this.dragY;
        if (this.dragging) {
            this.dragX = x;
            this.dragY = y;
            this.text.setX(this.text.getX() + dx);
            this.text.setY(this.text.getY() + dy);
            this.repaint();
            return true;
        }
        return false;
    }

    public boolean mouseMoved(MouseEvent e) {
        return false;
    }

    public void mouseMoved() {
    }

    public int getSleepHint() {
        return 1000000;
    }
}

