/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui;

import com.bbn.openmap.MapBean;
import com.bbn.openmap.gui.NavigatePanel;
import com.bbn.openmap.gui.OMComponentPanel;
import com.bbn.openmap.gui.ScaleTextPanel;
import com.bbn.openmap.gui.Tool;
import com.bbn.openmap.gui.ZoomPanel;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class OMToolSet
extends OMComponentPanel
implements Serializable,
Tool {
    public static final String defaultKey = "omtoolset";
    protected String key = "omtoolset";
    protected transient NavigatePanel navPanel = null;
    protected transient ZoomPanel zoomPanel = null;
    protected transient ScaleTextPanel scaleField = null;
    public static final String AddZoomProperty = "addZoom";
    public static final String AddPanProperty = "addPan";
    public static final String AddScaleProperty = "addScale";
    protected boolean addZoom = true;
    protected boolean addPan = true;
    protected boolean addScale = true;

    public OMToolSet() {
        Debug.message(defaultKey, "OMToolSet()");
        this.setLayout(new FlowLayout(0));
        this.navPanel = new NavigatePanel();
        this.zoomPanel = new ZoomPanel();
        this.scaleField = new ScaleTextPanel();
        this.add(this.navPanel);
        this.add(this.zoomPanel);
        this.add(this.scaleField);
        this.createFace();
    }

    public Container getFace() {
        return this;
    }

    protected void createFace() {
        this.zoomPanel.setVisible(this.addZoom);
        this.navPanel.setVisible(this.addPan);
        this.scaleField.setVisible(this.addScale);
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String aKey) {
        this.key = aKey;
    }

    public ZoomPanel getZoomPanel() {
        return this.zoomPanel;
    }

    public NavigatePanel getNavigatePanel() {
        return this.navPanel;
    }

    public ScaleTextPanel getScaleField() {
        return this.scaleField;
    }

    public void setupListeners(MapBean aMapBean) {
        if (aMapBean != null) {
            this.findAndInit(aMapBean);
        }
    }

    public void removeFromAllListeners(MapBean aMapBean) {
        if (aMapBean != null) {
            this.findAndUndo(aMapBean);
        }
    }

    public void addButton(String name, String info, ActionListener al) {
        try {
            URL url = PropUtils.getResourceOrFileOrURL(null, name);
            if (url != null) {
                this.addButton(url, info, al);
            }
        }
        catch (MalformedURLException murle) {
            Debug.error("OMToolSet.addButton: can't create button for " + info);
        }
    }

    public void addButton(URL url, String info, ActionListener al) {
        JButton b = new JButton(new ImageIcon(url, info));
        b.setToolTipText(info);
        b.setMargin(new Insets(0, 0, 0, 0));
        b.addActionListener(al);
        b.setBorderPainted(false);
        this.add(b);
    }

    public void findAndInit(Object someObj) {
        this.navPanel.findAndInit(someObj);
        this.zoomPanel.findAndInit(someObj);
        this.scaleField.findAndInit(someObj);
    }

    public void findAndUndo(Object someObj) {
        this.navPanel.findAndUndo(someObj);
        this.zoomPanel.findAndUndo(someObj);
        this.scaleField.findAndUndo(someObj);
    }

    public void setProperties(String prefix, Properties setList) {
        this.setPropertyPrefix(prefix);
        if (prefix != null) {
            this.setKey(prefix);
        }
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.addZoom = PropUtils.booleanFromProperties(setList, prefix + AddZoomProperty, this.addZoom);
        this.addPan = PropUtils.booleanFromProperties(setList, prefix + AddPanProperty, this.addPan);
        this.addScale = PropUtils.booleanFromProperties(setList, prefix + AddScaleProperty, this.addScale);
        this.createFace();
    }

    public Properties getProperties(Properties getList) {
        if (getList == null) {
            getList = new Properties();
        }
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        getList.put(prefix + AddZoomProperty, new Boolean(this.addZoom).toString());
        getList.put(prefix + AddPanProperty, new Boolean(this.addPan).toString());
        getList.put(prefix + AddScaleProperty, new Boolean(this.addScale).toString());
        return getList;
    }

    public Properties getPropertyInfo(Properties list) {
        if (list == null) {
            list = new Properties();
        }
        list.put(AddZoomProperty, "Flag to add the Zoom buttons");
        list.put("addZoom.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        list.put(AddPanProperty, "Flag to add the Pan buttons");
        list.put("addPan.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        list.put(AddScaleProperty, "Flag to add the scale field");
        list.put("addScale.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        return list;
    }
}

