/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.shape;

import com.bbn.openmap.dataAccess.shape.EsriGraphic;
import com.bbn.openmap.dataAccess.shape.EsriGraphicList;
import com.bbn.openmap.dataAccess.shape.EsriIconPoint;
import com.bbn.openmap.dataAccess.shape.EsriPoint;
import com.bbn.openmap.dataAccess.shape.EsriPointList;
import com.bbn.openmap.dataAccess.shape.EsriPolygon;
import com.bbn.openmap.dataAccess.shape.EsriPolygonList;
import com.bbn.openmap.dataAccess.shape.EsriPolygonM;
import com.bbn.openmap.dataAccess.shape.EsriPolygonMList;
import com.bbn.openmap.dataAccess.shape.EsriPolygonZ;
import com.bbn.openmap.dataAccess.shape.EsriPolygonZList;
import com.bbn.openmap.dataAccess.shape.EsriPolyline;
import com.bbn.openmap.dataAccess.shape.EsriPolylineList;
import com.bbn.openmap.dataAccess.shape.EsriPolylineM;
import com.bbn.openmap.dataAccess.shape.EsriPolylineMList;
import com.bbn.openmap.dataAccess.shape.EsriPolylineZ;
import com.bbn.openmap.dataAccess.shape.EsriPolylineZList;
import com.bbn.openmap.dataAccess.shape.EsriTextPoint;
import com.bbn.openmap.dataAccess.shape.ShapeConstants;
import com.bbn.openmap.dataAccess.shape.ShapeUtils;
import com.bbn.openmap.dataAccess.shape.input.LittleEndianInputStream;
import com.bbn.openmap.io.BinaryFile;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMColor;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicAdapter;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMList;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.GeoCoordTransformation;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.DataBounds;
import java.io.EOFException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EsriGraphicFactory
implements ShapeConstants {
    public static Logger logger = Logger.getLogger("com.bbn.openmap.dataAccess.shape.EsriGraphicFactory");
    protected int lineType = 1;
    protected GeoCoordTransformation dataTransformation = null;
    protected Class<?> precision = Float.TYPE;
    protected static boolean verbose = false;

    public EsriGraphicFactory() {
    }

    public EsriGraphicFactory(int lineType, GeoCoordTransformation dataTransformation) {
        this.lineType = lineType;
        this.dataTransformation = dataTransformation;
    }

    public OMGraphicList getEsriGraphics(BinaryFile shp, DrawingAttributes drawingAttributes, Object pointRepresentation, Projection mapProj, OMGraphicList list) throws IOException, FormatException {
        int offset;
        shp.seek(0L);
        verbose = logger.isLoggable(Level.FINER);
        Header header = new Header(shp, this.dataTransformation);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(header.toString());
        }
        if (list == null) {
            list = EsriGraphicFactory.createEsriGraphicList(header.shapeType);
        }
        if (header.fileLength == (offset = 100)) {
            if (verbose) {
                logger.finer("Header file length doesn't == 100: " + header.fileLength);
            }
            return list;
        }
        boolean ignoreFileLength = logger.isLoggable(Level.FINE);
        ReadByteTracker byteTracker = new ReadByteTracker();
        try {
            OMGraphic eg = this.makeEsriGraphicFromRecord(offset, shp, drawingAttributes, pointRepresentation, byteTracker);
            offset += byteTracker.currentCount + 8;
            while (offset != header.fileLength || ignoreFileLength) {
                this.projGraphicAndAdd(eg, list, mapProj);
                try {
                    eg = this.makeEsriGraphicFromRecord(offset, shp, drawingAttributes, pointRepresentation, byteTracker);
                }
                catch (EOFException eof) {
                    logger.fine("File length (" + header.fileLength + " bytes) is incorrect, file was read as much as possible (" + offset + " bytes).");
                    eg = null;
                    break;
                }
                offset += byteTracker.currentCount + 8;
            }
            if (eg != null) {
                this.projGraphicAndAdd(eg, list, mapProj);
            }
        }
        catch (FormatException fe) {
            fe.printStackTrace();
        }
        return list;
    }

    public OMGraphicList getEsriGraphics(LittleEndianInputStream iStream, DrawingAttributes drawingAttributes, Object pointRepresentation, Projection mapProj, OMGraphicList list) throws IOException, FormatException {
        int offset;
        Header header = new Header(iStream, this.dataTransformation);
        verbose = logger.isLoggable(Level.FINER);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(header.toString());
        }
        if (list == null) {
            list = EsriGraphicFactory.createEsriGraphicList(header.shapeType);
        }
        if (header.fileLength == (offset = 100)) {
            if (verbose) {
                logger.info("Header file length doesn't == 100: " + header.fileLength);
            }
            return list;
        }
        boolean ignoreFileLength = logger.isLoggable(Level.FINE);
        ReadByteTracker byteTracker = new ReadByteTracker();
        try {
            OMGraphic eg = this.makeEsriGraphicFromRecord(offset, iStream, drawingAttributes, pointRepresentation, byteTracker);
            offset += byteTracker.currentCount + 8;
            while (offset != header.fileLength || ignoreFileLength) {
                this.projGraphicAndAdd(eg, list, mapProj);
                try {
                    eg = this.makeEsriGraphicFromRecord(offset, iStream, drawingAttributes, pointRepresentation, byteTracker);
                }
                catch (EOFException eof) {
                    logger.fine("File length (" + header.fileLength + " bytes) is incorrect, file was read as much as possible (" + offset + " bytes).");
                    eg = null;
                    break;
                }
                offset += byteTracker.currentCount + 8;
            }
            if (eg != null) {
                this.projGraphicAndAdd(eg, list, mapProj);
            }
        }
        catch (FormatException fe) {
            fe.printStackTrace();
        }
        return list;
    }

    protected void projGraphicAndAdd(OMGraphic eg, OMGraphicList list, Projection mapProj) {
        if (eg != null) {
            if (mapProj != null) {
                eg.generate(mapProj);
            }
            list.add(eg);
        }
    }

    public OMGraphic makeEsriGraphicFromRecord(int byteOffset, BinaryFile shp, DrawingAttributes drawingAttributes, Object pointRepresentation, ReadByteTracker byteTracker) throws IOException, FormatException {
        shp.seek(byteOffset);
        shp.byteOrder(true);
        int recordNumber = shp.readInteger();
        int recordContentLength = shp.readInteger() * 2;
        byteTracker.reset(recordContentLength);
        OMGraphic omg = this.makeEsriGraphic(shp, drawingAttributes, pointRepresentation, byteTracker);
        if (omg != null) {
            omg.putAttribute("SHAPE_INDEX_ATTRIBUTE", new Integer(recordNumber - 1));
        }
        return omg;
    }

    public OMGraphic makeEsriGraphicFromRecord(int byteOffset, LittleEndianInputStream iStream, DrawingAttributes drawingAttributes, Object pointRepresentation, ReadByteTracker byteTracker) throws IOException, FormatException {
        int recordNumber = iStream.readInt();
        int recordContentLength = iStream.readInt() * 2;
        byteTracker.reset(recordContentLength);
        OMGraphic omg = this.makeEsriGraphic(iStream, drawingAttributes, pointRepresentation, byteTracker);
        if (omg != null) {
            omg.putAttribute("SHAPE_INDEX_ATTRIBUTE", new Integer(recordNumber - 1));
        }
        return omg;
    }

    protected OMGraphic makeEsriGraphic(BinaryFile shpFile, DrawingAttributes drawingAttributes, Object pointRepresentation, ReadByteTracker byteTracker) throws IOException, FormatException {
        EsriGraphic eg = null;
        shpFile.byteOrder(false);
        int shapeType = shpFile.readInteger();
        byteTracker.addRead(4);
        if (verbose) {
            logger.info("reading shape type: " + shapeType + ", " + ShapeUtils.getStringForType(shapeType));
        }
        switch (shapeType) {
            case 0: {
                break;
            }
            case 1: {
                eg = this.createPointGraphic(shpFile, pointRepresentation, drawingAttributes, byteTracker);
                break;
            }
            case 3: {
                eg = this.createPolylineGraphic(shpFile, drawingAttributes, byteTracker);
                break;
            }
            case 5: {
                eg = this.createPolygonGraphic(shpFile, drawingAttributes, byteTracker);
                break;
            }
            case 8: {
                eg = this.createMultiPointGraphic(shpFile, pointRepresentation, drawingAttributes, byteTracker);
                break;
            }
            case 11: {
                eg = this.createPointZGraphic(shpFile, pointRepresentation, drawingAttributes, byteTracker);
                break;
            }
            case 13: {
                eg = this.createPolylineZGraphic(shpFile, drawingAttributes, byteTracker);
                break;
            }
            case 15: {
                eg = this.createPolygonZGraphic(shpFile, drawingAttributes, byteTracker);
                break;
            }
            case 18: {
                eg = this.createMultiPointZGraphic(shpFile, pointRepresentation, drawingAttributes, byteTracker);
                break;
            }
            case 21: {
                eg = this.createPointMGraphic(shpFile, pointRepresentation, drawingAttributes, byteTracker);
                break;
            }
            case 23: {
                eg = this.createPolylineMGraphic(shpFile, drawingAttributes, byteTracker);
                break;
            }
            case 25: {
                eg = this.createPolygonMGraphic(shpFile, drawingAttributes, byteTracker);
                break;
            }
            case 28: {
                eg = this.createMultiPointMGraphic(shpFile, pointRepresentation, drawingAttributes, byteTracker);
                break;
            }
        }
        return (OMGraphic)((Object)eg);
    }

    protected OMGraphic makeEsriGraphic(LittleEndianInputStream iStream, DrawingAttributes drawingAttributes, Object pointRepresentation, ReadByteTracker byteTracker) throws IOException, FormatException {
        EsriGraphic eg = null;
        int shapeType = iStream.readLEInt();
        byteTracker.addRead(4);
        if (verbose) {
            logger.info("reading shape type: " + shapeType + ", " + ShapeUtils.getStringForType(shapeType));
        }
        switch (shapeType) {
            case 0: {
                break;
            }
            case 1: {
                eg = this.createPointGraphic(iStream, pointRepresentation, drawingAttributes, byteTracker);
                break;
            }
            case 3: {
                eg = this.createPolylineGraphic(iStream, drawingAttributes, byteTracker);
                break;
            }
            case 5: {
                eg = this.createPolygonGraphic(iStream, drawingAttributes, byteTracker);
                break;
            }
            case 8: {
                eg = this.createMultiPointGraphic(iStream, pointRepresentation, drawingAttributes, byteTracker);
                break;
            }
            case 11: {
                eg = this.createPointZGraphic(iStream, pointRepresentation, drawingAttributes, byteTracker);
                break;
            }
            case 13: {
                eg = this.createPolylineZGraphic(iStream, drawingAttributes, byteTracker);
                break;
            }
            case 15: {
                eg = this.createPolygonZGraphic(iStream, drawingAttributes, byteTracker);
                break;
            }
            case 18: {
                eg = this.createMultiPointZGraphic(iStream, pointRepresentation, drawingAttributes, byteTracker);
                break;
            }
            case 21: {
                eg = this.createPointMGraphic(iStream, pointRepresentation, drawingAttributes, byteTracker);
                break;
            }
            case 23: {
                eg = this.createPolylineMGraphic(iStream, drawingAttributes, byteTracker);
                break;
            }
            case 25: {
                eg = this.createPolygonMGraphic(iStream, drawingAttributes, byteTracker);
                break;
            }
            case 28: {
                eg = this.createMultiPointMGraphic(iStream, pointRepresentation, drawingAttributes, byteTracker);
                break;
            }
        }
        return (OMGraphic)((Object)eg);
    }

    protected EsriGraphic createPointGraphic(double x, double y, Object representation, DrawingAttributes drawingAttributes) {
        if (this.dataTransformation != null) {
            LatLonPoint llp = this.dataTransformation.inverse(x, y);
            if (verbose) {
                logger.info("point: " + x + ", " + y + " converted to " + llp);
            }
            x = llp.getX();
            y = llp.getY();
        } else if (verbose) {
            logger.info("point: " + x + ", " + y);
        }
        OMGraphicAdapter ret = null;
        if (representation == null) {
            ret = new EsriPoint((float)y, (float)x);
        } else if (representation instanceof ImageIcon) {
            ret = new EsriIconPoint((double)((float)y), (double)((float)x), (ImageIcon)representation);
        } else if (representation instanceof String) {
            ret = new EsriTextPoint((float)y, (float)x, (String)representation, 1);
        }
        if (drawingAttributes != null && ret != null) {
            drawingAttributes.setTo(ret);
        }
        return ret;
    }

    protected EsriGraphic createPointGraphic(BinaryFile shpFile, Object representation, DrawingAttributes drawingAttributes, ReadByteTracker byteTracker) throws IOException, FormatException {
        double x = shpFile.readDouble();
        double y = shpFile.readDouble();
        byteTracker.addRead(16);
        return this.createPointGraphic(x, y, representation, drawingAttributes);
    }

    protected EsriGraphic createPointGraphic(LittleEndianInputStream iStream, Object representation, DrawingAttributes drawingAttributes, ReadByteTracker byteTracker) throws IOException, FormatException {
        double x = iStream.readLEDouble();
        double y = iStream.readLEDouble();
        byteTracker.addRead(16);
        return this.createPointGraphic(x, y, representation, drawingAttributes);
    }

    protected EsriGraphic createMultiPointGraphic(BinaryFile shpFile, Object representation, DrawingAttributes drawingAttributes, ReadByteTracker byteTracker) throws IOException, FormatException {
        shpFile.skipBytes(32L);
        byteTracker.addRead(32);
        int numParts = shpFile.readInteger();
        EsriPointList multiPart = new EsriPointList();
        multiPart.setVague(true);
        for (int i = 0; i < numParts; ++i) {
            EsriGraphic part = this.createPointGraphic(shpFile, representation, drawingAttributes, byteTracker);
            if (part == null) continue;
            multiPart.add((OMGraphic)((Object)part));
        }
        return multiPart;
    }

    protected EsriGraphic createMultiPointGraphic(LittleEndianInputStream iStream, Object representation, DrawingAttributes drawingAttributes, ReadByteTracker byteTracker) throws IOException, FormatException {
        iStream.skipBytes(32);
        byteTracker.addRead(32);
        int numParts = iStream.readLEInt();
        EsriPointList multiPart = new EsriPointList();
        multiPart.setVague(true);
        for (int i = 0; i < numParts; ++i) {
            EsriGraphic part = this.createPointGraphic(iStream, representation, drawingAttributes, byteTracker);
            if (part == null) continue;
            multiPart.add((OMGraphic)((Object)part));
        }
        return multiPart;
    }

    protected EsriGraphic createPointZGraphic(BinaryFile shpFile, Object representation, DrawingAttributes drawingAttributes, ReadByteTracker byteTracker) throws IOException, FormatException {
        double x = shpFile.readDouble();
        double y = shpFile.readDouble();
        double z = shpFile.readDouble();
        double m = shpFile.readDouble();
        byteTracker.addRead(32);
        EsriGraphic ret = this.createPointGraphic(x, y, representation, drawingAttributes);
        ret.setType(11);
        ((OMGraphic)((Object)ret)).putAttribute("SMA", new Double(m));
        ((OMGraphic)((Object)ret)).putAttribute("SZA", new Double(z));
        return ret;
    }

    protected EsriGraphic createPointZGraphic(LittleEndianInputStream iStream, Object representation, DrawingAttributes drawingAttributes, ReadByteTracker byteTracker) throws IOException, FormatException {
        double x = iStream.readLEDouble();
        double y = iStream.readLEDouble();
        double z = iStream.readLEDouble();
        double m = iStream.readLEDouble();
        byteTracker.addRead(32);
        EsriGraphic ret = this.createPointGraphic(x, y, representation, drawingAttributes);
        ret.setType(11);
        ((OMGraphic)((Object)ret)).putAttribute("SMA", new Double(m));
        ((OMGraphic)((Object)ret)).putAttribute("SZA", new Double(z));
        return ret;
    }

    protected EsriGraphic createMultiPointZGraphic(BinaryFile shpFile, Object representation, DrawingAttributes drawingAttributes, ReadByteTracker byteTracker) throws IOException, FormatException {
        EsriGraphic multiPart = this.createMultiPointGraphic(shpFile, representation, drawingAttributes, byteTracker);
        if (multiPart instanceof EsriGraphicList) {
            ((EsriGraphicList)multiPart).setType(18);
            int numPoints = ((EsriGraphicList)multiPart).size();
            double minZ = shpFile.readDouble();
            double maxZ = shpFile.readDouble();
            double[] zs = new double[numPoints];
            for (int i = 0; i < numPoints; ++i) {
                zs[i] = shpFile.readDouble();
            }
            ((OMGraphic)((Object)multiPart)).putAttribute("MIN_Z", new Double(minZ));
            ((OMGraphic)((Object)multiPart)).putAttribute("MAX_Z", new Double(maxZ));
            ((OMGraphic)((Object)multiPart)).putAttribute("SZA", zs);
            byteTracker.addRead((2 + numPoints) * 8);
            if (byteTracker.numLeft() > 0) {
                double minM = shpFile.readDouble();
                double maxM = shpFile.readDouble();
                double[] ms = new double[numPoints];
                for (int i = 0; i < numPoints; ++i) {
                    ms[i] = shpFile.readDouble();
                }
                ((OMGraphic)((Object)multiPart)).putAttribute("MIN_SMA", new Double(minM));
                ((OMGraphic)((Object)multiPart)).putAttribute("MAX_SMA", new Double(maxM));
                ((OMGraphic)((Object)multiPart)).putAttribute("SMA", ms);
                byteTracker.addRead((2 + numPoints) * 8);
            }
        }
        return multiPart;
    }

    protected EsriGraphic createMultiPointZGraphic(LittleEndianInputStream iStream, Object representation, DrawingAttributes drawingAttributes, ReadByteTracker byteTracker) throws IOException, FormatException {
        EsriGraphic multiPart = this.createMultiPointGraphic(iStream, representation, drawingAttributes, byteTracker);
        if (multiPart instanceof EsriGraphicList) {
            ((EsriGraphicList)multiPart).setType(18);
            int numPoints = ((EsriGraphicList)multiPart).size();
            double minZ = iStream.readLEDouble();
            double maxZ = iStream.readLEDouble();
            double[] zs = new double[numPoints];
            for (int i = 0; i < numPoints; ++i) {
                zs[i] = iStream.readLEDouble();
            }
            ((OMGraphic)((Object)multiPart)).putAttribute("MIN_Z", new Double(minZ));
            ((OMGraphic)((Object)multiPart)).putAttribute("MAX_Z", new Double(maxZ));
            ((OMGraphic)((Object)multiPart)).putAttribute("SZA", zs);
            byteTracker.addRead((2 + numPoints) * 8);
            if (byteTracker.numLeft() > 0) {
                double minM = iStream.readLEDouble();
                double maxM = iStream.readLEDouble();
                double[] ms = new double[numPoints];
                for (int i = 0; i < numPoints; ++i) {
                    ms[i] = iStream.readLEDouble();
                }
                ((OMGraphic)((Object)multiPart)).putAttribute("MIN_SMA", new Double(minM));
                ((OMGraphic)((Object)multiPart)).putAttribute("MAX_SMA", new Double(maxM));
                ((OMGraphic)((Object)multiPart)).putAttribute("SMA", ms);
                byteTracker.addRead((2 + numPoints) * 8);
            }
        }
        return multiPart;
    }

    protected EsriGraphic createPointMGraphic(BinaryFile shpFile, Object representation, DrawingAttributes drawingAttributes, ReadByteTracker byteTracker) throws IOException, FormatException {
        double x = shpFile.readDouble();
        double y = shpFile.readDouble();
        double m = shpFile.readDouble();
        byteTracker.addRead(24);
        EsriGraphic ret = this.createPointGraphic(x, y, representation, drawingAttributes);
        ret.setType(21);
        ((OMGraphic)((Object)ret)).putAttribute("SMA", new Double(m));
        return ret;
    }

    protected EsriGraphic createPointMGraphic(LittleEndianInputStream iStream, Object representation, DrawingAttributes drawingAttributes, ReadByteTracker byteTracker) throws IOException, FormatException {
        double x = iStream.readLEDouble();
        double y = iStream.readLEDouble();
        double m = iStream.readLEDouble();
        byteTracker.addRead(24);
        EsriGraphic ret = this.createPointGraphic(x, y, representation, drawingAttributes);
        ret.setType(21);
        ((OMGraphic)((Object)ret)).putAttribute("SMA", new Double(m));
        return ret;
    }

    protected EsriGraphic createMultiPointMGraphic(BinaryFile shpFile, Object representation, DrawingAttributes drawingAttributes, ReadByteTracker byteTracker) throws IOException, FormatException {
        EsriGraphic multiPart = this.createMultiPointGraphic(shpFile, representation, drawingAttributes, byteTracker);
        if (multiPart instanceof EsriGraphicList) {
            ((EsriGraphicList)multiPart).setType(28);
            int numPoints = ((EsriGraphicList)multiPart).size();
            if (byteTracker.numLeft() > 0) {
                double minM = shpFile.readDouble();
                double maxM = shpFile.readDouble();
                double[] ms = new double[numPoints];
                for (int i = 0; i < numPoints; ++i) {
                    ms[i] = shpFile.readDouble();
                }
                ((OMGraphic)((Object)multiPart)).putAttribute("MIN_SMA", new Double(minM));
                ((OMGraphic)((Object)multiPart)).putAttribute("MAX_SMA", new Double(maxM));
                ((OMGraphic)((Object)multiPart)).putAttribute("SMA", ms);
                byteTracker.addRead((2 + numPoints) * 8);
            }
        }
        return multiPart;
    }

    protected EsriGraphic createMultiPointMGraphic(LittleEndianInputStream iStream, Object representation, DrawingAttributes drawingAttributes, ReadByteTracker byteTracker) throws IOException, FormatException {
        EsriGraphic multiPart = this.createMultiPointGraphic(iStream, representation, drawingAttributes, byteTracker);
        if (multiPart instanceof EsriGraphicList) {
            ((EsriGraphicList)multiPart).setType(28);
            int numPoints = ((EsriGraphicList)multiPart).size();
            if (byteTracker.numLeft() > 0) {
                double minM = iStream.readLEDouble();
                double maxM = iStream.readLEDouble();
                double[] ms = new double[numPoints];
                for (int i = 0; i < numPoints; ++i) {
                    ms[i] = iStream.readLEDouble();
                }
                ((OMGraphic)((Object)multiPart)).putAttribute("MIN_SMA", new Double(minM));
                ((OMGraphic)((Object)multiPart)).putAttribute("MAX_SMA", new Double(maxM));
                ((OMGraphic)((Object)multiPart)).putAttribute("SMA", ms);
                byteTracker.addRead((2 + numPoints) * 8);
            }
        }
        return multiPart;
    }

    protected EsriGraphic createPolygonGraphic(BinaryFile shpFile, DrawingAttributes drawingAttributes, ReadByteTracker byteTracker) throws IOException, FormatException {
        return this.createPolyGraphic(shpFile, 5, drawingAttributes, byteTracker);
    }

    protected EsriGraphic createPolygonGraphic(LittleEndianInputStream iStream, DrawingAttributes drawingAttributes, ReadByteTracker byteTracker) throws IOException, FormatException {
        return this.createPolyGraphic(iStream, 5, drawingAttributes, byteTracker);
    }

    protected EsriGraphic createPolylineGraphic(BinaryFile shpFile, DrawingAttributes drawingAttributes, ReadByteTracker byteTracker) throws IOException, FormatException {
        return this.createPolyGraphic(shpFile, 3, drawingAttributes, byteTracker);
    }

    protected EsriGraphic createPolylineGraphic(LittleEndianInputStream iStream, DrawingAttributes drawingAttributes, ReadByteTracker byteTracker) throws IOException, FormatException {
        return this.createPolyGraphic(iStream, 3, drawingAttributes, byteTracker);
    }

    protected EsriGraphic createPolyGraphic(BinaryFile shpFile, int shapeType, DrawingAttributes drawingAttributes, ReadByteTracker byteTracker) throws IOException, FormatException {
        EsriGraphic ret = null;
        shpFile.skipBytes(32L);
        byteTracker.addRead(32);
        int numParts = shpFile.readInteger();
        int numPoints = shpFile.readInteger();
        byteTracker.addRead(8);
        if (numParts > 0) {
            ret = this.getPolys(shpFile, numParts, numPoints, shapeType, drawingAttributes, byteTracker);
        }
        return ret;
    }

    protected EsriGraphic createPolyGraphic(LittleEndianInputStream iStream, int shapeType, DrawingAttributes drawingAttributes, ReadByteTracker byteTracker) throws IOException, FormatException {
        EsriGraphic ret = null;
        iStream.skipBytes(32);
        byteTracker.addRead(32);
        int numParts = iStream.readLEInt();
        int numPoints = iStream.readLEInt();
        byteTracker.addRead(8);
        if (numParts > 0) {
            ret = this.getPolys(iStream, numParts, numPoints, shapeType, drawingAttributes, byteTracker);
        }
        return ret;
    }

    protected EsriGraphic createPolygonZGraphic(BinaryFile shpFile, DrawingAttributes drawingAttributes, ReadByteTracker byteTracker) throws IOException, FormatException {
        return this.createPolyZGraphic(shpFile, 15, drawingAttributes, byteTracker);
    }

    protected EsriGraphic createPolygonZGraphic(LittleEndianInputStream iStream, DrawingAttributes drawingAttributes, ReadByteTracker byteTracker) throws IOException, FormatException {
        return this.createPolyZGraphic(iStream, 15, drawingAttributes, byteTracker);
    }

    protected EsriGraphic createPolylineZGraphic(BinaryFile shpFile, DrawingAttributes drawingAttributes, ReadByteTracker byteTracker) throws IOException, FormatException {
        return this.createPolyZGraphic(shpFile, 13, drawingAttributes, byteTracker);
    }

    protected EsriGraphic createPolylineZGraphic(LittleEndianInputStream iStream, DrawingAttributes drawingAttributes, ReadByteTracker byteTracker) throws IOException, FormatException {
        return this.createPolyZGraphic(iStream, 13, drawingAttributes, byteTracker);
    }

    protected EsriGraphic createPolyZGraphic(BinaryFile shpFile, int shapeType, DrawingAttributes drawingAttributes, ReadByteTracker byteTracker) throws IOException, FormatException {
        EsriGraphic ret = null;
        shpFile.skipBytes(32L);
        byteTracker.addRead(32);
        int numParts = shpFile.readInteger();
        int numPoints = shpFile.readInteger();
        byteTracker.addRead(8);
        if (numParts > 0) {
            ret = this.getPolys(shpFile, numParts, numPoints, shapeType, drawingAttributes, byteTracker);
        }
        double minZ = shpFile.readDouble();
        double maxZ = shpFile.readDouble();
        double[] zs = new double[numPoints];
        for (int i = 0; i < numPoints; ++i) {
            zs[i] = shpFile.readDouble();
        }
        OMGraphic omg = (OMGraphic)((Object)ret);
        if (omg != null) {
            omg.putAttribute("MIN_Z", new Double(minZ));
            omg.putAttribute("MAX_Z", new Double(maxZ));
            omg.putAttribute("SZA", zs);
        }
        byteTracker.addRead((2 + numPoints) * 8);
        if (byteTracker.numLeft() > 0) {
            double minM = shpFile.readDouble();
            double maxM = shpFile.readDouble();
            double[] ms = new double[numPoints];
            for (int i = 0; i < numPoints; ++i) {
                ms[i] = shpFile.readDouble();
            }
            if (omg != null) {
                omg.putAttribute("MIN_SMA", new Double(minM));
                omg.putAttribute("MAX_SMA", new Double(maxM));
                omg.putAttribute("SMA", ms);
                byteTracker.addRead((2 + numPoints) * 8);
            }
        }
        return ret;
    }

    protected EsriGraphic createPolyZGraphic(LittleEndianInputStream iStream, int shapeType, DrawingAttributes drawingAttributes, ReadByteTracker byteTracker) throws IOException, FormatException {
        EsriGraphic ret = null;
        iStream.skipBytes(32);
        byteTracker.addRead(32);
        int numParts = iStream.readLEInt();
        int numPoints = iStream.readLEInt();
        byteTracker.addRead(8);
        if (numParts > 0) {
            ret = this.getPolys(iStream, numParts, numPoints, shapeType, drawingAttributes, byteTracker);
        }
        double minZ = iStream.readLEDouble();
        double maxZ = iStream.readLEDouble();
        double[] zs = new double[numPoints];
        for (int i = 0; i < numPoints; ++i) {
            zs[i] = iStream.readLEDouble();
        }
        OMGraphic omg = (OMGraphic)((Object)ret);
        if (omg != null) {
            omg.putAttribute("MIN_Z", new Double(minZ));
            omg.putAttribute("MAX_Z", new Double(maxZ));
            omg.putAttribute("SZA", zs);
        }
        byteTracker.addRead((2 + numPoints) * 8);
        if (byteTracker.numLeft() > 0) {
            double minM = iStream.readLEDouble();
            double maxM = iStream.readLEDouble();
            double[] ms = new double[numPoints];
            for (int i = 0; i < numPoints; ++i) {
                ms[i] = iStream.readLEDouble();
            }
            if (omg != null) {
                omg.putAttribute("MIN_SMA", new Double(minM));
                omg.putAttribute("MAX_SMA", new Double(maxM));
                omg.putAttribute("SMA", ms);
            }
            byteTracker.addRead((2 + numPoints) * 8);
        }
        return ret;
    }

    protected EsriGraphic createPolygonMGraphic(BinaryFile shpFile, DrawingAttributes drawingAttributes, ReadByteTracker byteTracker) throws IOException, FormatException {
        return this.createPolyZGraphic(shpFile, 25, drawingAttributes, byteTracker);
    }

    protected EsriGraphic createPolygonMGraphic(LittleEndianInputStream iStream, DrawingAttributes drawingAttributes, ReadByteTracker byteTracker) throws IOException, FormatException {
        return this.createPolyZGraphic(iStream, 25, drawingAttributes, byteTracker);
    }

    protected EsriGraphic createPolylineMGraphic(BinaryFile shpFile, DrawingAttributes drawingAttributes, ReadByteTracker byteTracker) throws IOException, FormatException {
        return this.createPolyZGraphic(shpFile, 23, drawingAttributes, byteTracker);
    }

    protected EsriGraphic createPolylineMGraphic(LittleEndianInputStream iStream, DrawingAttributes drawingAttributes, ReadByteTracker byteTracker) throws IOException, FormatException {
        return this.createPolyZGraphic(iStream, 23, drawingAttributes, byteTracker);
    }

    protected EsriGraphic createPolyMGraphic(BinaryFile shpFile, int shapeType, DrawingAttributes drawingAttributes, ReadByteTracker byteTracker) throws IOException, FormatException {
        EsriGraphic ret = null;
        shpFile.skipBytes(32L);
        byteTracker.addRead(32);
        int numParts = shpFile.readInteger();
        int numPoints = shpFile.readInteger();
        byteTracker.addRead(8);
        if (numParts > 0) {
            ret = this.getPolys(shpFile, numParts, numPoints, shapeType, drawingAttributes, byteTracker);
            if (byteTracker.numLeft() > 0) {
                double minM = shpFile.readDouble();
                double maxM = shpFile.readDouble();
                double[] ms = new double[numPoints];
                for (int i = 0; i < numPoints; ++i) {
                    ms[i] = shpFile.readDouble();
                }
                OMGraphic omg = (OMGraphic)((Object)ret);
                omg.putAttribute("MIN_SMA", new Double(minM));
                omg.putAttribute("MAX_SMA", new Double(maxM));
                omg.putAttribute("SMA", ms);
                byteTracker.addRead((2 + numPoints) * 8);
            }
        }
        return ret;
    }

    protected EsriGraphic createPolyMGraphic(LittleEndianInputStream iStream, int shapeType, DrawingAttributes drawingAttributes, ReadByteTracker byteTracker) throws IOException, FormatException {
        EsriGraphic ret = null;
        iStream.skipBytes(32);
        byteTracker.addRead(32);
        int numParts = iStream.readLEInt();
        int numPoints = iStream.readLEInt();
        byteTracker.addRead(8);
        if (numParts > 0) {
            ret = this.getPolys(iStream, numParts, numPoints, shapeType, drawingAttributes, byteTracker);
            if (byteTracker.numLeft() > 0) {
                double minM = iStream.readLEDouble();
                double maxM = iStream.readLEDouble();
                double[] ms = new double[numPoints];
                for (int i = 0; i < numPoints; ++i) {
                    ms[i] = iStream.readLEDouble();
                }
                OMGraphic omg = (OMGraphic)((Object)ret);
                omg.putAttribute("MIN_SMA", new Double(minM));
                omg.putAttribute("MAX_SMA", new Double(maxM));
                omg.putAttribute("SMA", ms);
                byteTracker.addRead((2 + numPoints) * 8);
            }
        }
        return ret;
    }

    protected EsriGraphic getPolys(BinaryFile shpFile, int numParts, int numPoints, int shapeType, DrawingAttributes drawingAttributes, ReadByteTracker byteTracker) throws IOException, FormatException {
        double[] coords;
        EsriGraphic ret = null;
        if (verbose) {
            logger.info("creating polygon for entry, parts(" + numParts + ") numPoints(" + numPoints + ")");
        }
        if (numParts > 1 && (ret = EsriGraphicFactory.createEsriGraphicList(shapeType)) != null) {
            ((OMList)((Object)ret)).setVague(true);
        }
        int[] parts = new int[numParts];
        for (int i = 0; i < numParts; ++i) {
            parts[i] = shpFile.readInteger();
        }
        byteTracker.addRead(numParts * 4);
        int origin = parts[0];
        int length = 0;
        for (int i = 1; i < numParts; ++i) {
            int nextOrigin = parts[i];
            length = nextOrigin - origin;
            coords = EsriGraphicFactory.getCoords(shpFile, length, EsriGraphicFactory.isPolygon(shapeType), this.dataTransformation, byteTracker);
            if (verbose) {
                logger.info("creating " + ShapeUtils.getStringForType(shapeType) + "(" + i + ") with coords[" + this.getCoordString(coords) + "]");
            }
            EsriGraphic omp = EsriGraphicFactory.createEsriPoly(shapeType, coords, this.lineType, drawingAttributes);
            if (ret != null) {
                ((EsriGraphicList)ret).add((OMGraphic)((Object)omp));
            }
            origin = nextOrigin;
        }
        length = numPoints - origin;
        coords = EsriGraphicFactory.getCoords(shpFile, length, EsriGraphicFactory.isPolygon(shapeType), this.dataTransformation, byteTracker);
        if (verbose) {
            logger.info("creating " + ShapeUtils.getStringForType(shapeType) + " with coords[" + this.getCoordString(coords) + "]");
        }
        EsriGraphic omp = EsriGraphicFactory.createEsriPoly(shapeType, coords, this.lineType, drawingAttributes);
        if (ret != null) {
            ((EsriGraphicList)ret).add((OMGraphic)((Object)omp));
        } else {
            ret = omp;
        }
        return ret;
    }

    protected String getCoordString(double[] coords) {
        StringBuffer coordString = new StringBuffer();
        for (int j = 0; j < coords.length; j += 2) {
            coordString.append(j > 0 ? ":" : "").append(coords[j]).append(",").append(coords[j + 1]);
        }
        return coordString.toString();
    }

    protected EsriGraphic getPolys(LittleEndianInputStream iStream, int numParts, int numPoints, int shapeType, DrawingAttributes drawingAttributes, ReadByteTracker byteTracker) throws IOException, FormatException {
        double[] coords;
        EsriGraphic ret = null;
        if (numParts > 1 && (ret = EsriGraphicFactory.createEsriGraphicList(shapeType)) != null) {
            ((OMList)((Object)ret)).setVague(true);
        }
        int[] parts = new int[numParts];
        for (int i = 0; i < numParts; ++i) {
            parts[i] = iStream.readLEInt();
        }
        byteTracker.addRead(numParts * 4);
        int origin = parts[0];
        int length = 0;
        for (int i = 1; i < numParts; ++i) {
            int nextOrigin = parts[i];
            length = nextOrigin - origin;
            coords = EsriGraphicFactory.getCoords(iStream, length, EsriGraphicFactory.isPolygon(shapeType), this.dataTransformation, byteTracker);
            if (verbose) {
                logger.info("creating " + ShapeUtils.getStringForType(shapeType) + "(" + i + ") with coords[" + this.getCoordString(coords) + "]");
            }
            EsriGraphic omp = EsriGraphicFactory.createEsriPoly(shapeType, coords, this.lineType, drawingAttributes);
            if (ret != null) {
                ((EsriGraphicList)ret).add((OMGraphic)((Object)omp));
            }
            origin = nextOrigin;
        }
        length = numPoints - origin;
        coords = EsriGraphicFactory.getCoords(iStream, length, EsriGraphicFactory.isPolygon(shapeType), this.dataTransformation, byteTracker);
        if (verbose) {
            logger.info("creating " + ShapeUtils.getStringForType(shapeType) + " with coords[" + this.getCoordString(coords) + "]");
        }
        EsriGraphic omp = EsriGraphicFactory.createEsriPoly(shapeType, coords, this.lineType, drawingAttributes);
        if (ret != null) {
            ((EsriGraphicList)ret).add((OMGraphic)((Object)omp));
        } else {
            ret = omp;
        }
        return ret;
    }

    protected static float[] getFloatCoords(BinaryFile shpFile, int length, boolean isPolygon, GeoCoordTransformation dataTrans, ReadByteTracker bitTracker) throws IOException, FormatException {
        float[] coords = new float[isPolygon ? length * 2 + 2 : length * 2];
        int j = 0;
        LatLonPoint llp = null;
        if (dataTrans != null) {
            llp = new LatLonPoint.Double();
        }
        for (j = 0; j < length; ++j) {
            double x = shpFile.readDouble();
            double y = shpFile.readDouble();
            bitTracker.addRead(16);
            if (dataTrans != null) {
                llp = dataTrans.inverse(x, y, llp);
                x = llp.getRadLon();
                y = llp.getRadLat();
            } else {
                x = ProjMath.degToRad(x);
                y = ProjMath.degToRad(y);
            }
            coords[j * 2] = (float)y;
            coords[j * 2 + 1] = (float)x;
        }
        if (isPolygon) {
            coords[j * 2] = coords[0];
            coords[j * 2 + 1] = coords[1];
        }
        return coords;
    }

    protected static float[] getFloatCoords(LittleEndianInputStream iStream, int length, boolean isPolygon, GeoCoordTransformation dataTrans, ReadByteTracker bitTracker) throws IOException, FormatException {
        float[] coords = new float[isPolygon ? length * 2 + 2 : length * 2];
        int j = 0;
        LatLonPoint llp = null;
        if (dataTrans != null) {
            llp = new LatLonPoint.Double();
        }
        for (j = 0; j < length; ++j) {
            double x = iStream.readLEDouble();
            double y = iStream.readLEDouble();
            bitTracker.addRead(16);
            if (dataTrans != null) {
                llp = dataTrans.inverse(x, y, llp);
                x = llp.getRadLon();
                y = llp.getRadLat();
            } else {
                x = ProjMath.degToRad(x);
                y = ProjMath.degToRad(y);
            }
            coords[j * 2] = (float)y;
            coords[j * 2 + 1] = (float)x;
        }
        if (isPolygon) {
            coords[j * 2] = coords[0];
            coords[j * 2 + 1] = coords[1];
        }
        return coords;
    }

    protected static double[] getCoords(BinaryFile shpFile, int length, boolean isPolygon, GeoCoordTransformation dataTrans, ReadByteTracker bitTracker) throws IOException, FormatException {
        double[] coords = new double[isPolygon ? length * 2 + 2 : length * 2];
        int j = 0;
        LatLonPoint llp = null;
        if (dataTrans != null) {
            llp = new LatLonPoint.Double();
        }
        for (j = 0; j < length; ++j) {
            double x = shpFile.readDouble();
            double y = shpFile.readDouble();
            bitTracker.addRead(16);
            if (dataTrans != null) {
                llp = dataTrans.inverse(x, y, llp);
                x = llp.getRadLon();
                y = llp.getRadLat();
            } else {
                x = ProjMath.degToRad(x);
                y = ProjMath.degToRad(y);
            }
            coords[j * 2] = y;
            coords[j * 2 + 1] = x;
        }
        if (isPolygon) {
            coords[j * 2] = coords[0];
            coords[j * 2 + 1] = coords[1];
        }
        return coords;
    }

    protected static double[] getCoords(LittleEndianInputStream iStream, int length, boolean isPolygon, GeoCoordTransformation dataTrans, ReadByteTracker bitTracker) throws IOException, FormatException {
        double[] coords = new double[isPolygon ? length * 2 + 2 : length * 2];
        int j = 0;
        LatLonPoint llp = null;
        if (dataTrans != null) {
            llp = new LatLonPoint.Double();
        }
        for (j = 0; j < length; ++j) {
            double x = iStream.readLEDouble();
            double y = iStream.readLEDouble();
            bitTracker.addRead(16);
            if (dataTrans != null) {
                llp = dataTrans.inverse(x, y, llp);
                x = llp.getRadLon();
                y = llp.getRadLat();
            } else {
                x = ProjMath.degToRad(x);
                y = ProjMath.degToRad(y);
            }
            coords[j * 2] = y;
            coords[j * 2 + 1] = x;
        }
        if (isPolygon) {
            coords[j * 2] = coords[0];
            coords[j * 2 + 1] = coords[1];
        }
        return coords;
    }

    public static boolean isPolygon(int shapeType) {
        return shapeType == 5 || shapeType == 15 || shapeType == 25;
    }

    public static EsriGraphic createEsriPoly(int shapeType, double[] coords, int lineType, DrawingAttributes da) {
        if (da == null) {
            da = DrawingAttributes.DEFAULT;
        }
        OMPoly ret = null;
        switch (shapeType) {
            case 5: {
                ret = new EsriPolygon(coords, 1, lineType);
                da.setTo(ret);
                break;
            }
            case 3: {
                ret = new EsriPolyline(coords, 1, lineType);
                da.setTo(ret);
                ((OMGraphic)ret).setFillPaint(OMColor.clear);
                break;
            }
            case 25: {
                ret = new EsriPolygonM(coords, 1, lineType);
                da.setTo(ret);
                break;
            }
            case 15: {
                ret = new EsriPolygonZ(coords, 1, lineType);
                da.setTo(ret);
                break;
            }
            case 23: {
                ret = new EsriPolylineM(coords, 1, lineType);
                da.setTo(ret);
                ((OMGraphic)ret).setFillPaint(OMColor.clear);
                break;
            }
            case 13: {
                ret = new EsriPolylineZ(coords, 1, lineType);
                da.setTo(ret);
                ((OMGraphic)ret).setFillPaint(OMColor.clear);
            }
        }
        return ret;
    }

    public static EsriGraphicList createEsriGraphicList(int shapeType) {
        EsriGraphicList ret = null;
        switch (shapeType) {
            case 0: {
                break;
            }
            case 1: 
            case 8: 
            case 11: 
            case 18: 
            case 21: 
            case 28: {
                ret = new EsriPointList();
                ret.setType(shapeType);
                break;
            }
            case 5: {
                ret = new EsriPolygonList();
                break;
            }
            case 3: {
                ret = new EsriPolylineList();
                break;
            }
            case 25: {
                ret = new EsriPolygonMList();
                break;
            }
            case 15: {
                ret = new EsriPolygonZList();
                break;
            }
            case 23: {
                ret = new EsriPolylineMList();
                break;
            }
            case 13: {
                ret = new EsriPolylineZList();
            }
        }
        return ret;
    }

    public GeoCoordTransformation getDataCoordTransformation() {
        return this.dataTransformation;
    }

    public void setDataCoordTransformation(GeoCoordTransformation dataTrans) {
        this.dataTransformation = dataTrans;
    }

    public int getLineType() {
        return this.lineType;
    }

    public void setLineType(int lineType) {
        this.lineType = lineType;
    }

    public Class<?> getPrecision() {
        return this.precision;
    }

    public void setPrecision(Class<?> precision) {
        this.precision = precision;
    }

    public static class Header {
        public int fileCode;
        public int fileLength;
        public int version;
        public int shapeType;
        public double xMin;
        public double yMin;
        public double xMax;
        public double yMax;
        public double zMin;
        public double zMax;
        public double mMin;
        public double mMax;

        public Header(BinaryFile shp) throws IOException, FormatException {
            this(shp, null);
        }

        public Header(BinaryFile shp, GeoCoordTransformation dataTransformation) throws IOException, FormatException {
            shp.byteOrder(true);
            shp.seek(0L);
            this.fileCode = shp.readInteger();
            shp.skipBytes(20L);
            this.fileLength = shp.readInteger() * 2;
            shp.byteOrder(false);
            this.version = shp.readInteger();
            this.shapeType = shp.readInteger();
            this.xMin = shp.readDouble();
            this.yMin = shp.readDouble();
            this.xMax = shp.readDouble();
            this.yMax = shp.readDouble();
            this.zMin = shp.readDouble();
            this.zMax = shp.readDouble();
            this.mMin = shp.readDouble();
            this.mMax = shp.readDouble();
            if (dataTransformation != null) {
                LatLonPoint llpmin = dataTransformation.inverse(this.xMin, this.yMin);
                this.xMin = llpmin.getLongitude();
                this.yMin = llpmin.getLatitude();
                LatLonPoint llpmax = dataTransformation.inverse(this.xMax, this.yMax);
                this.xMax = llpmax.getLongitude();
                this.yMax = llpmax.getLatitude();
            }
        }

        public Header(LittleEndianInputStream iStream) throws IOException {
            this(iStream, null);
        }

        public Header(LittleEndianInputStream iStream, GeoCoordTransformation dataTransformation) throws IOException {
            this.fileCode = iStream.readInt();
            iStream.skipBytes(20);
            this.fileLength = iStream.readInt() * 2;
            this.version = iStream.readLEInt();
            this.shapeType = iStream.readLEInt();
            this.xMin = iStream.readLEDouble();
            this.yMin = iStream.readLEDouble();
            this.xMax = iStream.readLEDouble();
            this.yMax = iStream.readLEDouble();
            this.zMin = iStream.readLEDouble();
            this.zMax = iStream.readLEDouble();
            this.mMin = iStream.readLEDouble();
            this.mMax = iStream.readLEDouble();
            if (dataTransformation != null) {
                LatLonPoint llpmin = dataTransformation.inverse(this.xMin, this.yMin);
                this.xMin = llpmin.getLongitude();
                this.yMin = llpmin.getLatitude();
                LatLonPoint llpmax = dataTransformation.inverse(this.xMax, this.yMax);
                this.xMax = llpmax.getLongitude();
                this.yMax = llpmax.getLatitude();
            }
        }

        public DataBounds getDataBounds() {
            return new DataBounds(this.xMin, this.yMin, this.xMax, this.yMax);
        }

        public String toString() {
            return "header[fc=" + this.fileCode + ",len=" + this.fileLength + ",ver=" + this.version + ",type=" + this.shapeType + "]";
        }
    }

    public static class ReadByteTracker {
        int totalCount;
        int currentCount;

        public ReadByteTracker() {
        }

        public ReadByteTracker(int tc) {
            this.totalCount = tc;
        }

        public int numLeft() {
            return this.totalCount - this.currentCount;
        }

        public int addRead(int num) {
            this.currentCount += num;
            return this.currentCount;
        }

        public void reset(int newTotal) {
            this.totalCount = newTotal;
            this.currentCount = 0;
        }

        public String toString() {
            return "ReadByteTracker has noted " + this.currentCount + " of " + this.totalCount + " bytes read";
        }
    }
}

