/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.mapTile;

import com.bbn.openmap.dataAccess.mapTile.MapTileCoordinateTransform;
import com.bbn.openmap.dataAccess.mapTile.SimpleEmptyTileHandler;
import com.bbn.openmap.dataAccess.shape.ShapeGeoIndex;
import com.bbn.openmap.geo.GeoPoint;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMRect;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.PropUtils;
import java.awt.Graphics;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Properties;

public class ShpFileEmptyTileHandler
extends SimpleEmptyTileHandler {
    public static final String LAND_ATTRIBUTES_PROPERTY = "land";
    public static final String SHP_FILE_PROPERTY = "shpFile";
    protected ShapeGeoIndex geoIndex;
    protected DrawingAttributes landAttributes = DrawingAttributes.getDefaultClone();

    public BufferedImage getImageForEmptyTile(String imagePath, int x, int y, int zoomLevel, MapTileCoordinateTransform mtcTransform, Projection proj) {
        Point2D.Double pnt = new Point2D.Double(x, y);
        Point2D tileUL = mtcTransform.tileUVToLatLon(pnt, zoomLevel);
        OMRect rect = new OMRect(0, 0, 256, 256);
        if (zoomLevel < this.noCoverageZoom) {
            if (this.isOverLand(tileUL.getY(), tileUL.getX())) {
                this.landAttributes.setTo(rect);
            } else {
                this.backgroundAtts.setTo(rect);
            }
        } else {
            if (this.noCoverageAtts == null) {
                return null;
            }
            this.noCoverageAtts.setTo(rect);
        }
        rect.generate(proj);
        BufferedImage bi = new BufferedImage(256, 256, 2);
        Graphics g = bi.getGraphics();
        rect.render(g);
        g.dispose();
        return bi;
    }

    protected boolean isOverLand(double lat, double lon) {
        if (this.geoIndex == null) {
            return false;
        }
        GeoPoint.Impl geoPoint = new GeoPoint.Impl(lat, lon);
        Iterator iterator = this.geoIndex.getIntersections(geoPoint);
        return iterator.hasNext();
    }

    public void setGeoIndex(String fileName) {
        if (fileName != null) {
            try {
                URL shapeURL = PropUtils.getResourceOrFileOrURL(fileName);
                this.geoIndex = new ShapeGeoIndex.Builder(shapeURL).create();
                return;
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                logger.info("can't find the shape file");
            }
        }
        this.geoIndex = null;
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        String shapeFileName = props.getProperty(prefix + SHP_FILE_PROPERTY);
        if (shapeFileName != null) {
            this.setGeoIndex(shapeFileName);
        }
        this.landAttributes.setProperties(prefix + LAND_ATTRIBUTES_PROPERTY, props);
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        this.landAttributes.getProperties(props);
        return props;
    }

    public ShapeGeoIndex getGeoIndex() {
        return this.geoIndex;
    }

    public void setGeoIndex(ShapeGeoIndex geoIndex) {
        this.geoIndex = geoIndex;
    }

    public DrawingAttributes getLandAttributes() {
        return this.landAttributes;
    }

    public void setLandAttributes(DrawingAttributes landAttributes) {
        this.landAttributes = landAttributes;
    }
}

