/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.mapTile;

import com.bbn.openmap.dataAccess.mapTile.OSMMapTileCoordinateTransform;
import com.bbn.openmap.dataAccess.mapTile.ZoomLevelInfo;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.util.FileUtils;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KMLTileGridMaker {
    protected String docTitle;
    protected int level;
    protected List<Tile> tiles;
    protected DrawingAttributes drawingAttributes = DrawingAttributes.getDefaultClone();
    String styleString = "tileborderstyle";

    protected KMLTileGridMaker(Builder builder) {
        this.level = builder.zoomLevel;
        this.tiles = this.makeTiles(this.level);
        this.docTitle = builder.docTitle;
        this.drawingAttributes.setLinePaint(builder.lineColor);
        this.drawingAttributes.setFillPaint(builder.fillColor);
        this.drawingAttributes.setSelectPaint(builder.labelColor);
    }

    protected List<Tile> makeTiles(int level) {
        ArrayList<Tile> ret = new ArrayList<Tile>();
        ZoomLevelInfo zli = new ZoomLevelInfo();
        zli.setZoomLevel(level);
        int edgeTileCount = zli.getEdgeTileCount();
        OSMMapTileCoordinateTransform transform = new OSMMapTileCoordinateTransform();
        for (int x = 0; x < edgeTileCount; ++x) {
            for (int y = 0; y < edgeTileCount; ++y) {
                Point2D ulllp = transform.tileUVToLatLon(new Point2D.Double(x, y), level);
                Point2D lrllp = transform.tileUVToLatLon(new Point2D.Double(x + 1, y + 1), level);
                ret.add(new Tile(x, y, ulllp, lrllp));
            }
        }
        return ret;
    }

    protected void writeDoc(OutputStream output) throws ParserConfigurationException, TransformerException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element kmlElement = this.appendChild(document, document, this.createKMLElement(document));
        Element docElement = this.appendChild(document, kmlElement, "Document", null);
        this.appendChild(document, docElement, this.createStyle(document));
        this.appendChild(document, docElement, this.createTiles(document));
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(output);
        transformer.transform(source, result);
    }

    protected Element createKMLElement(Document doc) {
        Element rootElement = doc.createElement("kml");
        rootElement.setAttribute("xmlns", "http://www.opengis.net/kml/2.2");
        rootElement.setAttribute("xmlns:gx", "http://www.google.com/kml/ext/2.2");
        rootElement.setAttribute("xmlns:kml", "http://www.opengis.net/kml/2.2");
        rootElement.setAttribute("xmlns:atom", "http://www.w3.org/2005/Atom");
        return rootElement;
    }

    protected Element createTiles(Document doc) {
        Element folderElement = doc.createElement("Folder");
        this.appendChild(doc, folderElement, "name", "Tile Layout for Zoom Level " + this.level);
        this.appendChild(doc, folderElement, "open", "1");
        List<Tile> tiles = this.makeTiles(this.level);
        for (Tile tile : tiles) {
            Point2D ul = tile.ul;
            Point2D lr = tile.lr;
            StringBuilder buf = new StringBuilder();
            buf.append(ul.getX() + "," + ul.getY() + ",0 ");
            buf.append(lr.getX() + "," + ul.getY() + ",0 ");
            buf.append(lr.getX() + "," + lr.getY() + ",0 ");
            buf.append(ul.getX() + "," + lr.getY() + ",0 ");
            buf.append(ul.getX() + "," + ul.getY() + ",0 ");
            Element placemark = this.appendChild(doc, folderElement, "Placemark", null);
            this.appendChild(doc, placemark, "name", tile.title);
            this.appendChild(doc, placemark, "styleUrl", "#" + this.styleString);
            Element polygon = this.appendChild(doc, placemark, "Polygon", null);
            this.appendChild(doc, polygon, "tessellate", "1");
            Element obiElement = this.appendChild(doc, polygon, "outerBoundaryIs", null);
            Element lrElement = this.appendChild(doc, obiElement, "LinearRing", null);
            Element coordElement = this.appendChild(doc, lrElement, "coordinates", buf.toString());
            Element placemark2 = this.appendChild(doc, folderElement, "Placemark", null);
            this.appendChild(doc, placemark2, "name", tile.title);
            this.appendChild(doc, placemark2, "styleUrl", "#" + this.styleString);
            Element point = this.appendChild(doc, placemark2, "Point", null);
            this.appendChild(doc, point, "coordinates", (lr.getX() + ul.getX()) / 2.0 + "," + (ul.getY() + lr.getY()) / 2.0 + ",0");
        }
        return folderElement;
    }

    protected Element createStyle(Document doc) {
        Element style = doc.createElement("Style");
        style.setAttribute("id", this.styleString);
        Element label = this.appendChild(doc, style, "LabelStyle", null);
        Element line = this.appendChild(doc, style, "LineStyle", null);
        Element poly = this.appendChild(doc, style, "PolyStyle", null);
        String labelColorString = Integer.toHexString(((Color)this.drawingAttributes.getSelectPaint()).getRGB());
        String lineColorString = Integer.toHexString(((Color)this.drawingAttributes.getLinePaint()).getRGB());
        String fillColorString = Integer.toHexString(((Color)this.drawingAttributes.getFillPaint()).getRGB());
        this.appendChild(doc, label, "color", labelColorString);
        this.appendChild(doc, line, "color", lineColorString);
        this.appendChild(doc, poly, "color", fillColorString);
        return style;
    }

    protected Element appendChild(Document doc, Node parent, String childField, String value) {
        Element element = (Element)parent.appendChild(doc.createElement(childField));
        if (value != null) {
            element.setTextContent(value);
        }
        return element;
    }

    protected Element appendChild(Document doc, Node parent, Element child) {
        parent.appendChild(child);
        return child;
    }

    public static void main(String[] args) {
        Color fillColor = new Color(0x3300FF00, true);
        Color lineColor = new Color(-16711936);
        try {
            new Builder(5).setLineColor(lineColor).setFillColor(fillColor).setLabelColor(lineColor).go();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class Builder {
        int zoomLevel;
        Color lineColor = Color.WHITE;
        Color fillColor = Color.WHITE;
        Color labelColor = Color.WHITE;
        String docTitle;
        String fileName;
        OutputStream output;
        boolean closeOutput = false;

        public Builder() {
            this(5);
        }

        public Builder(int tileZoomLevel) {
            this.zoomLevel = tileZoomLevel;
            this.docTitle = "Tile Boundaries for Zoom Level " + this.zoomLevel;
        }

        public Builder setLineColor(Color lineColor) {
            this.lineColor = lineColor;
            return this;
        }

        public Builder setFillColor(Color fillColor) {
            this.fillColor = fillColor;
            return this;
        }

        public Builder setLabelColor(Color labelColor) {
            this.labelColor = labelColor;
            return this;
        }

        public Builder setDocTitle(String docTitle) {
            this.docTitle = docTitle;
            return this;
        }

        public Builder setFileName(String fileName) throws FileNotFoundException {
            String filePath;
            this.fileName = fileName;
            File file = null;
            if (fileName != null) {
                file = new File(fileName);
            }
            if (file == null && (filePath = FileUtils.getFilePathToSaveFromUser("Choose location and name of KML file")) != null) {
                file = new File(filePath);
            }
            if (file != null) {
                this.output = new FileOutputStream(file);
                this.closeOutput = true;
            }
            return this;
        }

        public Builder setOutputStream(OutputStream out) {
            this.output = out;
            return this;
        }

        public void go() throws ParserConfigurationException, TransformerException, IOException {
            KMLTileGridMaker kml = new KMLTileGridMaker(this);
            if (this.output == null) {
                this.setFileName(null);
            }
            if (this.output != null) {
                kml.writeDoc(this.output);
                if (this.closeOutput) {
                    this.output.close();
                }
            } else {
                throw new IOException("No output specified");
            }
        }
    }

    protected class Tile {
        protected int uvx;
        protected int uvy;
        protected Point2D ul;
        protected Point2D lr;
        protected String title;

        protected Tile(int uvx, int uvy, Point2D ul, Point2D lr) {
            this.uvx = uvx;
            this.uvy = uvy;
            this.ul = ul;
            this.lr = lr;
            this.title = uvx + "_" + uvy;
        }
    }
}

