/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.image.geotiff;

import com.bbn.openmap.dataAccess.image.ErrImageTile;
import com.bbn.openmap.dataAccess.image.ImageTile;
import com.bbn.openmap.dataAccess.image.geotiff.GeoTIFFFile;
import com.bbn.openmap.dataAccess.image.geotiff.GeoTIFFImageReader;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotiff.image.KeyRegistry;
import org.geotiff.image.jai.GeoTIFFDirectory;

public class GeoTIFFModelFactory {
    public static Logger logger = Logger.getLogger("com.bbn.openmap.dataAccess.image.geotiff.GeoTIFFModelFactory");
    protected GeoTIFFFile gtfFile;

    public GeoTIFFModelFactory(GeoTIFFFile gtf) {
        this.gtfFile = gtf;
    }

    public ImageTile getImageTile() throws IOException {
        return this.getImageTile(null, null);
    }

    public ImageTile getImageTile(GeoTIFFImageReader gtid, ImageTile.Cache cache) throws IOException {
        int modelType = this.gtfFile.getModelType();
        ImageTile ret = null;
        String errorMessage = null;
        int modelID = -1;
        block0 : switch (modelType) {
            case 1: {
                modelID = this.gtfFile.getProjectedCSType();
                errorMessage = "Projection Model type (" + modelID + ", " + KeyRegistry.getKey(KeyRegistry.EPSG_PCS, modelID) + ") not handled yet";
                if (logger.isLoggable(Level.FINE)) {
                    logger.info(errorMessage);
                }
                ret = new ErrImageTile("Image can't be positioned: " + errorMessage);
                break;
            }
            case 2: 
            case 3: {
                modelID = this.gtfFile.getGeographicType();
                if (logger.isLoggable(Level.FINE)) {
                    logger.info("GeoModel type (" + modelID + "): " + KeyRegistry.getKey(KeyRegistry.EPSG_GCS, modelID));
                }
                switch (modelID) {
                    case 4326: {
                        ret = this.get4326(gtid, cache);
                        break block0;
                    }
                }
                errorMessage = "GeoModel type (" + modelID + ", " + KeyRegistry.getKey(KeyRegistry.EPSG_GCS, modelID) + ") not handled yet";
                logger.info(errorMessage);
                ret = new ErrImageTile("Image can't be positioned: " + errorMessage);
            }
        }
        return ret;
    }

    protected ImageTile get4326(GeoTIFFImageReader gtid, ImageTile.Cache cache) throws IOException {
        GeoTIFFDirectory gtfd = this.gtfFile.getGtfDirectory();
        double[] tiePoints = gtfd.getTiepoints();
        double[] scaleMatrix = gtfd.getPixelScale();
        int imageWidth = this.gtfFile.getFieldIntValue(256);
        int imageHeight = this.gtfFile.getFieldIntValue(257);
        double ulat = tiePoints[4] + tiePoints[1] * scaleMatrix[1];
        double llon = tiePoints[3] - tiePoints[0] * scaleMatrix[0];
        double llat = tiePoints[4] - (double)imageHeight * scaleMatrix[1];
        double rlon = tiePoints[3] + (double)imageWidth * scaleMatrix[0];
        if (logger.isLoggable(Level.FINE)) {
            logger.info("Image should be at: " + ulat + ", " + llon + " - to - " + llat + ", " + rlon);
        }
        if (gtid == null) {
            BufferedImage bi = this.gtfFile.getBufferedImage();
            return new ImageTile((double)((float)ulat), (double)((float)llon), (double)((float)llat), (double)((float)rlon), bi);
        }
        return new ImageTile((float)ulat, (float)llon, (float)llat, (float)rlon, gtid, cache);
    }
}

