/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.asrp;

import com.bbn.openmap.dataAccess.asrp.GeneralASRPFile;
import com.bbn.openmap.dataAccess.iso8211.DDFModule;
import com.bbn.openmap.dataAccess.iso8211.DDFRecord;
import com.bbn.openmap.util.Debug;
import java.io.IOException;

public class SourceFile
extends GeneralASRPFile {
    public static final String SOURCE_SUMMARY = "SGF";
    public static final String SOURCE = "SOR";
    public static final String MAGNETIC_INFORMATION = "MAG";
    public static final String BOUNDING_POLYGON_COORDINATES = "RCI";
    public static final String PROJECTION_FIELD = "PRR";
    public static final String SECURITY_AND_RELEASE = "QSR";
    public static final String INSET = "INS";
    public static final String COPYRIGHT = "CPY";
    public static final String LEGEND = "LGI";
    public static final String DATA_SET_PARAMETERS = "SPR";
    public static final String TILE_INDEX_MAP = "TIM";
    public static final String NORMALIZATION_CONSTANTS = "NCD";
    public static final String SOURCE_DATUM_COEFFICIENTS_DATA = "SDC";
    public static final String MAP_PROJECTIONS_COEFFICIENTS_DATA = "MPC";
    public static final String SUPPLEMENTARY_TEXT = "SUP";

    public SourceFile(String fileName) throws IOException {
        DDFModule mod = this.load(fileName);
        if (mod != null) {
            DDFRecord record;
            while ((record = mod.readRecord()) != null) {
                this.loadField(record, SOURCE_SUMMARY, 0);
                this.loadField(record, SOURCE, 0);
                this.loadField(record, MAGNETIC_INFORMATION, 0);
                this.loadField(record, BOUNDING_POLYGON_COORDINATES, 0);
                this.loadField(record, PROJECTION_FIELD, 0);
                this.loadField(record, SECURITY_AND_RELEASE, 0);
                this.loadField(record, INSET, 0);
                this.loadField(record, COPYRIGHT, 0);
                this.loadField(record, LEGEND, 0);
                this.loadField(record, DATA_SET_PARAMETERS, 0);
                this.loadField(record, TILE_INDEX_MAP, 0);
                this.loadField(record, NORMALIZATION_CONSTANTS, 0);
                this.loadField(record, SOURCE_DATUM_COEFFICIENTS_DATA, 0);
                this.loadField(record, MAP_PROJECTIONS_COEFFICIENTS_DATA, 0);
                this.loadField(record, SUPPLEMENTARY_TEXT, 0);
            }
        }
    }

    public static void main(String[] argv) {
        Debug.init();
        if (argv.length < 1) {
            Debug.output("Usage: SourceFile filename");
        }
        try {
            SourceFile thf = new SourceFile(argv[0]);
            thf.dumpFields();
        }
        catch (IOException ioe) {
            Debug.error(ioe.getMessage());
        }
        System.exit(0);
    }
}

