/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap;

import com.bbn.openmap.Layer;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.SoloMapComponent;
import com.bbn.openmap.event.MapMouseListener;
import com.bbn.openmap.event.MapMouseMode;
import com.bbn.openmap.event.NavMouseMode;
import com.bbn.openmap.event.NullMouseMode;
import com.bbn.openmap.event.ProjectionListener;
import com.bbn.openmap.event.SelectMouseMode;
import com.bbn.openmap.util.Debug;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextChildSupport;
import java.beans.beancontext.BeanContextMembershipEvent;
import java.beans.beancontext.BeanContextMembershipListener;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MouseDelegator
implements PropertyChangeListener,
Serializable,
BeanContextChild,
BeanContextMembershipListener,
SoloMapComponent {
    private static final long serialVersionUID = 1L;
    public static final transient String ActiveModeProperty = "NewActiveMouseMode";
    public static final transient String MouseModesProperty = "NewListOfMouseModes";
    public static final String ProxyMouseModeProperty = "MouseModeProxy";
    protected transient MapMouseMode activeMouseMode = null;
    protected transient Vector<MapMouseMode> mouseModes = new Vector(0);
    protected transient MapBean map;
    protected Layer[] currentLayers = null;
    protected PropertyChangeSupport pcSupport = new PropertyChangeSupport(this);
    protected BeanContextChildSupport beanContextChildSupport = new BeanContextChildSupport();

    public MouseDelegator(MapBean map) {
        this.setMap(map);
    }

    public MouseDelegator() {
        this(null);
    }

    public void setMap(MapBean mapbean) {
        if (this.map != null) {
            this.map.removePropertyChangeListener(this);
            this.setInactive(this.activeMouseMode);
        }
        this.map = mapbean;
        if (this.map != null) {
            this.map.addPropertyChangeListener(this);
            this.setActive(this.activeMouseMode);
        }
    }

    public MapBean getMap() {
        return this.map;
    }

    public String getActiveMouseModeID() {
        if (this.activeMouseMode != null) {
            return this.activeMouseMode.getID();
        }
        return null;
    }

    public void setActiveMouseModeWithID(String MouseModeID) {
        if (MouseModeID == null) {
            Debug.error("MouseDelegator:setActiveMouseModeWithID() - null value");
            return;
        }
        MapMouseMode oldActive = this.activeMouseMode;
        this.setInactive(this.activeMouseMode);
        for (MapMouseMode med : this.mouseModes) {
            if (!MouseModeID.equals(med.getID())) continue;
            this.setActive(med);
            if (!Debug.debugging("mousemode")) break;
            Debug.output("MouseDelegator.setActiveMouseModeWithID() setting new mode to mode " + med.getID());
            break;
        }
        this.firePropertyChange(ActiveModeProperty, oldActive, this.activeMouseMode);
    }

    public MapMouseMode getActiveMouseMode() {
        return this.activeMouseMode;
    }

    public void setActiveMouseMode(MapMouseMode aMed) {
        if (aMed == null) {
            Debug.error("MouseDelegator:setActiveMouseMode() - null value");
            return;
        }
        MapMouseMode oldActive = this.activeMouseMode;
        boolean isAlreadyAMode = false;
        for (MapMouseMode med : this.mouseModes) {
            if (!aMed.getID().equals(med.getID())) continue;
            isAlreadyAMode = true;
        }
        if (!isAlreadyAMode) {
            this.addMouseMode(aMed);
        }
        this.setActive(aMed);
        this.firePropertyChange(ActiveModeProperty, oldActive, this.activeMouseMode);
    }

    public MapMouseMode[] getMouseModes() {
        int nMouseModes = this.mouseModes.size();
        if (nMouseModes == 0) {
            return new MapMouseMode[0];
        }
        MapMouseMode[] result = new MapMouseMode[nMouseModes];
        for (int i = 0; i < nMouseModes; ++i) {
            result[i] = this.mouseModes.elementAt(i);
        }
        return result;
    }

    public void setMouseModes(MapMouseMode[] meds, int activeIndex) {
        this.mouseModes.clear();
        MapMouseMode oldActive = this.activeMouseMode;
        for (int i = 0; i < meds.length; ++i) {
            this.mouseModes.add(meds[i]);
            if (i != activeIndex) continue;
            this.setActive(meds[i]);
        }
        this.firePropertyChange(MouseModesProperty, null, this.mouseModes);
        this.firePropertyChange(ActiveModeProperty, oldActive, this.activeMouseMode);
    }

    public void setMouseModes(MapMouseMode[] meds) {
        this.setMouseModes(meds, 0);
    }

    public void addMouseMode(MapMouseMode med) {
        if (med != null) {
            this.mouseModes.addElement(med);
            if (this.mouseModes.size() == 1) {
                this.setActive(med);
            }
            if (this.currentLayers != null) {
                this.setupMouseModeWithLayers(med, this.currentLayers);
            }
            this.firePropertyChange(MouseModesProperty, null, this.mouseModes);
        }
    }

    public void removeMouseMode(MapMouseMode med) {
        boolean needToAdjustActiveMode = false;
        if (med == null) {
            return;
        }
        if (med.equals(this.activeMouseMode)) {
            needToAdjustActiveMode = true;
            this.setInactive(med);
        }
        for (MapMouseMode checkMM : this.mouseModes) {
            if (med.equals(checkMM)) {
                med.removeAllMapMouseListeners();
                continue;
            }
            if (!needToAdjustActiveMode) continue;
            this.setActive(checkMM);
            needToAdjustActiveMode = false;
        }
        this.mouseModes.remove(med);
        this.firePropertyChange(MouseModesProperty, null, this.mouseModes);
    }

    public void removeMouseMode(String id) {
        for (MapMouseMode med : this.mouseModes) {
            if (!id.equals(med.getID())) continue;
            this.removeMouseMode(med);
            break;
        }
    }

    public void setDefaultMouseModes() {
        MapMouseMode[] modes = new MapMouseMode[]{new NavMouseMode(true), new SelectMouseMode(true), new NullMouseMode()};
        this.setMouseModes(modes);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String property = evt.getPropertyName();
        if (property == "MapBean.layers") {
            Layer[] layers = (Layer[])evt.getNewValue();
            this.currentLayers = new Layer[layers.length];
            System.arraycopy(layers, 0, this.currentLayers, 0, layers.length);
            this.setupMouseModesWithLayers(this.currentLayers);
        }
        if (property.equals(ProxyMouseModeProperty)) {
            Object newObj = evt.getNewValue();
            if (newObj instanceof MapMouseMode) {
                this.map.setCursor(((MapMouseMode)newObj).getModeCursor());
            } else {
                this.map.setCursor(this.getActiveMouseMode().getModeCursor());
            }
            this.firePropertyChange(ProxyMouseModeProperty, evt.getOldValue(), newObj);
        }
    }

    public void setupMouseModesWithLayers(Layer[] layers) {
        for (int j = 0; j < this.mouseModes.size(); ++j) {
            MapMouseMode mmm = this.mouseModes.elementAt(j);
            this.setupMouseModeWithLayers(mmm, layers);
        }
    }

    public void setupMouseModeWithLayers(MapMouseMode mmm, Layer[] layers) {
        mmm.removeAllMapMouseListeners();
        block0: for (int i = 0; i < layers.length; ++i) {
            String[] services;
            MapMouseListener tempmml = null;
            if (layers[i] != null) {
                tempmml = layers[i].getMapMouseListener();
            }
            if (tempmml == null || (services = tempmml.getMouseModeServiceList()) == null) continue;
            for (int k = 0; k < services.length; ++k) {
                if (!mmm.getID().equals(services[k])) continue;
                mmm.addMapMouseListener(tempmml);
                if (!Debug.debugging("mousemode")) continue block0;
                Debug.output("MouseDelegator.setupMouseModeWithLayers(): layer = " + layers[i].getName() + " service = " + mmm.getID());
                continue block0;
            }
        }
    }

    public void setActive(MapMouseMode mm) {
        if (this.activeMouseMode != null) {
            this.setInactive(this.activeMouseMode);
        }
        this.activeMouseMode = mm;
        if (this.map != null && this.activeMouseMode != null) {
            if (Debug.debugging("mousemode")) {
                Debug.output("MouseDelegator.setActive(): " + mm.getID());
            }
            this.map.addMouseListener(mm);
            this.map.addMouseMotionListener(mm);
            this.map.addMouseWheelListener(mm);
            this.map.addPaintListener(mm);
            this.map.setCursor(this.activeMouseMode.getModeCursor());
            if (mm instanceof ProjectionListener) {
                this.map.addProjectionListener((ProjectionListener)((Object)mm));
            }
            this.activeMouseMode.setActive(true);
            this.activeMouseMode.addPropertyChangeListener(this);
        }
    }

    public void setInactive(MapMouseMode mm) {
        if (this.map != null) {
            this.map.removeMouseListener(mm);
            this.map.removeMouseMotionListener(mm);
            this.map.removeMouseWheelListener(mm);
            this.map.removePaintListener(mm);
            if (mm instanceof ProjectionListener) {
                this.map.removeProjectionListener((ProjectionListener)((Object)mm));
            }
        }
        if (this.activeMouseMode == mm) {
            this.activeMouseMode = null;
        }
        if (mm != null) {
            mm.setActive(false);
            mm.removePropertyChangeListener(this);
        }
    }

    public void findAndInit(Iterator<?> it) {
        while (it.hasNext()) {
            this.findAndInit(it.next());
        }
    }

    public void findAndInit(Object someObj) {
        if (someObj instanceof MapBean) {
            Debug.message("mousedelegator", "MouseDelegator found a map.");
            this.setMap((MapBean)someObj);
        }
        if (someObj instanceof MapMouseMode) {
            Debug.message("mousedelegator", "MouseDelegator found a MapMouseMode.");
            this.addMouseMode((MapMouseMode)someObj);
        }
    }

    @Override
    public void childrenAdded(BeanContextMembershipEvent bcme) {
        this.findAndInit(bcme.iterator());
    }

    @Override
    public void childrenRemoved(BeanContextMembershipEvent bcme) {
        Iterator it = bcme.iterator();
        while (it.hasNext()) {
            this.findAndUndo(it.next());
        }
    }

    public void findAndUndo(Object someObj) {
        if (someObj instanceof MapBean && this.getMap() == (MapBean)someObj) {
            Debug.message("mousedelegator", "MouseDelegator: removing the map.");
            this.setMap(null);
        }
        if (someObj instanceof MapMouseMode) {
            Debug.message("mousedelegator", "MouseDelegator: removing a MapMouseMode.");
            this.removeMouseMode((MapMouseMode)someObj);
        }
        if (someObj == this) {
            this.dispose();
        }
    }

    public void dispose() {
        if (this.mouseModes != null) {
            this.mouseModes.clear();
        }
        this.currentLayers = null;
    }

    @Override
    public BeanContext getBeanContext() {
        return this.beanContextChildSupport.getBeanContext();
    }

    @Override
    public void setBeanContext(BeanContext in_bc) throws PropertyVetoException {
        if (in_bc != null) {
            in_bc.addBeanContextMembershipListener(this);
            this.beanContextChildSupport.setBeanContext(in_bc);
            this.findAndInit(in_bc.iterator());
        }
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener in_pcl) {
        this.pcSupport.addPropertyChangeListener(propertyName, in_pcl);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener in_pcl) {
        this.pcSupport.removePropertyChangeListener(propertyName, in_pcl);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcSupport.removePropertyChangeListener(listener);
    }

    public void firePropertyChange(String property, Object oldObj, Object newObj) {
        this.pcSupport.firePropertyChange(property, oldObj, newObj);
    }

    @Override
    public void addVetoableChangeListener(String propertyName, VetoableChangeListener in_vcl) {
        this.beanContextChildSupport.addVetoableChangeListener(propertyName, in_vcl);
    }

    @Override
    public void removeVetoableChangeListener(String propertyName, VetoableChangeListener in_vcl) {
        this.beanContextChildSupport.removeVetoableChangeListener(propertyName, in_vcl);
    }

    public void fireVetoableChange(String name, Object oldValue, Object newValue) throws PropertyVetoException {
        this.beanContextChildSupport.fireVetoableChange(name, oldValue, newValue);
    }
}

