/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.RequiredTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSessionResponse extends S3Response implements
        ToCopyableBuilder<CreateSessionResponse.Builder, CreateSessionResponse> {
    private static final SdkField<SessionCredentials> CREDENTIALS_FIELD = SdkField
            .<SessionCredentials> builder(MarshallingType.SDK_POJO)
            .memberName("Credentials")
            .getter(getter(CreateSessionResponse::credentials))
            .setter(setter(Builder::credentials))
            .constructor(SessionCredentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Credentials")
                    .unmarshallLocationName("Credentials").build(), RequiredTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREDENTIALS_FIELD));

    private final SessionCredentials credentials;

    private CreateSessionResponse(BuilderImpl builder) {
        super(builder);
        this.credentials = builder.credentials;
    }

    /**
     * <p>
     * The established temporary security credentials for the created session..
     * </p>
     * 
     * @return The established temporary security credentials for the created session..
     */
    public final SessionCredentials credentials() {
        return credentials;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(credentials());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSessionResponse)) {
            return false;
        }
        CreateSessionResponse other = (CreateSessionResponse) obj;
        return Objects.equals(credentials(), other.credentials());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSessionResponse").add("Credentials", credentials()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Credentials":
            return Optional.ofNullable(clazz.cast(credentials()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSessionResponse, T> g) {
        return obj -> g.apply((CreateSessionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateSessionResponse> {
        /**
         * <p>
         * The established temporary security credentials for the created session..
         * </p>
         * 
         * @param credentials
         *        The established temporary security credentials for the created session..
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentials(SessionCredentials credentials);

        /**
         * <p>
         * The established temporary security credentials for the created session..
         * </p>
         * This is a convenience method that creates an instance of the {@link SessionCredentials.Builder} avoiding the
         * need to create one manually via {@link SessionCredentials#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SessionCredentials.Builder#build()} is called immediately and its
         * result is passed to {@link #credentials(SessionCredentials)}.
         * 
         * @param credentials
         *        a consumer that will call methods on {@link SessionCredentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #credentials(SessionCredentials)
         */
        default Builder credentials(Consumer<SessionCredentials.Builder> credentials) {
            return credentials(SessionCredentials.builder().applyMutation(credentials).build());
        }
    }

    static final class BuilderImpl extends S3Response.BuilderImpl implements Builder {
        private SessionCredentials credentials;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSessionResponse model) {
            super(model);
            credentials(model.credentials);
        }

        public final SessionCredentials.Builder getCredentials() {
            return credentials != null ? credentials.toBuilder() : null;
        }

        public final void setCredentials(SessionCredentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        @Override
        public final Builder credentials(SessionCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        @Override
        public CreateSessionResponse build() {
            return new CreateSessionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
