/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.nio.netty.internal.http2;

import io.netty.channel.Channel;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.pool.ChannelPool;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.Protocol;
import software.amazon.awssdk.http.nio.netty.internal.ChannelAttributeKey;
import software.amazon.awssdk.http.nio.netty.internal.NettyConfiguration;
import software.amazon.awssdk.http.nio.netty.internal.http2.Http2MultiplexedChannelPool;
import software.amazon.awssdk.http.nio.netty.internal.utils.BetterFixedChannelPool;
import software.amazon.awssdk.http.nio.netty.internal.utils.NettyUtils;

@SdkInternalApi
public class HttpOrHttp2ChannelPool
implements ChannelPool {
    private final ChannelPool delegatePool;
    private final int maxConcurrency;
    private final EventLoop eventLoop;
    private final NettyConfiguration configuration;
    private Promise<ChannelPool> protocolImplPromise;
    private ChannelPool protocolImpl;
    private boolean closed;

    public HttpOrHttp2ChannelPool(ChannelPool delegatePool, EventLoopGroup group, int maxConcurrency, NettyConfiguration configuration) {
        this.delegatePool = delegatePool;
        this.maxConcurrency = maxConcurrency;
        this.eventLoop = group.next();
        this.configuration = configuration;
    }

    public Future<Channel> acquire() {
        return this.acquire((Promise<Channel>)this.eventLoop.newPromise());
    }

    public Future<Channel> acquire(Promise<Channel> promise) {
        NettyUtils.doInEventLoop((EventExecutor)this.eventLoop, () -> this.acquire0(promise), promise);
        return promise;
    }

    private void acquire0(Promise<Channel> promise) {
        if (this.closed) {
            promise.setFailure((Throwable)new IllegalStateException("Channel pool is closed!"));
            return;
        }
        if (this.protocolImpl != null) {
            this.protocolImpl.acquire(promise);
            return;
        }
        if (this.protocolImplPromise == null) {
            this.initializeProtocol();
        }
        this.protocolImplPromise.addListener(future -> {
            if (future.isSuccess()) {
                ((ChannelPool)future.getNow()).acquire(promise);
            } else {
                promise.setFailure(future.cause());
            }
        });
    }

    private void initializeProtocol() {
        this.protocolImplPromise = this.eventLoop.newPromise();
        this.delegatePool.acquire().addListener(future -> {
            if (future.isSuccess()) {
                Channel newChannel = (Channel)future.getNow();
                ((CompletableFuture)newChannel.attr(ChannelAttributeKey.PROTOCOL_FUTURE).get()).whenComplete((protocol, e) -> {
                    if (e != null) {
                        this.failProtocolImplPromise((Throwable)e);
                    } else {
                        this.completeProtocolConfiguration(newChannel, (Protocol)protocol);
                    }
                });
            } else {
                this.failProtocolImplPromise(future.cause());
            }
        });
    }

    private void failProtocolImplPromise(Throwable e) {
        NettyUtils.doInEventLoop((EventExecutor)this.eventLoop, () -> {
            this.protocolImplPromise.setFailure(e);
            this.protocolImplPromise = null;
        });
    }

    void completeProtocolConfiguration(Channel newChannel, Protocol protocol) {
        NettyUtils.doInEventLoop((EventExecutor)this.eventLoop, () -> {
            if (this.closed) {
                newChannel.close();
                this.delegatePool.release(newChannel);
                this.protocolImplPromise.setFailure((Throwable)new IllegalStateException("Pool closed"));
            } else {
                this.protocolImplPromise.setSuccess((Object)this.configureProtocol(newChannel, protocol));
            }
        });
    }

    private ChannelPool configureProtocol(Channel newChannel, Protocol protocol) {
        if (Protocol.HTTP1_1 == protocol) {
            this.protocolImpl = BetterFixedChannelPool.builder().channelPool(this.delegatePool).executor((EventExecutor)this.eventLoop).acquireTimeoutAction(BetterFixedChannelPool.AcquireTimeoutAction.FAIL).acquireTimeoutMillis(this.configuration.connectionAcquireTimeoutMillis()).maxConnections(this.maxConcurrency).maxPendingAcquires(this.configuration.maxPendingConnectionAcquires()).build();
        } else {
            Http2MultiplexedChannelPool h2Pool = new Http2MultiplexedChannelPool(this.delegatePool, this.eventLoop, (Long)newChannel.attr(ChannelAttributeKey.MAX_CONCURRENT_STREAMS).get());
            this.protocolImpl = BetterFixedChannelPool.builder().channelPool(h2Pool).executor((EventExecutor)this.eventLoop).acquireTimeoutAction(BetterFixedChannelPool.AcquireTimeoutAction.FAIL).acquireTimeoutMillis(this.configuration.connectionAcquireTimeoutMillis()).maxConnections(this.maxConcurrency).maxPendingAcquires(this.configuration.maxPendingConnectionAcquires()).build();
        }
        this.delegatePool.release(newChannel);
        return this.protocolImpl;
    }

    public Future<Void> release(Channel channel) {
        return this.release(channel, (Promise<Void>)this.eventLoop.newPromise());
    }

    public Future<Void> release(Channel channel, Promise<Void> promise) {
        NettyUtils.doInEventLoop((EventExecutor)this.eventLoop, () -> this.release0(channel, promise), promise);
        return promise;
    }

    private void release0(Channel channel, Promise<Void> promise) {
        if (this.protocolImpl == null) {
            this.delegatePool.release(channel, promise);
        } else {
            this.protocolImpl.release(channel, promise);
        }
    }

    public void close() {
        NettyUtils.doInEventLoop((EventExecutor)this.eventLoop, this::close0);
    }

    private void close0() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.protocolImpl != null) {
            this.protocolImpl.close();
        } else if (this.protocolImplPromise != null) {
            this.protocolImplPromise.addListener(f -> {
                if (f.isSuccess()) {
                    ((ChannelPool)f.getNow()).close();
                } else {
                    this.delegatePool.close();
                }
            });
        } else {
            this.delegatePool.close();
        }
    }
}

