/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specific configuration settings for a DocumentDB event source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DocumentDBEventSourceConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<DocumentDBEventSourceConfig.Builder, DocumentDBEventSourceConfig> {
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(DocumentDBEventSourceConfig::databaseName))
            .setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> COLLECTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CollectionName").getter(getter(DocumentDBEventSourceConfig::collectionName))
            .setter(setter(Builder::collectionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionName").build()).build();

    private static final SdkField<String> FULL_DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FullDocument").getter(getter(DocumentDBEventSourceConfig::fullDocumentAsString))
            .setter(setter(Builder::fullDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FullDocument").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_NAME_FIELD,
            COLLECTION_NAME_FIELD, FULL_DOCUMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String databaseName;

    private final String collectionName;

    private final String fullDocument;

    private DocumentDBEventSourceConfig(BuilderImpl builder) {
        this.databaseName = builder.databaseName;
        this.collectionName = builder.collectionName;
        this.fullDocument = builder.fullDocument;
    }

    /**
     * <p>
     * The name of the database to consume within the DocumentDB cluster.
     * </p>
     * 
     * @return The name of the database to consume within the DocumentDB cluster.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * The name of the collection to consume within the database. If you do not specify a collection, Lambda consumes
     * all collections.
     * </p>
     * 
     * @return The name of the collection to consume within the database. If you do not specify a collection, Lambda
     *         consumes all collections.
     */
    public final String collectionName() {
        return collectionName;
    }

    /**
     * <p>
     * Determines what DocumentDB sends to your event stream during document update operations. If set to UpdateLookup,
     * DocumentDB sends a delta describing the changes, along with a copy of the entire document. Otherwise, DocumentDB
     * sends only a partial document that contains the changes.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fullDocument} will
     * return {@link FullDocument#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fullDocumentAsString}.
     * </p>
     * 
     * @return Determines what DocumentDB sends to your event stream during document update operations. If set to
     *         UpdateLookup, DocumentDB sends a delta describing the changes, along with a copy of the entire document.
     *         Otherwise, DocumentDB sends only a partial document that contains the changes.
     * @see FullDocument
     */
    public final FullDocument fullDocument() {
        return FullDocument.fromValue(fullDocument);
    }

    /**
     * <p>
     * Determines what DocumentDB sends to your event stream during document update operations. If set to UpdateLookup,
     * DocumentDB sends a delta describing the changes, along with a copy of the entire document. Otherwise, DocumentDB
     * sends only a partial document that contains the changes.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fullDocument} will
     * return {@link FullDocument#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fullDocumentAsString}.
     * </p>
     * 
     * @return Determines what DocumentDB sends to your event stream during document update operations. If set to
     *         UpdateLookup, DocumentDB sends a delta describing the changes, along with a copy of the entire document.
     *         Otherwise, DocumentDB sends only a partial document that contains the changes.
     * @see FullDocument
     */
    public final String fullDocumentAsString() {
        return fullDocument;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(collectionName());
        hashCode = 31 * hashCode + Objects.hashCode(fullDocumentAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentDBEventSourceConfig)) {
            return false;
        }
        DocumentDBEventSourceConfig other = (DocumentDBEventSourceConfig) obj;
        return Objects.equals(databaseName(), other.databaseName()) && Objects.equals(collectionName(), other.collectionName())
                && Objects.equals(fullDocumentAsString(), other.fullDocumentAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DocumentDBEventSourceConfig").add("DatabaseName", databaseName())
                .add("CollectionName", collectionName()).add("FullDocument", fullDocumentAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "CollectionName":
            return Optional.ofNullable(clazz.cast(collectionName()));
        case "FullDocument":
            return Optional.ofNullable(clazz.cast(fullDocumentAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DatabaseName", DATABASE_NAME_FIELD);
        map.put("CollectionName", COLLECTION_NAME_FIELD);
        map.put("FullDocument", FULL_DOCUMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DocumentDBEventSourceConfig, T> g) {
        return obj -> g.apply((DocumentDBEventSourceConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DocumentDBEventSourceConfig> {
        /**
         * <p>
         * The name of the database to consume within the DocumentDB cluster.
         * </p>
         * 
         * @param databaseName
         *        The name of the database to consume within the DocumentDB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The name of the collection to consume within the database. If you do not specify a collection, Lambda
         * consumes all collections.
         * </p>
         * 
         * @param collectionName
         *        The name of the collection to consume within the database. If you do not specify a collection, Lambda
         *        consumes all collections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionName(String collectionName);

        /**
         * <p>
         * Determines what DocumentDB sends to your event stream during document update operations. If set to
         * UpdateLookup, DocumentDB sends a delta describing the changes, along with a copy of the entire document.
         * Otherwise, DocumentDB sends only a partial document that contains the changes.
         * </p>
         * 
         * @param fullDocument
         *        Determines what DocumentDB sends to your event stream during document update operations. If set to
         *        UpdateLookup, DocumentDB sends a delta describing the changes, along with a copy of the entire
         *        document. Otherwise, DocumentDB sends only a partial document that contains the changes.
         * @see FullDocument
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FullDocument
         */
        Builder fullDocument(String fullDocument);

        /**
         * <p>
         * Determines what DocumentDB sends to your event stream during document update operations. If set to
         * UpdateLookup, DocumentDB sends a delta describing the changes, along with a copy of the entire document.
         * Otherwise, DocumentDB sends only a partial document that contains the changes.
         * </p>
         * 
         * @param fullDocument
         *        Determines what DocumentDB sends to your event stream during document update operations. If set to
         *        UpdateLookup, DocumentDB sends a delta describing the changes, along with a copy of the entire
         *        document. Otherwise, DocumentDB sends only a partial document that contains the changes.
         * @see FullDocument
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FullDocument
         */
        Builder fullDocument(FullDocument fullDocument);
    }

    static final class BuilderImpl implements Builder {
        private String databaseName;

        private String collectionName;

        private String fullDocument;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentDBEventSourceConfig model) {
            databaseName(model.databaseName);
            collectionName(model.collectionName);
            fullDocument(model.fullDocument);
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getCollectionName() {
            return collectionName;
        }

        public final void setCollectionName(String collectionName) {
            this.collectionName = collectionName;
        }

        @Override
        public final Builder collectionName(String collectionName) {
            this.collectionName = collectionName;
            return this;
        }

        public final String getFullDocument() {
            return fullDocument;
        }

        public final void setFullDocument(String fullDocument) {
            this.fullDocument = fullDocument;
        }

        @Override
        public final Builder fullDocument(String fullDocument) {
            this.fullDocument = fullDocument;
            return this;
        }

        @Override
        public final Builder fullDocument(FullDocument fullDocument) {
            this.fullDocument(fullDocument == null ? null : fullDocument.toString());
            return this;
        }

        @Override
        public DocumentDBEventSourceConfig build() {
            return new DocumentDBEventSourceConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
