/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.sonatype.plexus.build.incremental.BuildContext;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.extensions.manager.standalone.ExtensionsStandaloneManagerFactory;
import ro.isdc.wro.manager.WroManager;
import ro.isdc.wro.manager.factory.standalone.InjectableContextAwareManagerFactory;
import ro.isdc.wro.manager.factory.standalone.StandaloneContext;
import ro.isdc.wro.manager.factory.standalone.StandaloneContextAwareManagerFactory;
import ro.isdc.wro.maven.plugin.support.ExtraConfigFileAware;
import ro.isdc.wro.model.WroModel;
import ro.isdc.wro.model.WroModelInspector;
import ro.isdc.wro.model.group.Group;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.locator.factory.UriLocatorFactory;
import ro.isdc.wro.model.resource.support.hash.HashStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWro4jMojo
extends AbstractMojo {
    private File wroFile;
    private File contextFolder;
    private boolean minimize;
    private boolean ignoreMissingResources;
    private String targetGroups;
    private MavenProject mavenProject;
    private String wroManagerFactory;
    private StandaloneContextAwareManagerFactory managerFactory;
    private File extraConfigFile;
    private BuildContext buildContext;

    public final void execute() throws MojoExecutionException {
        this.validate();
        this.getLog().info((CharSequence)"Executing the mojo: ");
        this.getLog().info((CharSequence)("Wro4j Model path: " + this.wroFile.getPath()));
        this.getLog().info((CharSequence)("targetGroups: " + this.getTargetGroups()));
        this.getLog().info((CharSequence)("minimize: " + this.isMinimize()));
        this.getLog().info((CharSequence)("ignoreMissingResources: " + this.isIgnoreMissingResources()));
        this.getLog().debug((CharSequence)("wroManagerFactory: " + this.wroManagerFactory));
        this.getLog().debug((CharSequence)("extraConfig: " + this.extraConfigFile));
        this.extendPluginClasspath();
        Context.set((Context)Context.standaloneContext());
        try {
            this.onBeforeExecute();
            this.doExecute();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Exception occured while processing: " + e.getMessage(), e);
        }
        finally {
            this.onAfterExecute();
        }
    }

    protected void onBeforeExecute() {
    }

    protected void onAfterExecute() {
    }

    private StandaloneContext createStandaloneContext() {
        StandaloneContext runContext = new StandaloneContext();
        runContext.setContextFolder(this.getContextFolder());
        runContext.setMinimize(this.isMinimize());
        runContext.setWroFile(this.getWroFile());
        runContext.setIgnoreMissingResources(this.isIgnoreMissingResources());
        return runContext;
    }

    protected abstract void doExecute() throws Exception;

    protected StandaloneContextAwareManagerFactory getManagerFactory() throws Exception {
        if (this.managerFactory == null) {
            this.managerFactory = new InjectableContextAwareManagerFactory(this.newWroManagerFactory());
            this.managerFactory.initialize(this.createStandaloneContext());
        }
        return this.managerFactory;
    }

    protected StandaloneContextAwareManagerFactory newWroManagerFactory() throws MojoExecutionException {
        Object factory = null;
        factory = this.wroManagerFactory != null ? this.createCustomManagerFactory() : new ExtensionsStandaloneManagerFactory();
        this.getLog().info((CharSequence)("wroManagerFactory class: " + factory.getClass().getName()));
        if (factory instanceof ExtraConfigFileAware) {
            if (this.extraConfigFile == null) {
                throw new MojoExecutionException("The " + factory.getClass() + " requires a valid extraConfigFile!");
            }
            this.getLog().debug((CharSequence)("Using extraConfigFile: " + this.extraConfigFile.getAbsolutePath()));
            ((ExtraConfigFileAware)factory).setExtraConfigFile(this.extraConfigFile);
        }
        return factory;
    }

    private StandaloneContextAwareManagerFactory createCustomManagerFactory() throws MojoExecutionException {
        StandaloneContextAwareManagerFactory managerFactory;
        try {
            Class<?> wroManagerFactoryClass = Thread.currentThread().getContextClassLoader().loadClass(this.wroManagerFactory.trim());
            managerFactory = (StandaloneContextAwareManagerFactory)wroManagerFactoryClass.newInstance();
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Cannot instantiate wroManagerFactoryClass", (Throwable)e);
            throw new MojoExecutionException("Invalid wroManagerFactoryClass, called: " + this.wroManagerFactory, e);
        }
        return managerFactory;
    }

    protected final List<String> getTargetGroupsAsList() throws Exception {
        List<String> result = null;
        result = this.isIncrementalBuild() ? this.getIncrementalGroupNames() : (this.getTargetGroups() == null ? this.getAllModelGroupNames() : Arrays.asList(this.getTargetGroups().split(",")));
        this.persistResourceFingerprints(result);
        this.getLog().info((CharSequence)("The following groups will be processed: " + result));
        return result;
    }

    private void persistResourceFingerprints(List<String> groupNames) {
        if (this.buildContext != null) {
            WroModelInspector modelInspector = new WroModelInspector(this.getModel());
            WroManager manager = this.getWroManager();
            HashStrategy hashStrategy = manager.getHashStrategy();
            UriLocatorFactory locatorFactory = manager.getUriLocatorFactory();
            for (String groupName : groupNames) {
                Group group = modelInspector.getGroupByName(groupName);
                if (group == null) continue;
                for (Resource resource : group.getResources()) {
                    try {
                        String fingerprint = hashStrategy.getHash(locatorFactory.locate(resource.getUri()));
                        this.buildContext.setValue(resource.getUri(), (Object)fingerprint);
                    }
                    catch (IOException e) {
                        this.getLog().debug((CharSequence)("could not check fingerprint of resource: " + resource));
                    }
                }
            }
        }
    }

    private List<String> getIncrementalGroupNames() throws Exception {
        ArrayList<String> changedGroupNames = new ArrayList<String>();
        block0: for (Group group : this.getModel().getGroups()) {
            for (Resource resource : group.getResources()) {
                this.getLog().debug((CharSequence)("checking delta for resource: " + resource));
                if (!this.isResourceUriChanged(resource.getUri())) continue;
                this.getLog().debug((CharSequence)("detected change for resource: " + resource + " and group: " + group.getName()));
                changedGroupNames.add(group.getName());
                continue block0;
            }
        }
        return changedGroupNames;
    }

    private boolean isResourceUriChanged(String resourceUri) {
        WroManager manager = this.getWroManager();
        HashStrategy hashStrategy = manager.getHashStrategy();
        UriLocatorFactory locatorFactory = manager.getUriLocatorFactory();
        try {
            String fingerprint = hashStrategy.getHash(locatorFactory.locate(resourceUri));
            String previousFingerprint = this.buildContext != null ? String.valueOf(this.buildContext.getValue(resourceUri)) : null;
            this.getLog().debug((CharSequence)("fingerprint <current, prev>: <" + fingerprint + ", " + previousFingerprint + ">"));
            return fingerprint != null && !fingerprint.equals(previousFingerprint);
        }
        catch (IOException e) {
            this.getLog().debug((CharSequence)("failed to check for delta resource: " + resourceUri));
            return false;
        }
    }

    private boolean isIncrementalBuild() {
        return this.buildContext != null && this.buildContext.isIncremental();
    }

    private List<String> getAllModelGroupNames() {
        return new WroModelInspector(this.getModel()).getGroupNames();
    }

    private WroModel getModel() {
        return (WroModel)this.getWroManager().getModelFactory().create();
    }

    private WroManager getWroManager() {
        try {
            return (WroManager)this.getManagerFactory().create();
        }
        catch (Exception e) {
            throw WroRuntimeException.wrap((Exception)e);
        }
    }

    protected void validate() throws MojoExecutionException {
        if (this.wroFile == null) {
            throw new MojoExecutionException("contextFolder was not set!");
        }
        if (this.contextFolder == null) {
            throw new MojoExecutionException("contextFolder was not set!");
        }
    }

    protected final void extendPluginClasspath() throws MojoExecutionException {
        ArrayList<String> classpathElements = new ArrayList<String>();
        try {
            classpathElements.addAll(this.mavenProject.getRuntimeClasspathElements());
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Could not get compile classpath elements", (Exception)((Object)e));
        }
        ClassLoader classLoader = this.createClassLoader(classpathElements);
        Thread.currentThread().setContextClassLoader(classLoader);
    }

    private ClassLoader createClassLoader(List<String> classpathElements) {
        this.getLog().debug((CharSequence)"Classpath elements:");
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            for (String element : classpathElements) {
                File elementFile = new File(element);
                this.getLog().debug((CharSequence)("Adding element to plugin classpath: " + elementFile.getPath()));
                urls.add(elementFile.toURI().toURL());
            }
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Error retreiving URL for artifact", (Throwable)e);
            throw new RuntimeException(e);
        }
        return new URLClassLoader(urls.toArray(new URL[0]), Thread.currentThread().getContextClassLoader());
    }

    public void setContextFolder(File contextFolder) {
        this.contextFolder = contextFolder;
    }

    public void setWroFile(File wroFile) {
        this.wroFile = wroFile;
    }

    public File getWroFile() {
        return this.wroFile;
    }

    public File getContextFolder() {
        return this.contextFolder;
    }

    public void setMinimize(boolean minimize) {
        this.minimize = minimize;
    }

    public void setIgnoreMissingResources(boolean ignoreMissingResources) {
        this.ignoreMissingResources = ignoreMissingResources;
    }

    public boolean isMinimize() {
        return this.minimize;
    }

    public boolean isIgnoreMissingResources() {
        return this.ignoreMissingResources;
    }

    void setMavenProject(MavenProject mavenProject) {
        this.mavenProject = mavenProject;
    }

    public String getTargetGroups() {
        return this.targetGroups;
    }

    public void setTargetGroups(String targetGroups) {
        this.targetGroups = targetGroups;
    }

    public void setWroManagerFactory(String wroManagerFactory) {
        this.wroManagerFactory = wroManagerFactory;
    }

    public void setExtraConfigFile(File extraConfigFile) {
        this.extraConfigFile = extraConfigFile;
    }

    void setBuildContext(BuildContext buildContext) {
        this.buildContext = buildContext;
    }
}

