/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.maven.plugin;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.maven.plugin.MojoExecutionException;
import org.mockito.Mockito;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.config.jmx.WroConfiguration;
import ro.isdc.wro.http.support.DelegatingServletOutputStream;
import ro.isdc.wro.manager.WroManager;
import ro.isdc.wro.maven.plugin.AbstractWro4jMojo;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.util.io.UnclosableBufferedInputStream;

public class Wro4jMojo
extends AbstractWro4jMojo {
    private File destinationFolder;
    private File cssDestinationFolder;
    private File jsDestinationFolder;
    private File buildDirectory;
    private File buildFinalName;
    private String groupNameMappingFile;
    private final Properties groupNames = new Properties();

    protected void validate() throws MojoExecutionException {
        super.validate();
        if (this.destinationFolder == null) {
            throw new MojoExecutionException("destinationFolder was not set!");
        }
    }

    protected void doExecute() throws Exception {
        this.getLog().info((CharSequence)("destinationFolder: " + this.destinationFolder));
        this.getLog().info((CharSequence)("jsDestinationFolder: " + this.jsDestinationFolder));
        this.getLog().info((CharSequence)("cssDestinationFolder: " + this.cssDestinationFolder));
        this.getLog().info((CharSequence)("groupNameMappingFile: " + this.groupNameMappingFile));
        List<String> groupsAsList = this.getTargetGroupsAsList();
        for (String group : groupsAsList) {
            for (ResourceType resourceType : ResourceType.values()) {
                File destinationFolder = this.computeDestinationFolder(resourceType);
                String groupWithExtension = group + "." + resourceType.name().toLowerCase();
                this.processGroup(groupWithExtension, destinationFolder);
            }
        }
        this.writeGroupNameMap();
    }

    private void writeGroupNameMap() throws Exception {
        if (this.groupNameMappingFile != null) {
            try {
                FileOutputStream outputStream = new FileOutputStream(this.groupNameMappingFile);
                this.groupNames.store(outputStream, "Mapping of defined group name to renamed group name");
            }
            catch (FileNotFoundException ex) {
                throw new MojoExecutionException("Unable to save group name mapping file", (Exception)ex);
            }
        }
    }

    private String rename(String group, InputStream input) throws Exception {
        try {
            String newName = ((WroManager)this.getManagerFactory().create()).getNamingStrategy().rename(group, input);
            this.groupNames.setProperty(group, newName);
            return newName;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error occured during renaming", (Exception)e);
        }
    }

    private File computeDestinationFolder(ResourceType resourceType) throws MojoExecutionException {
        File folder = this.destinationFolder;
        if (resourceType == ResourceType.JS && this.jsDestinationFolder != null) {
            folder = this.jsDestinationFolder;
        }
        if (resourceType == ResourceType.CSS && this.cssDestinationFolder != null) {
            folder = this.cssDestinationFolder;
        }
        this.getLog().info((CharSequence)("folder: " + folder));
        if (folder == null) {
            throw new MojoExecutionException("Couldn't compute destination folder for resourceType: " + resourceType + ". That means that you didn't define one of the following parameters: " + "destinationFolder, cssDestinationFolder, jsDestinationFolder");
        }
        if (!folder.exists()) {
            folder.mkdirs();
        }
        return folder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processGroup(String group, File parentFoder) throws Exception {
        ByteArrayOutputStream resultOutputStream = null;
        InputStream resultInputStream = null;
        try {
            this.getLog().info((CharSequence)("processing group: " + group));
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getRequestURI()).thenReturn((Object)group);
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            resultOutputStream = new ByteArrayOutputStream();
            Mockito.when((Object)response.getOutputStream()).thenReturn((Object)new DelegatingServletOutputStream((OutputStream)resultOutputStream));
            WroConfiguration config = Context.get().getConfig();
            Context.set((Context)Context.webContext((HttpServletRequest)request, (HttpServletResponse)response, (FilterConfig)((FilterConfig)Mockito.mock(FilterConfig.class))), (WroConfiguration)config);
            Context.get().setAggregatedFolderPath(this.computeAggregatedFolderPath());
            ((WroManager)this.getManagerFactory().create()).process();
            resultInputStream = new UnclosableBufferedInputStream(resultOutputStream.toByteArray());
            File destinationFile = new File(parentFoder, this.rename(group, resultInputStream));
            destinationFile.createNewFile();
            resultInputStream.reset();
            this.getLog().debug((CharSequence)("Created file: " + destinationFile.getName()));
            FileOutputStream fos = new FileOutputStream(destinationFile);
            IOUtils.copy((InputStream)resultInputStream, (OutputStream)fos);
            ((OutputStream)fos).close();
            if (destinationFile.length() == 0L) {
                this.getLog().debug((CharSequence)("No content found for group: " + group));
                destinationFile.delete();
            } else {
                this.getLog().info((CharSequence)("file size: " + destinationFile.getName() + " -> " + destinationFile.length() + " bytes"));
                this.getLog().info((CharSequence)(destinationFile.getAbsolutePath() + " (" + destinationFile.length() + " bytes" + ")"));
            }
        }
        finally {
            if (resultOutputStream != null) {
                resultOutputStream.close();
            }
            if (resultInputStream != null) {
                resultInputStream.close();
            }
        }
    }

    private String computeAggregatedFolderPath() {
        Validate.notNull((Object)this.buildDirectory, (String)"Build directory cannot be null!", (Object[])new Object[0]);
        String result = null;
        File cssTargetFolder = this.cssDestinationFolder == null ? this.destinationFolder : this.cssDestinationFolder;
        File rootFolder = null;
        Validate.notNull((Object)cssTargetFolder, (String)"cssTargetFolder cannot be null!", (Object[])new Object[0]);
        if (this.buildFinalName != null && cssTargetFolder.getPath().startsWith(this.buildFinalName.getPath())) {
            rootFolder = this.buildFinalName;
        } else if (cssTargetFolder.getPath().startsWith(this.buildDirectory.getPath())) {
            rootFolder = this.buildDirectory;
        } else if (cssTargetFolder.getPath().startsWith(this.getContextFolder().getPath())) {
            rootFolder = this.getContextFolder();
        }
        this.getLog().debug((CharSequence)("buildDirectory: " + this.buildDirectory));
        this.getLog().debug((CharSequence)("contextFolder: " + this.getContextFolder()));
        this.getLog().debug((CharSequence)("cssTargetFolder: " + cssTargetFolder));
        this.getLog().debug((CharSequence)("rootFolder: " + rootFolder));
        if (rootFolder != null) {
            result = StringUtils.removeStart((String)cssTargetFolder.getPath(), (String)rootFolder.getPath());
        }
        this.getLog().debug((CharSequence)("computedAggregatedFolderPath: " + result));
        return result;
    }

    public void setDestinationFolder(File destinationFolder) {
        this.destinationFolder = destinationFolder;
    }

    public void setCssDestinationFolder(File cssDestinationFolder) {
        this.cssDestinationFolder = cssDestinationFolder;
    }

    public void setJsDestinationFolder(File jsDestinationFolder) {
        this.jsDestinationFolder = jsDestinationFolder;
    }

    public void setBuildDirectory(File buildDirectory) {
        this.buildDirectory = buildDirectory;
    }

    public void setBuildFinalName(File buildFinalName) {
        this.buildFinalName = buildFinalName;
    }

    public void setGroupNameMappingFile(String groupNameMappingFile) {
        this.groupNameMappingFile = groupNameMappingFile;
    }
}

