/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.jsp.zul.impl;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.DynamicAttributes;
import javax.servlet.jsp.tagext.JspTag;
import org.zkoss.jsp.zul.impl.AbstractTag;
import org.zkoss.jsp.zul.impl.BranchTag;
import org.zkoss.jsp.zul.impl.RootTag;
import org.zkoss.jsp.zul.impl.Utils;
import org.zkoss.lang.Classes;
import org.zkoss.lang.reflect.Fields;
import org.zkoss.util.ModificationException;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.CreateEvent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.ext.AfterCompose;
import org.zkoss.zk.ui.metainfo.EventHandler;
import org.zkoss.zk.ui.metainfo.ZScript;
import org.zkoss.zk.ui.metainfo.impl.AnnotationHelper;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zk.ui.sys.ComponentsCtrl;

public abstract class LeafTag
extends AbstractTag
implements DynamicAttributes {
    private Component _comp;
    private RootTag _roottag;
    private BranchTag _parenttag;
    private Map _attrMap = new LinkedHashMap();
    private Map _eventListenerMap = new LinkedHashMap();
    private String _use;
    private String _forward;

    public RootTag getRootTag() {
        return this._roottag;
    }

    public BranchTag getParentTag() {
        return this._parenttag;
    }

    public Component getComponent() {
        return this._comp;
    }

    protected abstract Component newComponent(Class var1) throws Exception;

    public void setParent(JspTag parent) {
        super.setParent(parent);
        AbstractTag pt = (AbstractTag)LeafTag.findAncestorWithClass((JspTag)this, (Class)AbstractTag.class);
        if (pt instanceof RootTag) {
            this._roottag = (RootTag)pt;
        } else if (pt instanceof BranchTag) {
            this._parenttag = (BranchTag)pt;
            this._roottag = this._parenttag.getRootTag();
        } else {
            throw new IllegalStateException("Must be nested inside the page tag: " + (Object)((Object)this));
        }
    }

    public void doTag() throws JspException, IOException {
        if (!this.isEffective()) {
            return;
        }
        this.initComponent();
        this.afterComposeComponent();
        this.writeComponentMark();
    }

    void initComponent() throws JspException {
        if (this._roottag == null) {
            throw new IllegalStateException("Must be nested inside the page tag: " + (Object)((Object)this));
        }
        try {
            this._comp = this.newComponent(this._use != null ? Classes.forNameByThread((String)this._use) : null);
        }
        catch (Exception e) {
            throw new JspException((Throwable)e);
        }
        if (this._parenttag != null) {
            this._parenttag.addChildTag(this);
        } else {
            this._roottag.addChildTag(this);
        }
    }

    private void evaluateDynaAttributes(Component target) throws ModificationException, NoSuchMethodException {
        AnnotationHelper helper = null;
        Iterator itor = this._attrMap.entrySet().iterator();
        while (itor.hasNext()) {
            Map.Entry entry = itor.next();
            String attnm = (String)entry.getKey();
            String attval = (String)entry.getValue();
            int len = attval.length();
            if (len >= 3 && attval.charAt(0) == '@' && attval.charAt(1) == '{' && attval.charAt(len - 1) == '}') {
                if (helper == null) {
                    helper = new AnnotationHelper();
                }
                helper.addByCompoundValue(attval.substring(2, len - 1));
                helper.applyAnnotations(this._comp, "self".equals(attnm) ? null : attnm, true);
                continue;
            }
            Fields.setField((Object)target, (String)attnm, entry.getValue(), (boolean)true);
        }
    }

    public void setDynamicAttribute(String uri, String localName, Object value) throws JspException {
        if ("if".equals(localName) || "unless".equals(localName)) {
            throw new JspException("if, unless, use is static method!!!");
        }
        if (localName.startsWith("on")) {
            this._eventListenerMap.put(localName, value);
        } else {
            this._attrMap.put(localName, value);
        }
    }

    void writeComponentMark() throws IOException {
        Utils.writeComponentMark((Writer)this.getJspContext().getOut(), this._comp);
    }

    void afterComposeComponent() throws JspException {
        if (this._comp instanceof AfterCompose) {
            ((AfterCompose)this._comp).afterCompose();
        }
        if (Events.isListened((Component)this._comp, (String)"onCreate", (boolean)false)) {
            Events.postEvent((Event)new CreateEvent("onCreate", this._comp, Executions.getCurrent().getArg()));
        }
        if (this._comp == null) {
            throw new JspTagException("newComponent() returns null");
        }
        try {
            this.evaluateDynaAttributes(this._comp);
        }
        catch (ModificationException e) {
            throw new JspException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new JspException((Throwable)e);
        }
        ComponentsCtrl.applyForward((Component)this._comp, (String)this._forward);
        Iterator itor = this._eventListenerMap.entrySet().iterator();
        while (itor.hasNext()) {
            Map.Entry entry = itor.next();
            ZScript zscript = ZScript.parseContent((String)((String)entry.getValue()));
            ((ComponentCtrl)this._comp).addEventHandler((String)entry.getKey(), new EventHandler(zscript, null));
        }
    }

    public String getUse() {
        return this._use;
    }

    public void setUse(String use) {
        this._use = use;
    }

    public String getForward() {
        return this._forward;
    }

    public void setForward(String forward) {
        this._forward = forward != null && forward.length() > 0 ? forward : null;
    }
}

