/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkplus.hibernate;

import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.cfg.Configuration;
import org.zkoss.lang.JVMs;
import org.zkoss.util.logging.Log;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.WebApp;

public class HibernateUtil {
    public static final String CONFIG = "HibernateUtil.config";
    private static final Log log = Log.lookup((Class)HibernateUtil.class);
    private static SessionFactory _factory;

    public static SessionFactory getSessionFactory() {
        return HibernateUtil.initSessionFactory((WebApp)null);
    }

    public static Session currentSession() throws HibernateException {
        return HibernateUtil.getSessionFactory().getCurrentSession();
    }

    public static void closeSession() throws HibernateException {
        HibernateUtil.currentSession().close();
    }

    static SessionFactory initSessionFactory(WebApp app) {
        if (_factory == null) {
            Desktop desktop;
            Execution exec;
            if (app == null && (exec = Executions.getCurrent()) != null && (desktop = exec.getDesktop()) != null) {
                app = desktop.getWebApp();
            }
            String resource = null;
            if (app != null) {
                org.zkoss.zk.ui.util.Configuration config = app.getConfiguration();
                resource = config.getPreference(CONFIG, null);
            }
            return HibernateUtil.initSessionFactory(resource);
        }
        return _factory;
    }

    static SessionFactory initSessionFactory(String resource) {
        if (_factory == null) {
            try {
                _factory = JVMs.isJava5() ? HibernateUtil.java5Factory(resource) : HibernateUtil.java4Factory(resource);
                log.info("Hibernate configuration file loaded: " + (resource == null ? "hibernate.cfg.xml" : resource));
            }
            catch (Throwable ex) {
                log.error("Initial SessionFactory creation failed." + ex);
                throw new ExceptionInInitializerError(ex);
            }
        }
        return _factory;
    }

    static SessionFactory java5Factory(String resource) {
        return resource == null ? new AnnotationConfiguration().configure().buildSessionFactory() : new AnnotationConfiguration().configure(resource).buildSessionFactory();
    }

    static SessionFactory java4Factory(String resource) {
        return resource == null ? new Configuration().configure().buildSessionFactory() : new Configuration().configure(resource).buildSessionFactory();
    }

    static void cleanupSessionFactory() {
        if (_factory != null) {
            _factory.close();
            _factory = null;
        }
    }
}

