/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.xawk;

import bsh.EvalError;
import bsh.Interpreter;
import java.util.LinkedList;
import java.util.List;
import org.zkoss.idom.Element;
import org.zkoss.lang.Classes;

public final class Context {
    public final String path;
    public final Element element;
    public String name;
    public String text;
    public final Context parent;
    public final Interpreter interpreter;
    private final List _stack;

    Context(Element e, Interpreter interpreter) {
        this.element = e;
        this.name = e.getName();
        this.path = '/' + this.name;
        this.text = e.getText(true);
        this.parent = null;
        this.interpreter = interpreter;
        this._stack = new LinkedList();
    }

    Context(Element e, Context parent) {
        this.element = e;
        this.name = e.getName();
        this.path = parent.path + '/' + this.name;
        this.text = e.getText(true);
        this.parent = parent;
        this.interpreter = parent.interpreter;
        this._stack = parent._stack;
    }

    public final String getAttributeValue(String attrName) {
        return this.element.getAttributeValue(attrName);
    }

    public final void set(String name, Object value) throws EvalError {
        this.interpreter.set(Classes.correctFieldName(name), value);
    }

    public final void set(String name, boolean value) throws EvalError {
        this.interpreter.set(Classes.correctFieldName(name), value);
    }

    public final void set(String name, int value) throws EvalError {
        this.interpreter.set(Classes.correctFieldName(name), value);
    }

    public final void set(String name, long value) throws EvalError {
        this.interpreter.set(Classes.correctFieldName(name), value);
    }

    public final void set(String name, short value) throws EvalError {
        this.interpreter.set(Classes.correctFieldName(name), (int)value);
    }

    public final void set(String name, byte value) throws EvalError {
        this.interpreter.set(Classes.correctFieldName(name), (int)value);
    }

    public final void set(String name, char value) throws EvalError {
        this.interpreter.set(Classes.correctFieldName(name), (int)value);
    }

    public final Object get(String name) throws EvalError {
        return this.interpreter.get(Classes.correctFieldName(name));
    }

    public final void push(Object val) {
        this._stack.add(0, val);
    }

    public final void push(boolean v) {
        this.push(new Boolean(v));
    }

    public final void push(int v) {
        this.push(new Integer(v));
    }

    public final void push(long v) {
        this.push(new Long(v));
    }

    public final void push(short v) {
        this.push(new Short(v));
    }

    public final void push(byte v) {
        this.push(new Byte(v));
    }

    public final void push(char v) {
        this.push(new Character(v));
    }

    public final Object pop() {
        return this._stack.remove(0);
    }

    public final Object peek() {
        return this._stack.isEmpty() ? null : this._stack.get(0);
    }
}

