/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Set;
import org.zkoss.lang.Objects;

public class IdentityHashSet
extends AbstractSet
implements Set,
Cloneable,
Serializable {
    private static final long serialVersionUID = 20060622L;
    private transient IdentityHashMap map;

    public IdentityHashSet() {
        this.map = new IdentityHashMap();
    }

    public IdentityHashSet(Collection c) {
        this.map = new IdentityHashMap(Math.max(c.size() * 4 / 3, 16));
        this.addAll(c);
    }

    public IdentityHashSet(int expectedMaxSize) {
        this.map = new IdentityHashMap(expectedMaxSize);
    }

    public Iterator iterator() {
        return this.map.keySet().iterator();
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    public boolean add(Object o) {
        return this.map.put(o, Objects.UNKNOWN) == null;
    }

    public boolean remove(Object o) {
        return this.map.remove(o) == Objects.UNKNOWN;
    }

    public void clear() {
        this.map.clear();
    }

    public Object clone() {
        try {
            IdentityHashSet newSet = (IdentityHashSet)super.clone();
            newSet.map = (IdentityHashMap)this.map.clone();
            return newSet;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.map.size());
        Iterator i = this.map.keySet().iterator();
        while (i.hasNext()) {
            s.writeObject(i.next());
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int size = s.readInt();
        this.map = new IdentityHashMap(size * 4 / 3);
        for (int i = 0; i < size; ++i) {
            Object e = s.readObject();
            this.map.put(e, Objects.UNKNOWN);
        }
    }
}

