/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.sound;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.zkoss.sound.Audio;
import org.zkoss.util.media.ContentTypes;

public class AAudio
implements Audio {
    protected final byte[] _data;
    protected final InputStream _isdata;
    protected final String _format;
    protected final String _ctype;
    protected final String _name;

    public AAudio(String name, byte[] data) throws IOException {
        String format;
        block3: {
            if (data == null) {
                throw new IllegalArgumentException("null data");
            }
            this._name = name;
            this._data = data;
            this._isdata = null;
            format = null;
            try {
                format = AudioSystem.getAudioFileFormat(new ByteArrayInputStream(data)).getType().getExtension();
            }
            catch (UnsupportedAudioFileException ex) {
                format = AAudio.getFormatByName(this._name);
                if (format != null) break block3;
                throw (IOException)new IOException().initCause(ex);
            }
        }
        this._format = format;
        this._ctype = AAudio.getContentType(this._format);
    }

    public AAudio(String name, InputStream data) throws IOException {
        String format;
        block3: {
            if (data == null) {
                throw new IllegalArgumentException("null data");
            }
            this._name = name;
            this._isdata = data;
            this._data = null;
            format = null;
            try {
                format = AudioSystem.getAudioFileFormat(data).getType().getExtension();
            }
            catch (UnsupportedAudioFileException ex) {
                format = AAudio.getFormatByName(this._name);
                if (format != null) break block3;
                throw (IOException)new IOException().initCause(ex);
            }
        }
        this._format = format;
        this._ctype = AAudio.getContentType(this._format);
    }

    public AAudio(URL url) throws IOException {
        String format;
        block3: {
            if (url == null) {
                throw new IllegalArgumentException("null url");
            }
            this._name = AAudio.getName(url);
            this._isdata = url.openStream();
            this._data = null;
            format = null;
            try {
                format = AudioSystem.getAudioFileFormat(url).getType().getExtension();
            }
            catch (UnsupportedAudioFileException ex) {
                format = AAudio.getFormatByName(this._name);
                if (format != null) break block3;
                throw (IOException)new IOException().initCause(ex);
            }
        }
        this._format = format;
        this._ctype = AAudio.getContentType(this._format);
    }

    public AAudio(File file) throws IOException {
        String format;
        block3: {
            if (file == null) {
                throw new IllegalArgumentException("null url");
            }
            this._name = file.getName();
            this._isdata = new FileInputStream(file);
            this._data = null;
            format = null;
            try {
                format = AudioSystem.getAudioFileFormat(file).getType().getExtension();
            }
            catch (UnsupportedAudioFileException ex) {
                format = AAudio.getFormatByName(this._name);
                if (format != null) break block3;
                throw (IOException)new IOException().initCause(ex);
            }
        }
        this._format = format;
        this._ctype = AAudio.getContentType(this._format);
    }

    public AAudio(String filename) throws IOException {
        this(new File(filename));
    }

    public AAudio(InputStream is) throws IOException {
        this(null, is);
    }

    private static String getName(URL url) {
        String name = url.getPath();
        if (name != null) {
            int j = name.lastIndexOf(File.pathSeparatorChar);
            if (j >= 0) {
                name = name.substring(j + 1);
            }
            if (File.pathSeparatorChar != '/' && (j = name.lastIndexOf(47)) >= 0) {
                name = name.substring(j + 1);
            }
        }
        return name;
    }

    private static String getContentType(String format) {
        String ctype = ContentTypes.getContentType(format);
        return ctype != null ? ctype : "audio/" + format;
    }

    private static String getFormatByName(String name) {
        int k;
        int j;
        if (name != null && (j = name.lastIndexOf(46) + 1) > (k = name.lastIndexOf(47) + 1) && j < name.length()) {
            return name.substring(j);
        }
        return null;
    }

    public final boolean isBinary() {
        return true;
    }

    public final boolean inMemory() {
        return this._data != null;
    }

    public byte[] getByteData() {
        if (this._data == null) {
            throw new IllegalStateException("Use getStreamData() instead");
        }
        return this._data;
    }

    public final String getStringData() {
        throw this.newIllegalStateException();
    }

    public InputStream getStreamData() {
        if (this._isdata != null) {
            return this._isdata;
        }
        return new ByteArrayInputStream(this._data);
    }

    public final Reader getReaderData() {
        throw this.newIllegalStateException();
    }

    private final IllegalStateException newIllegalStateException() {
        return new IllegalStateException(this._isdata != null ? "Use getStreamData() instead" : "Use getByteData() instead");
    }

    public final String getName() {
        return this._name;
    }

    public final String getFormat() {
        return this._format;
    }

    public final String getContentType() {
        return this._ctype;
    }
}

