/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.el;

import java.io.Writer;
import java.util.Enumeration;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.ExpressionEvaluator;
import javax.servlet.jsp.el.VariableResolver;
import javax.servlet.jsp.tagext.BodyContent;
import org.zkoss.el.EvaluatorImpl;
import org.zkoss.el.impl.AttributesMap;

public class ServletContextResolver
implements VariableResolver {
    private final ServletContext _ctx;
    private PageContextImpl _pc;

    public ServletContextResolver(ServletContext ctx) {
        if (ctx == null) {
            throw new NullPointerException();
        }
        this._ctx = ctx;
    }

    public PageContext getPageContext() {
        if (this._pc == null) {
            this._pc = new PageContextImpl();
        }
        return this._pc;
    }

    public ServletRequest getRequest() {
        throw new IllegalStateException("You cannot access request or session here");
    }

    public ServletResponse getResponse() {
        throw new IllegalStateException("You cannot access response here");
    }

    public ServletContext getServletContext() {
        return this._ctx;
    }

    public Object resolveVariable(String pName) throws ELException {
        if ("pageContext".equals(pName)) {
            return this.getPageContext();
        }
        if ("pageScope".equals(pName) || "requestScope".equals(pName) || "sessionScope".equals(pName) || "param".equals(pName) || "paramValues".equals(pName) || "header".equals(pName) || "headerValues".equals(pName) || "cookie".equals(pName)) {
            throw new IllegalStateException("You cannot access request or session here");
        }
        if ("applicationScope".equals(pName)) {
            return new AttributesMap(){

                protected Enumeration getKeys() {
                    return ServletContextResolver.this._ctx.getAttributeNames();
                }

                protected Object getValue(String key) {
                    return ServletContextResolver.this._ctx.getAttribute(key);
                }

                protected void setValue(String key, Object val) {
                    ServletContextResolver.this._ctx.setAttribute(key, val);
                }

                protected void removeValue(String key) {
                    ServletContextResolver.this._ctx.removeAttribute(key);
                }
            };
        }
        if ("initParam".equals(pName)) {
            return new AttributesMap(){

                protected Enumeration getKeys() {
                    return ServletContextResolver.this._ctx.getInitParameterNames();
                }

                protected Object getValue(String key) {
                    return ServletContextResolver.this._ctx.getInitParameter(key);
                }
            };
        }
        return this._ctx.getAttribute(pName);
    }

    private class PageContextImpl
    extends PageContext {
        private PageContextImpl() {
        }

        public Exception getException() {
            return null;
        }

        public Object getPage() {
            throw new IllegalStateException("You cannot access request or session here");
        }

        public ServletRequest getRequest() {
            throw new IllegalStateException("You cannot access request or session here");
        }

        public ServletResponse getResponse() {
            throw new IllegalStateException("You cannot access response here");
        }

        public ServletConfig getServletConfig() {
            return null;
        }

        public ServletContext getServletContext() {
            return ServletContextResolver.this._ctx;
        }

        public HttpSession getSession() {
            throw new IllegalStateException("You cannot access request or session here");
        }

        public VariableResolver getVariableResolver() {
            return ServletContextResolver.this;
        }

        public ExpressionEvaluator getExpressionEvaluator() {
            return new EvaluatorImpl();
        }

        public void forward(String relativeUrlPath) {
            throw new UnsupportedOperationException();
        }

        public void include(String relativeUrlPath) {
            throw new UnsupportedOperationException();
        }

        public void include(String relativeUrlPath, boolean flush) {
            throw new UnsupportedOperationException();
        }

        public void handlePageException(Exception e) {
            throw new UnsupportedOperationException();
        }

        public void handlePageException(Throwable e) {
            throw new UnsupportedOperationException();
        }

        public void initialize(Servlet servlet, ServletRequest request, ServletResponse response, String errorPageURL, boolean needsSession, int bufferSize, boolean autoFlush) {
        }

        public BodyContent pushBody() {
            throw new UnsupportedOperationException();
        }

        public void release() {
        }

        public Object findAttribute(String name) {
            throw new UnsupportedOperationException();
        }

        public Object getAttribute(String name) {
            throw new UnsupportedOperationException();
        }

        public Object getAttribute(String name, int scope) {
            throw new UnsupportedOperationException();
        }

        public Enumeration getAttributeNamesInScope(int scope) {
            throw new UnsupportedOperationException();
        }

        public int getAttributesScope(String name) {
            throw new UnsupportedOperationException();
        }

        public JspWriter getOut() {
            throw new UnsupportedOperationException();
        }

        public JspWriter popBody() {
            throw new UnsupportedOperationException();
        }

        public JspWriter pushBody(Writer writer) {
            throw new UnsupportedOperationException();
        }

        public void removeAttribute(String name) {
            throw new UnsupportedOperationException();
        }

        public void removeAttribute(String name, int scope) {
            throw new UnsupportedOperationException();
        }

        public void setAttribute(String name, Object value) {
            throw new UnsupportedOperationException();
        }

        public void setAttribute(String name, Object value, int scope) {
            throw new UnsupportedOperationException();
        }
    }
}

