/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.elytron.credentialstore;

import org.wildfly.extras.creaper.core.ServerVersion;
import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Operations;
import org.wildfly.extras.creaper.core.online.operations.Values;

public final class RemoveCredentialStoreAlias
implements OnlineCommand {
    private final String credentialStoreName;
    private final String credentialStoreAlias;

    public RemoveCredentialStoreAlias(String credentialStoreName, String credentialStoreAlias) {
        if (credentialStoreName == null) {
            throw new IllegalArgumentException("Name of the credential-store must be specified as non null value");
        }
        if (credentialStoreName.isEmpty()) {
            throw new IllegalArgumentException("Name of the credential-store must not be empty value");
        }
        if (credentialStoreAlias == null) {
            throw new IllegalArgumentException("Alias of the credential-store must be specified as non null value");
        }
        if (credentialStoreAlias.isEmpty()) {
            throw new IllegalArgumentException("Alias of the credential-store must not be empty value");
        }
        this.credentialStoreName = credentialStoreName;
        this.credentialStoreAlias = credentialStoreAlias;
    }

    public void apply(OnlineCommandContext ctx) throws Exception {
        if (ctx.version.lessThan(ServerVersion.VERSION_5_0_0)) {
            throw new AssertionError((Object)"Elytron is available since WildFly 11.");
        }
        Address credentialStoreAddress = Address.subsystem((String)"elytron").and("credential-store", this.credentialStoreName);
        Operations ops = new Operations(ctx.client);
        ops.invoke("remove-alias", credentialStoreAddress, Values.empty().and("alias", this.credentialStoreAlias));
    }
}

