/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.watchmaker.framework.operators;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.uncommons.maths.number.NumberGenerator;
import org.uncommons.maths.random.Probability;
import org.uncommons.watchmaker.framework.operators.AbstractCrossover;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharArrayCrossover
extends AbstractCrossover<char[]> {
    public CharArrayCrossover() {
        this(1);
    }

    public CharArrayCrossover(int crossoverPoints) {
        super(crossoverPoints);
    }

    public CharArrayCrossover(int crossoverPoints, Probability crossoverProbability) {
        super(crossoverPoints, crossoverProbability);
    }

    public CharArrayCrossover(NumberGenerator<Integer> crossoverPointsVariable) {
        super(crossoverPointsVariable);
    }

    public CharArrayCrossover(NumberGenerator<Integer> crossoverPointsVariable, NumberGenerator<Probability> crossoverProbabilityVariable) {
        super(crossoverPointsVariable, crossoverProbabilityVariable);
    }

    @Override
    protected List<char[]> mate(char[] parent1, char[] parent2, int numberOfCrossoverPoints, Random rng) {
        if (parent1.length != parent2.length) {
            throw new IllegalArgumentException("Cannot perform cross-over with different length parents.");
        }
        char[] offspring1 = new char[parent1.length];
        System.arraycopy(parent1, 0, offspring1, 0, parent1.length);
        char[] offspring2 = new char[parent2.length];
        System.arraycopy(parent2, 0, offspring2, 0, parent2.length);
        char[] temp = new char[parent1.length];
        for (int i = 0; i < numberOfCrossoverPoints; ++i) {
            int crossoverIndex = 1 + rng.nextInt(parent1.length - 1);
            System.arraycopy(offspring1, 0, temp, 0, crossoverIndex);
            System.arraycopy(offspring2, 0, offspring1, 0, crossoverIndex);
            System.arraycopy(temp, 0, offspring2, 0, crossoverIndex);
        }
        ArrayList<char[]> result = new ArrayList<char[]>(2);
        result.add(offspring1);
        result.add(offspring2);
        return result;
    }
}

