/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.graphics;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.jdesktop.swingx.image.StackBlurFilter;
import org.jdesktop.swingx.util.GraphicsUtilities;

public class ReflectionRenderer {
    public static final String OPACITY_CHANGED_PROPERTY = "reflection_opacity";
    public static final String LENGTH_CHANGED_PROPERTY = "reflection_length";
    public static final String BLUR_ENABLED_CHANGED_PROPERTY = "reflection_blur";
    private float opacity;
    private float length;
    private boolean blurEnabled;
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private StackBlurFilter stackBlurFilter = new StackBlurFilter(1);

    public ReflectionRenderer() {
        this(0.35f, 0.4f, false);
    }

    public ReflectionRenderer(float opacity) {
        this(opacity, 0.4f, false);
    }

    public ReflectionRenderer(float opacity, float length, boolean blurEnabled) {
        this.setOpacity(opacity);
        this.setLength(length);
        this.setBlurEnabled(blurEnabled);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public float getOpacity() {
        return this.opacity;
    }

    public void setOpacity(float opacity) {
        float oldOpacity = this.opacity;
        if (opacity < 0.0f) {
            opacity = 0.0f;
        } else if (opacity > 1.0f) {
            opacity = 1.0f;
        }
        if (oldOpacity != opacity) {
            this.opacity = opacity;
            this.changeSupport.firePropertyChange(OPACITY_CHANGED_PROPERTY, Float.valueOf(oldOpacity), Float.valueOf(this.opacity));
        }
    }

    public float getLength() {
        return this.length;
    }

    public void setLength(float length) {
        float oldLength = this.length;
        if (length < 0.0f) {
            length = 0.0f;
        } else if (length > 1.0f) {
            length = 1.0f;
        }
        if (oldLength != length) {
            this.length = length;
            this.changeSupport.firePropertyChange(LENGTH_CHANGED_PROPERTY, Float.valueOf(oldLength), Float.valueOf(this.length));
        }
    }

    public boolean isBlurEnabled() {
        return this.blurEnabled;
    }

    public void setBlurEnabled(boolean blurEnabled) {
        if (blurEnabled != this.blurEnabled) {
            boolean oldBlur = this.blurEnabled;
            this.blurEnabled = blurEnabled;
            this.changeSupport.firePropertyChange(BLUR_ENABLED_CHANGED_PROPERTY, oldBlur, this.blurEnabled);
        }
    }

    public int getEffectiveBlurRadius() {
        return this.stackBlurFilter.getEffectiveRadius();
    }

    public int getBlurRadius() {
        return this.stackBlurFilter.getRadius();
    }

    public void setBlurRadius(int radius) {
        this.stackBlurFilter = new StackBlurFilter(radius);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage appendReflection(BufferedImage image) {
        BufferedImage reflection = this.createReflection(image);
        BufferedImage buffer = GraphicsUtilities.createCompatibleTranslucentImage((int)reflection.getWidth(), (int)(image.getHeight() + reflection.getHeight()));
        Graphics2D g2 = buffer.createGraphics();
        try {
            int effectiveRadius = this.isBlurEnabled() ? this.stackBlurFilter.getEffectiveRadius() : 0;
            g2.drawImage((Image)image, effectiveRadius, 0, null);
            g2.drawImage((Image)reflection, 0, image.getHeight() - effectiveRadius, null);
        }
        finally {
            g2.dispose();
        }
        reflection.flush();
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage createReflection(BufferedImage image) {
        if (this.length == 0.0f) {
            return GraphicsUtilities.createCompatibleTranslucentImage((int)1, (int)1);
        }
        int blurOffset = this.isBlurEnabled() ? this.stackBlurFilter.getEffectiveRadius() : 0;
        int height = (int)((float)image.getHeight() * this.length);
        BufferedImage buffer = GraphicsUtilities.createCompatibleTranslucentImage((int)(image.getWidth() + blurOffset * 2), (int)(height + blurOffset * 2));
        Graphics2D g2 = buffer.createGraphics();
        try {
            g2.translate(0, image.getHeight());
            g2.scale(1.0, -1.0);
            g2.drawImage((Image)image, blurOffset, -blurOffset, null);
            g2.scale(1.0, -1.0);
            g2.translate(0, -image.getHeight());
            g2.setComposite(AlphaComposite.DstIn);
            g2.setPaint(new GradientPaint(0.0f, 0.0f, new Color(0.0f, 0.0f, 0.0f, this.getOpacity()), 0.0f, buffer.getHeight(), new Color(0.0f, 0.0f, 0.0f, 0.0f), true));
            g2.fillRect(0, 0, buffer.getWidth(), buffer.getHeight());
        }
        finally {
            g2.dispose();
        }
        return this.isBlurEnabled() ? this.stackBlurFilter.filter(buffer, null) : buffer;
    }
}

