/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.BeanDefinitionReader;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.ClassUtils;

public abstract class AbstractBeanDefinitionReader
implements BeanDefinitionReader {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final BeanDefinitionRegistry beanFactory;
    private ResourceLoader resourceLoader;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();

    protected AbstractBeanDefinitionReader(BeanDefinitionRegistry beanFactory) {
        this.beanFactory = beanFactory;
        this.resourceLoader = this.beanFactory instanceof ResourceLoader ? (ResourceLoader)((Object)this.beanFactory) : new PathMatchingResourcePatternResolver();
    }

    public BeanDefinitionRegistry getBeanFactory() {
        return this.beanFactory;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }

    public ClassLoader getBeanClassLoader() {
        return this.beanClassLoader;
    }

    public int loadBeanDefinitions(Resource[] resources) throws BeansException {
        int counter = 0;
        for (int i = 0; i < resources.length; ++i) {
            counter += this.loadBeanDefinitions(resources[i]);
        }
        return counter;
    }

    public int loadBeanDefinitions(String location) throws BeanDefinitionStoreException {
        ResourceLoader resourceLoader = this.getResourceLoader();
        if (resourceLoader == null) {
            throw new BeanDefinitionStoreException("Cannot import bean definitions from location [" + location + "]: no ResourceLoader available");
        }
        if (resourceLoader instanceof ResourcePatternResolver) {
            try {
                Resource[] resources = ((ResourcePatternResolver)resourceLoader).getResources(location);
                int loadCount = this.loadBeanDefinitions(resources);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Loaded " + loadCount + " bean definitions from location pattern [" + location + "]"));
                }
                return loadCount;
            }
            catch (IOException ex) {
                throw new BeanDefinitionStoreException("Could not resolve bean definition resource pattern [" + location + "]", ex);
            }
        }
        Resource resource = resourceLoader.getResource(location);
        int loadCount = this.loadBeanDefinitions(resource);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Loaded " + loadCount + " bean definitions from location [" + location + "]"));
        }
        return loadCount;
    }
}

