/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.toplink;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.TopLinkException;
import oracle.toplink.sessions.Session;
import oracle.toplink.sessions.UnitOfWork;
import oracle.toplink.threetier.ClientSession;
import oracle.toplink.threetier.ConnectionPolicy;
import oracle.toplink.threetier.ServerSession;
import org.springframework.orm.toplink.SessionFactory;
import org.springframework.orm.toplink.SessionFactoryUtils;

public class ServerSessionFactory
implements SessionFactory {
    private final ServerSession serverSession;
    static /* synthetic */ Class class$oracle$toplink$sessions$Session;

    public ServerSessionFactory(ServerSession serverSession) {
        this.serverSession = serverSession;
    }

    public Session createSession() {
        return this.serverSession.acquireClientSession();
    }

    public Session createManagedClientSession() {
        return new ManagedClientSession(this.serverSession, this.serverSession.getDefaultConnectionPolicy());
    }

    public Session createTransactionAwareSession() throws TopLinkException {
        return this.createTransactionAwareSession(this);
    }

    public Session createTransactionAwareSession(SessionFactory sessionFactory) throws TopLinkException {
        return (Session)Proxy.newProxyInstance((class$oracle$toplink$sessions$Session == null ? (class$oracle$toplink$sessions$Session = ServerSessionFactory.class$("oracle.toplink.sessions.Session")) : class$oracle$toplink$sessions$Session).getClassLoader(), new Class[]{class$oracle$toplink$sessions$Session == null ? (class$oracle$toplink$sessions$Session = ServerSessionFactory.class$("oracle.toplink.sessions.Session")) : class$oracle$toplink$sessions$Session}, (InvocationHandler)new TransactionAwareInvocationHandler(sessionFactory, (Session)this.serverSession));
    }

    public void close() {
        this.serverSession.logout();
        this.serverSession.release();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class TransactionAwareInvocationHandler
    implements InvocationHandler {
        private final SessionFactory sessionFactory;
        private final Session target;

        public TransactionAwareInvocationHandler(SessionFactory sessionFactory, Session target) {
            this.sessionFactory = sessionFactory;
            this.target = target;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("getActiveSession")) {
                try {
                    return SessionFactoryUtils.doGetSession(this.sessionFactory, false);
                }
                catch (IllegalStateException ex) {
                    return this.target;
                }
            }
            if (method.getName().equals("getActiveUnitOfWork")) {
                try {
                    return SessionFactoryUtils.doGetSession(this.sessionFactory, false).getActiveUnitOfWork();
                }
                catch (IllegalStateException ex) {
                    return null;
                }
            }
            if (method.getName().equals("equals")) {
                return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
            }
            if (method.getName().equals("hashCode")) {
                return new Integer(this.hashCode());
            }
            try {
                return method.invoke((Object)this.target, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }

    private static class ManagedClientSession
    extends ClientSession {
        private final UnitOfWork activeUnitOfWork = this.acquireUnitOfWork();

        public ManagedClientSession(ServerSession server, ConnectionPolicy connectionPolicy) {
            super(server, connectionPolicy);
        }

        public Session getActiveSession() {
            return this;
        }

        public UnitOfWork getActiveUnitOfWork() {
            return this.activeUnitOfWork;
        }

        public void release() throws DatabaseException {
            this.activeUnitOfWork.release();
            super.release();
        }
    }
}

