/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.json;

import org.json.JSONException;
import org.jspecify.annotations.Nullable;
import org.skyscreamer.jsonassert.JSONCompare;
import org.skyscreamer.jsonassert.JSONCompareMode;
import org.skyscreamer.jsonassert.JSONCompareResult;
import org.skyscreamer.jsonassert.comparator.DefaultComparator;
import org.skyscreamer.jsonassert.comparator.JSONComparator;
import org.springframework.test.json.JsonComparator;
import org.springframework.test.json.JsonCompareMode;
import org.springframework.test.json.JsonComparison;

public abstract class JsonAssert {
    public static JsonComparator comparator(JsonCompareMode compareMode) {
        JSONCompareMode jsonAssertCompareMode = compareMode != JsonCompareMode.LENIENT ? JSONCompareMode.STRICT : JSONCompareMode.LENIENT;
        return JsonAssert.comparator(jsonAssertCompareMode);
    }

    public static JsonComparator comparator(JSONComparator comparator) {
        return new JsonAssertJsonComparator(comparator);
    }

    public static JsonComparator comparator(JSONCompareMode mode) {
        return new JsonAssertJsonComparator(mode);
    }

    private static class JsonAssertJsonComparator
    implements JsonComparator {
        private final JSONComparator jsonAssertComparator;

        JsonAssertJsonComparator(JSONComparator jsonAssertComparator) {
            this.jsonAssertComparator = jsonAssertComparator;
        }

        JsonAssertJsonComparator(JSONCompareMode compareMode) {
            this((JSONComparator)new DefaultComparator(compareMode));
        }

        @Override
        public JsonComparison compare(@Nullable String expectedJson, @Nullable String actualJson) {
            if (actualJson == null) {
                return expectedJson != null ? JsonComparison.mismatch("Expected null JSON") : JsonComparison.match();
            }
            if (expectedJson == null) {
                return JsonComparison.mismatch("Expected non-null JSON");
            }
            try {
                JSONCompareResult result = JSONCompare.compareJSON((String)expectedJson, (String)actualJson, (JSONComparator)this.jsonAssertComparator);
                return !result.passed() ? JsonComparison.mismatch(result.getMessage()) : JsonComparison.match();
            }
            catch (JSONException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }
}

