/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource.embedded;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseConfigurer;
import org.springframework.jdbc.support.JdbcUtils;

abstract class AbstractEmbeddedDatabaseConfigurer
implements EmbeddedDatabaseConfigurer {
    protected final Log logger = LogFactory.getLog(this.getClass());

    AbstractEmbeddedDatabaseConfigurer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(DataSource dataSource, String databaseName) {
        block17: {
            Connection con = null;
            try {
                con = dataSource.getConnection();
                if (con == null) break block17;
                try (Statement stmt = con.createStatement();){
                    stmt.execute("SHUTDOWN");
                }
            }
            catch (SQLException ex) {
                this.logger.info((Object)"Could not shut down embedded database", (Throwable)ex);
            }
            finally {
                JdbcUtils.closeConnection(con);
            }
        }
    }
}

