/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.propertyeditors;

import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.ClassUtils;

public class URIEditor
extends PropertyEditorSupport {
    private final ClassLoader classLoader;

    public URIEditor() {
        this.classLoader = ClassUtils.getDefaultClassLoader();
    }

    public URIEditor(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setAsText(String text) throws IllegalArgumentException {
        if (text == null) {
            this.setValue(null);
        } else {
            if (text.startsWith("classpath:")) {
                ClassPathResource resource = new ClassPathResource(text.substring("classpath:".length()), this.classLoader);
                try {
                    this.setValue(new URI(resource.getURL().toString()));
                }
                catch (IOException ex) {
                    throw new IllegalArgumentException("Could not retrieve URI for " + resource + ": " + ex.getMessage());
                }
                catch (URISyntaxException ex) {
                    throw new IllegalArgumentException("Invalid URI syntax: " + ex);
                }
            }
            try {
                this.setValue(new URI(text));
            }
            catch (URISyntaxException ex) {
                throw new IllegalArgumentException("Invalid URI syntax: " + ex);
            }
        }
    }

    public String getAsText() {
        URI value = (URI)this.getValue();
        return value != null ? value.toString() : "";
    }
}

