/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.preauth.x509;

import java.security.cert.X509Certificate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.core.log.LogMessage;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.SpringSecurityMessageSource;
import org.springframework.security.web.authentication.preauth.x509.X509PrincipalExtractor;
import org.springframework.util.Assert;

public final class SubjectX500PrincipalExtractor
implements X509PrincipalExtractor,
MessageSourceAware {
    private final Log logger = LogFactory.getLog(this.getClass());
    private static final Pattern EMAIL_SUBJECT_DN_PATTERN = Pattern.compile("OID.1.2.840.113549.1.9.1=(.*?)(?:,|$)", 2);
    private static final Pattern CN_SUBJECT_DN_PATTERN = Pattern.compile("CN=(.*?)(?:,|$)", 2);
    private MessageSourceAccessor messages = SpringSecurityMessageSource.getAccessor();
    private Pattern subjectDnPattern = CN_SUBJECT_DN_PATTERN;
    private String x500PrincipalFormat = "RFC2253";

    @Override
    public Object extractPrincipal(X509Certificate clientCert) {
        Assert.notNull((Object)clientCert, (String)"clientCert cannot be null");
        X500Principal principal = clientCert.getSubjectX500Principal();
        String subjectDN = principal.getName(this.x500PrincipalFormat);
        this.logger.debug((Object)LogMessage.format((String)"Subject DN is '%s'", (Object)subjectDN));
        Matcher matcher = this.subjectDnPattern.matcher(subjectDN);
        if (!matcher.find()) {
            throw new BadCredentialsException(this.messages.getMessage("SubjectX500PrincipalExtractor.noMatching", new Object[]{subjectDN}, "No matching pattern was found in subject DN: {0}"));
        }
        String principalName = matcher.group(1);
        this.logger.debug((Object)LogMessage.format((String)"Extracted Principal name is '%s'", (Object)principalName));
        return principalName;
    }

    public void setMessageSource(MessageSource messageSource) {
        Assert.notNull((Object)messageSource, (String)"messageSource cannot be null");
        this.messages = new MessageSourceAccessor(messageSource);
    }

    public void setExtractPrincipalNameFromEmail(boolean extractPrincipalNameFromEmail) {
        if (extractPrincipalNameFromEmail) {
            this.subjectDnPattern = EMAIL_SUBJECT_DN_PATTERN;
            this.x500PrincipalFormat = "RFC1779";
        } else {
            this.subjectDnPattern = CN_SUBJECT_DN_PATTERN;
            this.x500PrincipalFormat = "RFC2253";
        }
    }
}

